/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;

public class PolicyVerificationOutInterceptor
extends AbstractPolicyInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyVerificationOutInterceptor.class);

    public PolicyVerificationOutInterceptor() {
        super("post-stream");
    }

    protected void handle(Message message) {
        if (MessageUtils.isPartialResponse(message)) {
            LOG.fine("Not verifying policies on outbound partial response.");
            return;
        }
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        if (null == aim) {
            return;
        }
        this.getTransportAssertions(message);
        EffectivePolicy policy = message.get(EffectivePolicy.class);
        if (policy == null) {
            return;
        }
        aim.checkEffectivePolicy(policy.getPolicy());
        LOG.fine("Verified policies for outbound message.");
    }
}

