/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JAXBUtils {
    private JAXBUtils() {
    }

    private static Node innerJaxbBinding(Element schema) {
        String schemaNamespace = schema.getNamespaceURI();
        NodeList annoList = schema.getElementsByTagNameNS(schemaNamespace, "annotation");
        Element annotation = null;
        annotation = annoList.getLength() > 0 ? (Element)annoList.item(0) : schema.getOwnerDocument().createElementNS(schemaNamespace, "annotation");
        NodeList appList = annotation.getElementsByTagNameNS(schemaNamespace, "appinfo");
        Element appInfo = null;
        if (appList.getLength() > 0) {
            appInfo = (Element)appList.item(0);
        } else {
            appInfo = schema.getOwnerDocument().createElementNS(schemaNamespace, "appinfo");
            annotation.appendChild(appInfo);
        }
        Element jaxbBindings = null;
        NodeList jaxbList = schema.getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "schemaBindings");
        if (jaxbList.getLength() > 0) {
            jaxbBindings = (Element)jaxbList.item(0);
        } else {
            jaxbBindings = schema.getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/jaxb", "schemaBindings");
            appInfo.appendChild(jaxbBindings);
        }
        return jaxbBindings;
    }

    public static Node innerJaxbPackageBinding(Element schema, String packagevalue) {
        Document doc = schema.getOwnerDocument();
        if (!XMLUtils.hasAttribute(schema, "http://java.sun.com/xml/ns/jaxb")) {
            schema.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "version", "2.0");
        }
        Node schemaBindings = JAXBUtils.innerJaxbBinding(schema);
        NodeList pkgList = doc.getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "package");
        Element packagename = null;
        packagename = pkgList.getLength() > 0 ? (Element)pkgList.item(0) : doc.createElementNS("http://java.sun.com/xml/ns/jaxb", "package");
        packagename.setAttribute("name", packagevalue);
        schemaBindings.appendChild(packagename);
        return schemaBindings.getParentNode().getParentNode();
    }

    public static File getPackageMappingSchemaBindingFile(String namespace, String pkgName) {
        Document doc = DOMUtils.createDocument();
        Element rootElement = doc.createElement("schema");
        rootElement.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        rootElement.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
        rootElement.setAttribute("jaxb:version", "2.0");
        rootElement.setAttribute("targetNamespace", namespace);
        Element annoElement = doc.createElement("annotation");
        Element appInfo = doc.createElement("appinfo");
        Element schemaBindings = doc.createElement("jaxb:schemaBindings");
        Element pkgElement = doc.createElement("jaxb:package");
        pkgElement.setAttribute("name", pkgName);
        annoElement.appendChild(appInfo);
        appInfo.appendChild(schemaBindings);
        schemaBindings.appendChild(pkgElement);
        rootElement.appendChild(annoElement);
        File tmpFile = null;
        try {
            tmpFile = FileUtils.createTempFile("customzied", ".xsd");
            FileOutputStream fout = new FileOutputStream(tmpFile);
            DOMUtils.writeXml(rootElement, fout);
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmpFile;
    }
}

