/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc.processor;

import com.sun.tools.xjc.api.ErrorListener;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.validator.internal.WSDL11Validator;
import org.apache.cxf.wsdl.WSDLExtensibilityPlugin;
import org.apache.cxf.wsdl11.WSDLDefinitionBuilder;
import org.xml.sax.SAXParseException;

public class AbstractWSDLToProcessor
implements Processor,
ErrorListener {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractWSDLToProcessor.class);
    protected static final String WSDL_FILE_NAME_EXT = ".wsdl";
    protected Definition wsdlDefinition;
    protected ToolContext env;
    protected WSDLFactory wsdlFactory;
    protected WSDLReader wsdlReader;
    protected ClassCollector classColletor;
    List<Schema> schemaList = new ArrayList<Schema>();
    private final Map<String, WSDLExtensibilityPlugin> wsdlPlugins = new HashMap<String, WSDLExtensibilityPlugin>();

    protected Writer getOutputWriter(String newNameExt) throws ToolException {
        String outputDir;
        Writer writer = null;
        String newName = null;
        if (this.env.get("outputfile") != null) {
            newName = (String)this.env.get("outputfile");
        } else {
            String oldName = (String)this.env.get("wsdlurl");
            int position = oldName.lastIndexOf("/");
            if (position < 0) {
                position = oldName.lastIndexOf("\\");
            }
            if (position >= 0) {
                oldName = oldName.substring(position + 1, oldName.length());
            }
            newName = oldName.toLowerCase().indexOf(WSDL_FILE_NAME_EXT) >= 0 ? oldName.substring(0, oldName.length() - 5) + newNameExt + WSDL_FILE_NAME_EXT : oldName + newNameExt;
        }
        if (this.env.get("outputdir") != null) {
            outputDir = (String)this.env.get("outputdir");
            if (!"/".equals(outputDir.substring(outputDir.length() - 1)) && !"\\".equals(outputDir.substring(outputDir.length() - 1))) {
                outputDir = outputDir + "/";
            }
        } else {
            outputDir = "./";
        }
        FileWriterUtil fw = new FileWriterUtil(outputDir);
        try {
            writer = fw.getWriter("", newName);
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_WRITE_FILE", LOG, this.env.get("outputdir") + System.getProperty("file.seperator") + newName);
            throw new ToolException(msg, (Throwable)ioe);
        }
        return writer;
    }

    protected void parseWSDL(String wsdlURL) throws ToolException {
        WSDLDefinitionBuilder builder = new WSDLDefinitionBuilder(true);
        this.wsdlDefinition = builder.build(wsdlURL);
        this.wsdlReader = builder.getWSDLReader();
        this.wsdlFactory = builder.getWSDLFactory();
        this.wsdlPlugins.putAll(builder.getWSDLPlugins());
        LOG.log(Level.INFO, "FOUND_WSDL_PLUGINS", this.wsdlPlugins.keySet());
    }

    public WSDLExtensibilityPlugin getWSDLPlugin(String key, Class clz) {
        StringBuffer sb = new StringBuffer();
        sb.append(key);
        sb.append("-");
        sb.append(clz.getName());
        WSDLExtensibilityPlugin plugin = this.wsdlPlugins.get(sb.toString());
        if (plugin == null) {
            throw new ToolException(new Message("FOUND_NO_WSDL_PLUGIN", LOG, sb.toString(), clz));
        }
        return plugin;
    }

    protected void init() throws ToolException {
    }

    public Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    public void process() throws ToolException {
    }

    public void validateWSDL() throws ToolException {
        if (this.env.validateWSDL()) {
            WSDL11Validator validator = new WSDL11Validator(this.wsdlDefinition, this.env);
            validator.isValid();
        }
    }

    public void setEnvironment(ToolContext penv) {
        this.env = penv;
    }

    public ToolContext getEnvironment() {
        return this.env;
    }

    public void error(SAXParseException exception) {
        if (this.env.isVerbose()) {
            exception.printStackTrace();
        } else {
            System.err.println("Parsing schema error: \n" + exception.toString());
        }
    }

    public void fatalError(SAXParseException exception) {
        if (this.env.isVerbose()) {
            exception.printStackTrace();
        } else {
            System.err.println("Parsing schema fatal error: \n" + exception.toString());
        }
    }

    public void info(SAXParseException exception) {
        if (this.env.isVerbose()) {
            System.err.println("Parsing schema info: " + exception.toString());
        }
    }

    public void warning(SAXParseException exception) {
        if (this.env.isVerbose()) {
            System.err.println("Parsing schema warning " + exception.toString());
        }
    }
}

