/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.LargeMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;

public class PoissonSampler
extends SamplerBase
implements DiscreteSampler {
    static final double PIVOT = 40.0;
    private final DiscreteSampler poissonSampler;

    public PoissonSampler(UniformRandomProvider rng, double mean) {
        super(null);
        this.poissonSampler = mean < 40.0 ? new SmallMeanPoissonSampler(rng, mean) : new LargeMeanPoissonSampler(rng, mean);
    }

    @Override
    public int sample() {
        return this.poissonSampler.sample();
    }

    @Override
    public String toString() {
        return this.poissonSampler.toString();
    }
}

