/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.BoxMullerGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class AhrensDieterMarsagliaTsangGammaSampler
extends SamplerBase
implements ContinuousSampler {
    private final double theta;
    private final double alpha;
    private final BoxMullerGaussianSampler gaussian;

    public AhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider rng, double alpha, double theta) {
        super(rng);
        this.alpha = alpha;
        this.theta = theta;
        this.gaussian = new BoxMullerGaussianSampler(rng, 0.0, 1.0);
    }

    @Override
    public double sample() {
        double v;
        if (this.theta < 1.0) {
            double x;
            while (true) {
                double u2;
                double u;
                double bGS;
                double p;
                if ((p = (bGS = 1.0 + this.theta / Math.E) * (u = this.nextDouble())) <= 1.0) {
                    x = Math.pow(p, 1.0 / this.theta);
                    u2 = this.nextDouble();
                    if (u2 > Math.exp(-x)) continue;
                    return this.alpha * x;
                }
                x = -1.0 * Math.log((bGS - p) / this.theta);
                u2 = this.nextDouble();
                if (!(u2 > Math.pow(x, this.theta - 1.0))) break;
            }
            return this.alpha * x;
        }
        double d = this.theta - 0.3333333333333333;
        double c = 1.0 / (3.0 * Math.sqrt(d));
        while (true) {
            double x;
            if ((v = (1.0 + c * (x = this.gaussian.sample())) * (1.0 + c * x) * (1.0 + c * x)) <= 0.0) {
                continue;
            }
            double x2 = x * x;
            double u = this.nextDouble();
            if (u < 1.0 - 0.0331 * x2 * x2) {
                return this.alpha * d * v;
            }
            if (Math.log(u) < 0.5 * x2 + d * (1.0 - v + Math.log(v))) break;
        }
        return this.alpha * d * v;
    }

    @Override
    public String toString() {
        return "Ahrens-Dieter-Marsaglia-Tsang Gamma deviate [" + super.toString() + "]";
    }
}

