/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.sampling;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.examples.sampling.StandardOptions;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import org.apache.commons.rng.sampling.distribution.BoxMullerNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ChengBetaSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import org.apache.commons.rng.sampling.distribution.GaussianSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformParetoSampler;
import org.apache.commons.rng.sampling.distribution.LogNormalSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.apache.commons.rng.simple.RandomSource;
import picocli.CommandLine;

@CommandLine.Command(name="density", description={"Approximate the probability density of samplers."})
class ProbabilityDensityApproximationCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private StandardOptions reusableOptions;
    @CommandLine.Option(names={"-b", "--bins"}, description={"The number of bins in the histogram (default: ${DEFAULT-VALUE})."})
    private int numBins = 25000;
    @CommandLine.Option(names={"-n", "--samples"}, description={"The number of samples in the histogram (default: ${DEFAULT-VALUE})."})
    private long numSamples = 1000000000L;
    @CommandLine.Option(names={"-s", "--samplers"}, split=",", description={"The samplers (comma-delimited for multiple options).", "Valid values: ${COMPLETION-CANDIDATES}."})
    private EnumSet<Sampler> samplers = EnumSet.noneOf(Sampler.class);
    @CommandLine.Option(names={"-a", "--all"}, description={"Output all samplers"})
    private boolean allSamplers;

    ProbabilityDensityApproximationCommand() {
    }

    private void createDensity(ContinuousSampler sampler, double min, double max, String outputFile) throws IOException {
        double binSize = (max - min) / (double)this.numBins;
        long[] histogram = new long[this.numBins];
        long belowMin = 0L;
        long aboveMax = 0L;
        for (long n = 0L; n < this.numSamples; ++n) {
            int binIndex;
            double r = sampler.sample();
            if (r < min) {
                ++belowMin;
                continue;
            }
            if (r >= max) {
                ++aboveMax;
                continue;
            }
            int n2 = binIndex = (int)((r - min) / binSize);
            histogram[n2] = histogram[n2] + 1L;
        }
        double binHalfSize = 0.5 * binSize;
        double norm = 1.0 / (binSize * (double)this.numSamples);
        try (PrintWriter out = new PrintWriter(outputFile);){
            out.println("# Sampler: " + sampler);
            out.println("# Number of bins: " + this.numBins);
            out.println("# Min: " + min + " (fraction of samples below: " + (double)belowMin / (double)this.numSamples + ")");
            out.println("# Max: " + max + " (fraction of samples above: " + (double)aboveMax / (double)this.numSamples + ")");
            out.println("# Bin width: " + binSize);
            out.println("# Histogram normalization factor: " + norm);
            out.println("#");
            out.println("# " + (min - binHalfSize) + " " + (double)belowMin * norm);
            for (int i = 0; i < this.numBins; ++i) {
                out.println(min + (double)(i + 1) * binSize - binHalfSize + " " + (double)histogram[i] * norm);
            }
            out.println("# " + (max + binHalfSize) + " " + (double)aboveMax * norm);
        }
    }

    @Override
    public Void call() throws IOException {
        if (this.allSamplers) {
            this.samplers = EnumSet.allOf(Sampler.class);
        } else if (this.samplers.isEmpty()) {
            System.err.println("ERROR: No samplers specified");
            System.exit(1);
        }
        RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.XOR_SHIFT_1024_S_PHI);
        double gaussMean = 1.0;
        double gaussSigma = 2.0;
        double gaussMin = -9.0;
        double gaussMax = 11.0;
        if (this.samplers.contains((Object)Sampler.ZigguratGaussianSampler)) {
            this.createDensity((ContinuousSampler)GaussianSampler.of((NormalizedGaussianSampler)ZigguratNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)1.0, (double)2.0), -9.0, 11.0, "gauss.ziggurat.txt");
        }
        if (this.samplers.contains((Object)Sampler.MarsagliaGaussianSampler)) {
            this.createDensity((ContinuousSampler)GaussianSampler.of((NormalizedGaussianSampler)MarsagliaNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)1.0, (double)2.0), -9.0, 11.0, "gauss.marsaglia.txt");
        }
        if (this.samplers.contains((Object)Sampler.BoxMullerGaussianSampler)) {
            this.createDensity((ContinuousSampler)GaussianSampler.of((NormalizedGaussianSampler)BoxMullerNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)1.0, (double)2.0), -9.0, 11.0, "gauss.boxmuller.txt");
        }
        double betaMin = 0.0;
        double betaMax = 1.0;
        if (this.samplers.contains((Object)Sampler.ChengBetaSamplerCase1)) {
            double alphaBeta = 4.3;
            double betaBeta = 2.1;
            this.createDensity((ContinuousSampler)ChengBetaSampler.of((UniformRandomProvider)rng, (double)4.3, (double)2.1), 0.0, 1.0, "beta.case1.txt");
        }
        if (this.samplers.contains((Object)Sampler.ChengBetaSamplerCase2)) {
            double alphaBetaAlt = 0.5678;
            double betaBetaAlt = 0.1234;
            this.createDensity((ContinuousSampler)ChengBetaSampler.of((UniformRandomProvider)rng, (double)0.5678, (double)0.1234), 0.0, 1.0, "beta.case2.txt");
        }
        if (this.samplers.contains((Object)Sampler.AhrensDieterExponentialSampler)) {
            double meanExp = 3.45;
            double expMin = 0.0;
            double expMax = 60.0;
            this.createDensity((ContinuousSampler)AhrensDieterExponentialSampler.of((UniformRandomProvider)rng, (double)3.45), 0.0, 60.0, "exp.txt");
        }
        double gammaMin = 0.0;
        double gammaMax1 = 40.0;
        double thetaGamma = 3.456;
        if (this.samplers.contains((Object)Sampler.AhrensDieterMarsagliaTsangGammaSamplerCase1)) {
            double alphaGammaSmallerThanOne = 0.1234;
            this.createDensity((ContinuousSampler)AhrensDieterMarsagliaTsangGammaSampler.of((UniformRandomProvider)rng, (double)0.1234, (double)3.456), 0.0, 40.0, "gamma.case1.txt");
        }
        if (this.samplers.contains((Object)Sampler.AhrensDieterMarsagliaTsangGammaSamplerCase2)) {
            double alphaGammaLargerThanOne = 2.345;
            double gammaMax2 = 70.0;
            this.createDensity((ContinuousSampler)AhrensDieterMarsagliaTsangGammaSampler.of((UniformRandomProvider)rng, (double)2.345, (double)3.456), 0.0, 70.0, "gamma.case2.txt");
        }
        double scalePareto = 23.45;
        double shapePareto = 0.789;
        double paretoMin = 23.0;
        double paretoMax = 400.0;
        if (this.samplers.contains((Object)Sampler.InverseTransformParetoSampler)) {
            this.createDensity((ContinuousSampler)InverseTransformParetoSampler.of((UniformRandomProvider)rng, (double)23.45, (double)0.789), 23.0, 400.0, "pareto.txt");
        }
        double loUniform = -9.876;
        double hiUniform = 5.432;
        if (this.samplers.contains((Object)Sampler.ContinuousUniformSampler)) {
            this.createDensity((ContinuousSampler)ContinuousUniformSampler.of((UniformRandomProvider)rng, (double)-9.876, (double)5.432), -9.876, 5.432, "uniform.txt");
        }
        double scaleLogNormal = 2.345;
        double shapeLogNormal = 0.1234;
        double logNormalMin = 5.0;
        double logNormalMax = 25.0;
        if (this.samplers.contains((Object)Sampler.LogNormalZigguratGaussianSampler)) {
            this.createDensity((ContinuousSampler)LogNormalSampler.of((NormalizedGaussianSampler)ZigguratNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)2.345, (double)0.1234), 5.0, 25.0, "lognormal.ziggurat.txt");
        }
        if (this.samplers.contains((Object)Sampler.LogNormalMarsagliaGaussianSampler)) {
            this.createDensity((ContinuousSampler)LogNormalSampler.of((NormalizedGaussianSampler)MarsagliaNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)2.345, (double)0.1234), 5.0, 25.0, "lognormal.marsaglia.txt");
        }
        if (this.samplers.contains((Object)Sampler.LogNormalBoxMullerGaussianSampler)) {
            this.createDensity((ContinuousSampler)LogNormalSampler.of((NormalizedGaussianSampler)BoxMullerNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)2.345, (double)0.1234), 5.0, 25.0, "lognormal.boxmuller.txt");
        }
        return null;
    }

    static enum Sampler {
        ZigguratGaussianSampler,
        MarsagliaGaussianSampler,
        BoxMullerGaussianSampler,
        ChengBetaSamplerCase1,
        ChengBetaSamplerCase2,
        AhrensDieterExponentialSampler,
        AhrensDieterMarsagliaTsangGammaSamplerCase1,
        AhrensDieterMarsagliaTsangGammaSamplerCase2,
        InverseTransformParetoSampler,
        ContinuousUniformSampler,
        LogNormalZigguratGaussianSampler,
        LogNormalMarsagliaGaussianSampler,
        LogNormalBoxMullerGaussianSampler;

    }
}

