/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.sampling;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.BoxMullerNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.apache.commons.rng.simple.RandomSource;

public class UniformSamplingVisualCheck {
    private final UniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.XOR_SHIFT_1024_S);
    private final ContinuousSampler[] samplers = new ContinuousSampler[]{new ZigguratNormalizedGaussianSampler(this.rng), new MarsagliaNormalizedGaussianSampler(this.rng), new BoxMullerNormalizedGaussianSampler(this.rng)};

    public static void main(String[] args) {
        float lo = 0.1f;
        int bands = 2;
        float hi = 0.1f;
        for (int i = 0; i < 2; ++i) {
            hi = Math.nextUp(hi);
        }
        System.out.printf("# lo=%.10e hi=%.10e", Float.valueOf(0.1f), Float.valueOf(hi));
        System.out.println();
        UniformSamplingVisualCheck app = new UniformSamplingVisualCheck();
        while (true) {
            System.out.printf("%.16e\t", app.rng.nextDouble());
            for (ContinuousSampler s : app.samplers) {
                double r;
                while ((r = s.sample()) < (double)0.1f || r > (double)hi) {
                }
                System.out.printf("%.16e ", r);
            }
            System.out.println();
        }
    }
}

