/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.UsageTracking;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.BaseGenericObjectPool;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.DefaultPooledObjectInfo;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolMXBean;
import org.apache.commons.pool2.impl.LinkedBlockingDeque;
import org.apache.commons.pool2.impl.PoolImplUtils;

public class GenericObjectPool<T>
extends BaseGenericObjectPool<T>
implements ObjectPool<T>,
GenericObjectPoolMXBean,
UsageTracking<T> {
    public static final transient int[] __cobertura_counters;
    private volatile String factoryType;
    private volatile int maxIdle;
    private volatile int minIdle;
    private final PooledObjectFactory<T> factory;
    private final Map<BaseGenericObjectPool.IdentityWrapper<T>, PooledObject<T>> allObjects;
    private final AtomicLong createCount;
    private final LinkedBlockingDeque<PooledObject<T>> idleObjects;
    private static final String ONAME_BASE = "org.apache.commons.pool2:type=GenericObjectPool,name=";
    private volatile AbandonedConfig abandonedConfig;

    /*
     * WARNING - void declaration
     */
    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory) {
        void factory;
        int n = 0;
        __cobertura_counters[1] = __cobertura_counters[1] + 1;
        this((PooledObjectFactory<T>)factory, new GenericObjectPoolConfig());
        __cobertura_counters[2] = __cobertura_counters[2] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory, GenericObjectPoolConfig genericObjectPoolConfig) {
        void factory;
        void config;
        int n = 0;
        __cobertura_counters[3] = __cobertura_counters[3] + 1;
        super((BaseObjectPoolConfig)config, ONAME_BASE, config.getJmxNamePrefix());
        __cobertura_counters[549] = __cobertura_counters[549] + 1;
        this.factoryType = null;
        __cobertura_counters[575] = __cobertura_counters[575] + 1;
        this.maxIdle = 8;
        __cobertura_counters[576] = __cobertura_counters[576] + 1;
        this.minIdle = 0;
        __cobertura_counters[577] = __cobertura_counters[577] + 1;
        this.allObjects = new ConcurrentHashMap<BaseGenericObjectPool.IdentityWrapper<T>, PooledObject<T>>();
        __cobertura_counters[578] = __cobertura_counters[578] + 1;
        this.createCount = new AtomicLong(0L);
        __cobertura_counters[579] = __cobertura_counters[579] + 1;
        this.abandonedConfig = null;
        __cobertura_counters[4] = __cobertura_counters[4] + 1;
        n = 6;
        if (factory == null) {
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            n = 0;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            this.jmxUnregister();
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            throw new IllegalArgumentException("factory may not be null");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[9] = __cobertura_counters[9] + 1;
        this.factory = factory;
        __cobertura_counters[10] = __cobertura_counters[10] + 1;
        this.idleObjects = new LinkedBlockingDeque(config.getFairness());
        __cobertura_counters[11] = __cobertura_counters[11] + 1;
        this.setConfig((GenericObjectPoolConfig)config);
        __cobertura_counters[12] = __cobertura_counters[12] + 1;
        this.startEvictor(this.getTimeBetweenEvictionRunsMillis());
        __cobertura_counters[13] = __cobertura_counters[13] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory, GenericObjectPoolConfig genericObjectPoolConfig, AbandonedConfig abandonedConfig) {
        void abandonedConfig2;
        void config;
        void factory;
        int n = 0;
        __cobertura_counters[14] = __cobertura_counters[14] + 1;
        this((PooledObjectFactory<T>)factory, (GenericObjectPoolConfig)config);
        __cobertura_counters[15] = __cobertura_counters[15] + 1;
        this.setAbandonedConfig((AbandonedConfig)abandonedConfig2);
        __cobertura_counters[16] = __cobertura_counters[16] + 1;
    }

    @Override
    public int getMaxIdle() {
        int n = 0;
        __cobertura_counters[17] = __cobertura_counters[17] + 1;
        return this.maxIdle;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxIdle(int n) {
        void maxIdle;
        int n2 = 0;
        __cobertura_counters[18] = __cobertura_counters[18] + 1;
        this.maxIdle = maxIdle;
        __cobertura_counters[19] = __cobertura_counters[19] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMinIdle(int n) {
        void minIdle;
        int n2 = 0;
        __cobertura_counters[20] = __cobertura_counters[20] + 1;
        this.minIdle = minIdle;
        __cobertura_counters[21] = __cobertura_counters[21] + 1;
    }

    @Override
    public int getMinIdle() {
        int n = 0;
        __cobertura_counters[22] = __cobertura_counters[22] + 1;
        int maxIdleSave = this.getMaxIdle();
        __cobertura_counters[23] = __cobertura_counters[23] + 1;
        n = 25;
        if (this.minIdle > maxIdleSave) {
            __cobertura_counters[24] = __cobertura_counters[24] + 1;
            n = 0;
            __cobertura_counters[26] = __cobertura_counters[26] + 1;
            return maxIdleSave;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[27] = __cobertura_counters[27] + 1;
        return this.minIdle;
    }

    @Override
    public boolean isAbandonedConfig() {
        boolean bl;
        int n = 0;
        __cobertura_counters[28] = __cobertura_counters[28] + 1;
        n = 30;
        if (this.abandonedConfig != null) {
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
            n = 0;
            bl = true;
        } else {
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getLogAbandoned() {
        int n = 0;
        __cobertura_counters[31] = __cobertura_counters[31] + 1;
        AbandonedConfig ac = this.abandonedConfig;
        __cobertura_counters[32] = __cobertura_counters[32] + 1;
        n = 34;
        if (ac != null) {
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            n = 0;
            n = 36;
            if (ac.getLogAbandoned()) {
                __cobertura_counters[35] = __cobertura_counters[35] + 1;
                return true;
            }
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getRemoveAbandonedOnBorrow() {
        int n = 0;
        __cobertura_counters[37] = __cobertura_counters[37] + 1;
        AbandonedConfig ac = this.abandonedConfig;
        __cobertura_counters[38] = __cobertura_counters[38] + 1;
        n = 40;
        if (ac != null) {
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            n = 0;
            n = 42;
            if (ac.getRemoveAbandonedOnBorrow()) {
                __cobertura_counters[41] = __cobertura_counters[41] + 1;
                return true;
            }
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getRemoveAbandonedOnMaintenance() {
        int n = 0;
        __cobertura_counters[43] = __cobertura_counters[43] + 1;
        AbandonedConfig ac = this.abandonedConfig;
        __cobertura_counters[44] = __cobertura_counters[44] + 1;
        n = 46;
        if (ac != null) {
            __cobertura_counters[45] = __cobertura_counters[45] + 1;
            n = 0;
            n = 48;
            if (ac.getRemoveAbandonedOnMaintenance()) {
                __cobertura_counters[47] = __cobertura_counters[47] + 1;
                return true;
            }
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        return false;
    }

    @Override
    public int getRemoveAbandonedTimeout() {
        int n;
        int n2 = 0;
        __cobertura_counters[49] = __cobertura_counters[49] + 1;
        AbandonedConfig ac = this.abandonedConfig;
        __cobertura_counters[50] = __cobertura_counters[50] + 1;
        n2 = 52;
        if (ac != null) {
            __cobertura_counters[51] = __cobertura_counters[51] + 1;
            n2 = 0;
            n = ac.getRemoveAbandonedTimeout();
        } else {
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfig(GenericObjectPoolConfig genericObjectPoolConfig) {
        void conf;
        int n = 0;
        __cobertura_counters[53] = __cobertura_counters[53] + 1;
        this.setLifo(conf.getLifo());
        __cobertura_counters[54] = __cobertura_counters[54] + 1;
        this.setMaxIdle(conf.getMaxIdle());
        __cobertura_counters[55] = __cobertura_counters[55] + 1;
        this.setMinIdle(conf.getMinIdle());
        __cobertura_counters[56] = __cobertura_counters[56] + 1;
        this.setMaxTotal(conf.getMaxTotal());
        __cobertura_counters[57] = __cobertura_counters[57] + 1;
        this.setMaxWaitMillis(conf.getMaxWaitMillis());
        __cobertura_counters[58] = __cobertura_counters[58] + 1;
        this.setBlockWhenExhausted(conf.getBlockWhenExhausted());
        __cobertura_counters[59] = __cobertura_counters[59] + 1;
        this.setTestOnCreate(conf.getTestOnCreate());
        __cobertura_counters[60] = __cobertura_counters[60] + 1;
        this.setTestOnBorrow(conf.getTestOnBorrow());
        __cobertura_counters[61] = __cobertura_counters[61] + 1;
        this.setTestOnReturn(conf.getTestOnReturn());
        __cobertura_counters[62] = __cobertura_counters[62] + 1;
        this.setTestWhileIdle(conf.getTestWhileIdle());
        __cobertura_counters[63] = __cobertura_counters[63] + 1;
        this.setNumTestsPerEvictionRun(conf.getNumTestsPerEvictionRun());
        __cobertura_counters[64] = __cobertura_counters[64] + 1;
        this.setMinEvictableIdleTimeMillis(conf.getMinEvictableIdleTimeMillis());
        __cobertura_counters[65] = __cobertura_counters[65] + 1;
        __cobertura_counters[67] = __cobertura_counters[67] + 1;
        __cobertura_counters[66] = __cobertura_counters[66] + 1;
        this.setTimeBetweenEvictionRunsMillis(conf.getTimeBetweenEvictionRunsMillis());
        __cobertura_counters[68] = __cobertura_counters[68] + 1;
        __cobertura_counters[70] = __cobertura_counters[70] + 1;
        __cobertura_counters[69] = __cobertura_counters[69] + 1;
        this.setSoftMinEvictableIdleTimeMillis(conf.getSoftMinEvictableIdleTimeMillis());
        __cobertura_counters[71] = __cobertura_counters[71] + 1;
        this.setEvictionPolicyClassName(conf.getEvictionPolicyClassName());
        __cobertura_counters[72] = __cobertura_counters[72] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAbandonedConfig(AbandonedConfig abandonedConfig) throws IllegalArgumentException {
        void abandonedConfig2;
        int n = 0;
        __cobertura_counters[73] = __cobertura_counters[73] + 1;
        n = 75;
        if (abandonedConfig2 == null) {
            __cobertura_counters[74] = __cobertura_counters[74] + 1;
            n = 0;
            __cobertura_counters[76] = __cobertura_counters[76] + 1;
            this.abandonedConfig = null;
        } else {
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[77] = __cobertura_counters[77] + 1;
            this.abandonedConfig = new AbandonedConfig();
            __cobertura_counters[78] = __cobertura_counters[78] + 1;
            this.abandonedConfig.setLogAbandoned(abandonedConfig2.getLogAbandoned());
            __cobertura_counters[79] = __cobertura_counters[79] + 1;
            this.abandonedConfig.setLogWriter(abandonedConfig2.getLogWriter());
            __cobertura_counters[80] = __cobertura_counters[80] + 1;
            this.abandonedConfig.setRemoveAbandonedOnBorrow(abandonedConfig2.getRemoveAbandonedOnBorrow());
            __cobertura_counters[81] = __cobertura_counters[81] + 1;
            this.abandonedConfig.setRemoveAbandonedOnMaintenance(abandonedConfig2.getRemoveAbandonedOnMaintenance());
            __cobertura_counters[82] = __cobertura_counters[82] + 1;
            this.abandonedConfig.setRemoveAbandonedTimeout(abandonedConfig2.getRemoveAbandonedTimeout());
            __cobertura_counters[83] = __cobertura_counters[83] + 1;
            this.abandonedConfig.setUseUsageTracking(abandonedConfig2.getUseUsageTracking());
        }
        __cobertura_counters[84] = __cobertura_counters[84] + 1;
    }

    public PooledObjectFactory<T> getFactory() {
        int n = 0;
        __cobertura_counters[85] = __cobertura_counters[85] + 1;
        return this.factory;
    }

    @Override
    public T borrowObject() throws Exception {
        int n = 0;
        __cobertura_counters[86] = __cobertura_counters[86] + 1;
        return this.borrowObject(this.getMaxWaitMillis());
    }

    /*
     * WARNING - void declaration
     */
    public T borrowObject(long l) throws Exception {
        int n = 0;
        __cobertura_counters[87] = __cobertura_counters[87] + 1;
        this.assertOpen();
        __cobertura_counters[88] = __cobertura_counters[88] + 1;
        AbandonedConfig ac = this.abandonedConfig;
        __cobertura_counters[89] = __cobertura_counters[89] + 1;
        n = 91;
        if (ac != null) {
            __cobertura_counters[90] = __cobertura_counters[90] + 1;
            n = 0;
            n = 93;
            if (ac.getRemoveAbandonedOnBorrow()) {
                __cobertura_counters[92] = __cobertura_counters[92] + 1;
                n = 0;
                __cobertura_counters[94] = __cobertura_counters[94] + 1;
                n = 96;
                if (this.getNumIdle() < 2) {
                    __cobertura_counters[95] = __cobertura_counters[95] + 1;
                    n = 0;
                    __cobertura_counters[97] = __cobertura_counters[97] + 1;
                    n = 99;
                    if (this.getNumActive() > this.getMaxTotal() - 3) {
                        __cobertura_counters[98] = __cobertura_counters[98] + 1;
                        n = 0;
                        __cobertura_counters[100] = __cobertura_counters[100] + 1;
                        this.removeAbandoned(ac);
                    }
                }
            }
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[101] = __cobertura_counters[101] + 1;
        PooledObject<T> p = null;
        __cobertura_counters[102] = __cobertura_counters[102] + 1;
        boolean blockWhenExhausted = this.getBlockWhenExhausted();
        __cobertura_counters[103] = __cobertura_counters[103] + 1;
        long waitTime = System.currentTimeMillis();
        while (true) {
            block31: {
                Throwable t;
                boolean create;
                block28: {
                    int n3 = n;
                    __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                    n = 0;
                    __cobertura_counters[104] = __cobertura_counters[104] + 1;
                    n = 106;
                    if (p != null) break;
                    __cobertura_counters[105] = __cobertura_counters[105] + 1;
                    n = 0;
                    __cobertura_counters[107] = __cobertura_counters[107] + 1;
                    create = false;
                    __cobertura_counters[108] = __cobertura_counters[108] + 1;
                    n = 110;
                    if (blockWhenExhausted) {
                        __cobertura_counters[109] = __cobertura_counters[109] + 1;
                        n = 0;
                        __cobertura_counters[111] = __cobertura_counters[111] + 1;
                        p = this.idleObjects.pollFirst();
                        __cobertura_counters[112] = __cobertura_counters[112] + 1;
                        n = 114;
                        if (p == null) {
                            __cobertura_counters[113] = __cobertura_counters[113] + 1;
                            n = 0;
                            __cobertura_counters[115] = __cobertura_counters[115] + 1;
                            p = this.create();
                            __cobertura_counters[116] = __cobertura_counters[116] + 1;
                            n = 118;
                            if (p != null) {
                                __cobertura_counters[117] = __cobertura_counters[117] + 1;
                                n = 0;
                                __cobertura_counters[119] = __cobertura_counters[119] + 1;
                                create = true;
                            }
                        }
                        int n4 = n;
                        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                        n = 0;
                        __cobertura_counters[120] = __cobertura_counters[120] + 1;
                        n = 122;
                        if (p == null) {
                            void borrowMaxWaitMillis;
                            __cobertura_counters[121] = __cobertura_counters[121] + 1;
                            n = 0;
                            __cobertura_counters[123] = __cobertura_counters[123] + 1;
                            n = 125;
                            if (borrowMaxWaitMillis < 0L) {
                                __cobertura_counters[124] = __cobertura_counters[124] + 1;
                                n = 0;
                                __cobertura_counters[126] = __cobertura_counters[126] + 1;
                                p = this.idleObjects.takeFirst();
                            } else {
                                int n5 = n;
                                __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                                n = 0;
                                __cobertura_counters[127] = __cobertura_counters[127] + 1;
                                p = this.idleObjects.pollFirst((long)borrowMaxWaitMillis, TimeUnit.MILLISECONDS);
                            }
                        }
                        int n6 = n;
                        __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                        n = 0;
                        __cobertura_counters[128] = __cobertura_counters[128] + 1;
                        n = 130;
                        if (p == null) {
                            __cobertura_counters[129] = __cobertura_counters[129] + 1;
                            n = 0;
                            __cobertura_counters[131] = __cobertura_counters[131] + 1;
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                        int n7 = n;
                        __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                        n = 0;
                        __cobertura_counters[132] = __cobertura_counters[132] + 1;
                        n = 134;
                        if (!p.allocate()) {
                            __cobertura_counters[133] = __cobertura_counters[133] + 1;
                            n = 0;
                            __cobertura_counters[135] = __cobertura_counters[135] + 1;
                            p = null;
                        }
                    } else {
                        int n8 = n;
                        __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                        n = 0;
                        __cobertura_counters[136] = __cobertura_counters[136] + 1;
                        p = this.idleObjects.pollFirst();
                        __cobertura_counters[137] = __cobertura_counters[137] + 1;
                        n = 139;
                        if (p == null) {
                            __cobertura_counters[138] = __cobertura_counters[138] + 1;
                            n = 0;
                            __cobertura_counters[140] = __cobertura_counters[140] + 1;
                            p = this.create();
                            __cobertura_counters[141] = __cobertura_counters[141] + 1;
                            n = 143;
                            if (p != null) {
                                __cobertura_counters[142] = __cobertura_counters[142] + 1;
                                n = 0;
                                __cobertura_counters[144] = __cobertura_counters[144] + 1;
                                create = true;
                            }
                        }
                        int n9 = n;
                        __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                        n = 0;
                        __cobertura_counters[145] = __cobertura_counters[145] + 1;
                        n = 147;
                        if (p == null) {
                            __cobertura_counters[146] = __cobertura_counters[146] + 1;
                            n = 0;
                            __cobertura_counters[148] = __cobertura_counters[148] + 1;
                            throw new NoSuchElementException("Pool exhausted");
                        }
                        int n10 = n;
                        __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
                        n = 0;
                        __cobertura_counters[149] = __cobertura_counters[149] + 1;
                        n = 151;
                        if (!p.allocate()) {
                            __cobertura_counters[150] = __cobertura_counters[150] + 1;
                            n = 0;
                            __cobertura_counters[152] = __cobertura_counters[152] + 1;
                            p = null;
                        }
                    }
                    int n11 = n;
                    __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
                    n = 0;
                    __cobertura_counters[153] = __cobertura_counters[153] + 1;
                    n = 155;
                    if (p == null) continue;
                    __cobertura_counters[154] = __cobertura_counters[154] + 1;
                    n = 0;
                    try {
                        __cobertura_counters[156] = __cobertura_counters[156] + 1;
                        this.factory.activateObject(p);
                    }
                    catch (Exception exception) {
                        __cobertura_counters[157] = __cobertura_counters[157] + 1;
                        Exception e = exception;
                        try {
                            __cobertura_counters[158] = __cobertura_counters[158] + 1;
                            this.destroy(p);
                        }
                        catch (Exception exception2) {
                            __cobertura_counters[159] = __cobertura_counters[159] + 1;
                            Exception exception3 = exception2;
                        }
                        __cobertura_counters[160] = __cobertura_counters[160] + 1;
                        __cobertura_counters[161] = __cobertura_counters[161] + 1;
                        p = null;
                        __cobertura_counters[162] = __cobertura_counters[162] + 1;
                        n = 164;
                        if (!create) break block28;
                        __cobertura_counters[163] = __cobertura_counters[163] + 1;
                        n = 0;
                        __cobertura_counters[165] = __cobertura_counters[165] + 1;
                        NoSuchElementException nsee = new NoSuchElementException("Unable to activate object");
                        __cobertura_counters[166] = __cobertura_counters[166] + 1;
                        nsee.initCause(e);
                        __cobertura_counters[167] = __cobertura_counters[167] + 1;
                        throw nsee;
                    }
                    __cobertura_counters[168] = __cobertura_counters[168] + 1;
                }
                int n12 = n;
                __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
                n = 0;
                __cobertura_counters[169] = __cobertura_counters[169] + 1;
                n = 171;
                if (p == null) continue;
                __cobertura_counters[170] = __cobertura_counters[170] + 1;
                n = 0;
                n = 173;
                if (!this.getTestOnBorrow()) {
                    __cobertura_counters[172] = __cobertura_counters[172] + 1;
                    n = 0;
                    n = 175;
                    if (!create) continue;
                    __cobertura_counters[174] = __cobertura_counters[174] + 1;
                    n = 0;
                    n = 177;
                    if (!this.getTestOnCreate()) continue;
                    __cobertura_counters[176] = __cobertura_counters[176] + 1;
                    n = 0;
                }
                int n13 = n;
                __cobertura_counters[n13] = __cobertura_counters[n13] + 1;
                n = 0;
                __cobertura_counters[178] = __cobertura_counters[178] + 1;
                boolean validate = false;
                __cobertura_counters[179] = __cobertura_counters[179] + 1;
                Throwable validationThrowable = null;
                try {
                    __cobertura_counters[180] = __cobertura_counters[180] + 1;
                    validate = this.factory.validateObject(p);
                }
                catch (Throwable throwable) {
                    __cobertura_counters[181] = __cobertura_counters[181] + 1;
                    t = throwable;
                    __cobertura_counters[182] = __cobertura_counters[182] + 1;
                    PoolUtils.checkRethrow(t);
                    __cobertura_counters[183] = __cobertura_counters[183] + 1;
                    validationThrowable = t;
                }
                __cobertura_counters[184] = __cobertura_counters[184] + 1;
                __cobertura_counters[185] = __cobertura_counters[185] + 1;
                n = 187;
                if (validate) break block31;
                __cobertura_counters[186] = __cobertura_counters[186] + 1;
                n = 0;
                try {
                    __cobertura_counters[188] = __cobertura_counters[188] + 1;
                    this.destroy(p);
                    __cobertura_counters[189] = __cobertura_counters[189] + 1;
                    this.destroyedByBorrowValidationCount.incrementAndGet();
                }
                catch (Exception exception) {
                    __cobertura_counters[190] = __cobertura_counters[190] + 1;
                    t = exception;
                }
                __cobertura_counters[191] = __cobertura_counters[191] + 1;
                __cobertura_counters[192] = __cobertura_counters[192] + 1;
                p = null;
                __cobertura_counters[193] = __cobertura_counters[193] + 1;
                n = 195;
                if (create) {
                    __cobertura_counters[194] = __cobertura_counters[194] + 1;
                    n = 0;
                    __cobertura_counters[196] = __cobertura_counters[196] + 1;
                    NoSuchElementException nsee = new NoSuchElementException("Unable to validate object");
                    __cobertura_counters[197] = __cobertura_counters[197] + 1;
                    nsee.initCause(validationThrowable);
                    __cobertura_counters[198] = __cobertura_counters[198] + 1;
                    throw nsee;
                }
            }
            int n14 = n;
            __cobertura_counters[n14] = __cobertura_counters[n14] + 1;
            n = 0;
            __cobertura_counters[199] = __cobertura_counters[199] + 1;
        }
        int n15 = n;
        __cobertura_counters[n15] = __cobertura_counters[n15] + 1;
        n = 0;
        __cobertura_counters[200] = __cobertura_counters[200] + 1;
        this.updateStatsBorrow(p, System.currentTimeMillis() - waitTime);
        __cobertura_counters[201] = __cobertura_counters[201] + 1;
        return p.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void returnObject(T t) {
        long activeTime;
        int n;
        block29: {
            PooledObject<T> p;
            block28: {
                block27: {
                    block22: {
                        Exception e;
                        void obj;
                        n = 0;
                        __cobertura_counters[202] = __cobertura_counters[202] + 1;
                        p = this.allObjects.get(new BaseGenericObjectPool.IdentityWrapper<void>(obj));
                        __cobertura_counters[203] = __cobertura_counters[203] + 1;
                        n = 205;
                        if (p == null) {
                            __cobertura_counters[204] = __cobertura_counters[204] + 1;
                            n = 0;
                            __cobertura_counters[206] = __cobertura_counters[206] + 1;
                            n = 208;
                            if (!this.isAbandonedConfig()) {
                                __cobertura_counters[207] = __cobertura_counters[207] + 1;
                                n = 0;
                                __cobertura_counters[209] = __cobertura_counters[209] + 1;
                                throw new IllegalStateException("Returned object not currently part of this pool");
                            }
                            int n2 = n;
                            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                            n = 0;
                            __cobertura_counters[210] = __cobertura_counters[210] + 1;
                            return;
                        }
                        int n3 = n;
                        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                        n = 0;
                        __cobertura_counters[211] = __cobertura_counters[211] + 1;
                        PooledObject<T> pooledObject = p;
                        synchronized (pooledObject) {
                            __cobertura_counters[212] = __cobertura_counters[212] + 1;
                            PooledObjectState state = p.getState();
                            __cobertura_counters[213] = __cobertura_counters[213] + 1;
                            n = 215;
                            if (state != PooledObjectState.ALLOCATED) {
                                __cobertura_counters[214] = __cobertura_counters[214] + 1;
                                n = 0;
                                __cobertura_counters[216] = __cobertura_counters[216] + 1;
                                throw new IllegalStateException("Object has already been returned to this pool or is invalid");
                            }
                            int n4 = n;
                            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                            n = 0;
                            __cobertura_counters[217] = __cobertura_counters[217] + 1;
                            p.markReturning();
                            __cobertura_counters[218] = __cobertura_counters[218] + 1;
                        }
                        __cobertura_counters[219] = __cobertura_counters[219] + 1;
                        activeTime = p.getActiveTimeMillis();
                        __cobertura_counters[220] = __cobertura_counters[220] + 1;
                        n = 222;
                        if (!this.getTestOnReturn()) break block22;
                        __cobertura_counters[221] = __cobertura_counters[221] + 1;
                        n = 0;
                        __cobertura_counters[223] = __cobertura_counters[223] + 1;
                        n = 225;
                        if (this.factory.validateObject(p)) break block22;
                        __cobertura_counters[224] = __cobertura_counters[224] + 1;
                        n = 0;
                        try {
                            __cobertura_counters[226] = __cobertura_counters[226] + 1;
                            this.destroy(p);
                        }
                        catch (Exception exception) {
                            __cobertura_counters[227] = __cobertura_counters[227] + 1;
                            e = exception;
                            __cobertura_counters[228] = __cobertura_counters[228] + 1;
                            this.swallowException(e);
                        }
                        __cobertura_counters[229] = __cobertura_counters[229] + 1;
                        try {
                            __cobertura_counters[230] = __cobertura_counters[230] + 1;
                            this.ensureIdle(1, false);
                        }
                        catch (Exception exception) {
                            __cobertura_counters[231] = __cobertura_counters[231] + 1;
                            e = exception;
                            __cobertura_counters[232] = __cobertura_counters[232] + 1;
                            this.swallowException(e);
                        }
                        __cobertura_counters[233] = __cobertura_counters[233] + 1;
                        __cobertura_counters[234] = __cobertura_counters[234] + 1;
                        this.updateStatsReturn(activeTime);
                        __cobertura_counters[235] = __cobertura_counters[235] + 1;
                        return;
                    }
                    try {
                        int n5 = n;
                        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                        n = 0;
                        __cobertura_counters[236] = __cobertura_counters[236] + 1;
                        this.factory.passivateObject(p);
                    }
                    catch (Exception exception) {
                        Exception e;
                        __cobertura_counters[237] = __cobertura_counters[237] + 1;
                        Exception e1 = exception;
                        __cobertura_counters[238] = __cobertura_counters[238] + 1;
                        this.swallowException(e1);
                        try {
                            __cobertura_counters[239] = __cobertura_counters[239] + 1;
                            this.destroy(p);
                        }
                        catch (Exception exception2) {
                            __cobertura_counters[240] = __cobertura_counters[240] + 1;
                            e = exception2;
                            __cobertura_counters[241] = __cobertura_counters[241] + 1;
                            this.swallowException(e);
                        }
                        __cobertura_counters[242] = __cobertura_counters[242] + 1;
                        try {
                            __cobertura_counters[243] = __cobertura_counters[243] + 1;
                            this.ensureIdle(1, false);
                        }
                        catch (Exception exception3) {
                            __cobertura_counters[244] = __cobertura_counters[244] + 1;
                            e = exception3;
                            __cobertura_counters[245] = __cobertura_counters[245] + 1;
                            this.swallowException(e);
                        }
                        __cobertura_counters[246] = __cobertura_counters[246] + 1;
                        __cobertura_counters[247] = __cobertura_counters[247] + 1;
                        this.updateStatsReturn(activeTime);
                        __cobertura_counters[248] = __cobertura_counters[248] + 1;
                        return;
                    }
                    __cobertura_counters[249] = __cobertura_counters[249] + 1;
                    __cobertura_counters[250] = __cobertura_counters[250] + 1;
                    n = 252;
                    if (!p.deallocate()) {
                        __cobertura_counters[251] = __cobertura_counters[251] + 1;
                        n = 0;
                        __cobertura_counters[253] = __cobertura_counters[253] + 1;
                        throw new IllegalStateException("Object has already been returned to this pool or is invalid");
                    }
                    int n6 = n;
                    __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                    n = 0;
                    __cobertura_counters[254] = __cobertura_counters[254] + 1;
                    int maxIdleSave = this.getMaxIdle();
                    __cobertura_counters[255] = __cobertura_counters[255] + 1;
                    n = 257;
                    if (this.isClosed()) break block27;
                    __cobertura_counters[256] = __cobertura_counters[256] + 1;
                    n = 0;
                    n = 259;
                    if (maxIdleSave <= -1) break block28;
                    __cobertura_counters[258] = __cobertura_counters[258] + 1;
                    n = 0;
                    n = 261;
                    if (maxIdleSave > this.idleObjects.size()) break block28;
                    __cobertura_counters[260] = __cobertura_counters[260] + 1;
                    n = 0;
                }
                try {
                    int n7 = n;
                    __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                    n = 0;
                    __cobertura_counters[262] = __cobertura_counters[262] + 1;
                    this.destroy(p);
                }
                catch (Exception exception) {
                    __cobertura_counters[263] = __cobertura_counters[263] + 1;
                    Exception e = exception;
                    __cobertura_counters[264] = __cobertura_counters[264] + 1;
                    this.swallowException(e);
                    __cobertura_counters[266] = __cobertura_counters[266] + 1;
                }
                __cobertura_counters[265] = __cobertura_counters[265] + 1;
                break block29;
                break block29;
            }
            int n8 = n;
            __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
            n = 0;
            __cobertura_counters[267] = __cobertura_counters[267] + 1;
            n = 269;
            if (this.getLifo()) {
                __cobertura_counters[268] = __cobertura_counters[268] + 1;
                n = 0;
                __cobertura_counters[270] = __cobertura_counters[270] + 1;
                this.idleObjects.addFirst(p);
            } else {
                int n9 = n;
                __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                n = 0;
                __cobertura_counters[271] = __cobertura_counters[271] + 1;
                this.idleObjects.addLast(p);
            }
            __cobertura_counters[272] = __cobertura_counters[272] + 1;
            n = 274;
            if (this.isClosed()) {
                __cobertura_counters[273] = __cobertura_counters[273] + 1;
                n = 0;
                __cobertura_counters[275] = __cobertura_counters[275] + 1;
                this.clear();
            }
        }
        int n10 = n;
        __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
        n = 0;
        __cobertura_counters[276] = __cobertura_counters[276] + 1;
        this.updateStatsReturn(activeTime);
        __cobertura_counters[277] = __cobertura_counters[277] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void invalidateObject(T t) throws Exception {
        void obj;
        int n = 0;
        __cobertura_counters[278] = __cobertura_counters[278] + 1;
        PooledObject<T> p = this.allObjects.get(new BaseGenericObjectPool.IdentityWrapper<void>(obj));
        __cobertura_counters[279] = __cobertura_counters[279] + 1;
        n = 281;
        if (p == null) {
            __cobertura_counters[280] = __cobertura_counters[280] + 1;
            n = 0;
            __cobertura_counters[282] = __cobertura_counters[282] + 1;
            n = 284;
            if (this.isAbandonedConfig()) {
                __cobertura_counters[283] = __cobertura_counters[283] + 1;
                n = 0;
                __cobertura_counters[285] = __cobertura_counters[285] + 1;
                return;
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[286] = __cobertura_counters[286] + 1;
            throw new IllegalStateException("Invalidated object not currently part of this pool");
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[287] = __cobertura_counters[287] + 1;
        PooledObject<T> pooledObject = p;
        synchronized (pooledObject) {
            __cobertura_counters[288] = __cobertura_counters[288] + 1;
            n = 290;
            if (p.getState() != PooledObjectState.INVALID) {
                __cobertura_counters[289] = __cobertura_counters[289] + 1;
                n = 0;
                __cobertura_counters[291] = __cobertura_counters[291] + 1;
                this.destroy(p);
            }
            int n4 = n;
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n = 0;
            __cobertura_counters[292] = __cobertura_counters[292] + 1;
        }
        __cobertura_counters[293] = __cobertura_counters[293] + 1;
        this.ensureIdle(1, false);
        __cobertura_counters[294] = __cobertura_counters[294] + 1;
    }

    @Override
    public void clear() {
        int n = 0;
        __cobertura_counters[295] = __cobertura_counters[295] + 1;
        PooledObject<T> p = this.idleObjects.poll();
        while (true) {
            __cobertura_counters[296] = __cobertura_counters[296] + 1;
            n = 298;
            if (p == null) break;
            __cobertura_counters[297] = __cobertura_counters[297] + 1;
            n = 0;
            try {
                __cobertura_counters[299] = __cobertura_counters[299] + 1;
                this.destroy(p);
            }
            catch (Exception exception) {
                __cobertura_counters[300] = __cobertura_counters[300] + 1;
                Exception e = exception;
                __cobertura_counters[301] = __cobertura_counters[301] + 1;
                this.swallowException(e);
            }
            __cobertura_counters[302] = __cobertura_counters[302] + 1;
            __cobertura_counters[303] = __cobertura_counters[303] + 1;
            p = this.idleObjects.poll();
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[304] = __cobertura_counters[304] + 1;
    }

    @Override
    public int getNumActive() {
        int n = 0;
        __cobertura_counters[305] = __cobertura_counters[305] + 1;
        return this.allObjects.size() - this.idleObjects.size();
    }

    @Override
    public int getNumIdle() {
        int n = 0;
        __cobertura_counters[306] = __cobertura_counters[306] + 1;
        return this.idleObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        int n = 0;
        __cobertura_counters[307] = __cobertura_counters[307] + 1;
        n = 309;
        if (this.isClosed()) {
            __cobertura_counters[308] = __cobertura_counters[308] + 1;
            n = 0;
            __cobertura_counters[310] = __cobertura_counters[310] + 1;
            return;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[311] = __cobertura_counters[311] + 1;
        Object object = this.closeLock;
        synchronized (object) {
            __cobertura_counters[312] = __cobertura_counters[312] + 1;
            n = 314;
            if (this.isClosed()) {
                __cobertura_counters[313] = __cobertura_counters[313] + 1;
                n = 0;
                __cobertura_counters[315] = __cobertura_counters[315] + 1;
                return;
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[316] = __cobertura_counters[316] + 1;
            this.startEvictor(-1L);
            __cobertura_counters[317] = __cobertura_counters[317] + 1;
            this.closed = true;
            __cobertura_counters[318] = __cobertura_counters[318] + 1;
            this.clear();
            __cobertura_counters[319] = __cobertura_counters[319] + 1;
            this.jmxUnregister();
            __cobertura_counters[320] = __cobertura_counters[320] + 1;
            this.idleObjects.interuptTakeWaiters();
            __cobertura_counters[321] = __cobertura_counters[321] + 1;
        }
        __cobertura_counters[322] = __cobertura_counters[322] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void evict() throws Exception {
        int n;
        block31: {
            n = 0;
            __cobertura_counters[323] = __cobertura_counters[323] + 1;
            this.assertOpen();
            __cobertura_counters[324] = __cobertura_counters[324] + 1;
            n = 326;
            if (this.idleObjects.size() <= 0) break block31;
            __cobertura_counters[325] = __cobertura_counters[325] + 1;
            n = 0;
            __cobertura_counters[327] = __cobertura_counters[327] + 1;
            Object underTest = null;
            __cobertura_counters[328] = __cobertura_counters[328] + 1;
            EvictionPolicy evictionPolicy = this.getEvictionPolicy();
            __cobertura_counters[329] = __cobertura_counters[329] + 1;
            Object object = this.evictionLock;
            synchronized (object) {
                __cobertura_counters[330] = __cobertura_counters[330] + 1;
                __cobertura_counters[331] = __cobertura_counters[331] + 1;
                __cobertura_counters[332] = __cobertura_counters[332] + 1;
                __cobertura_counters[333] = __cobertura_counters[333] + 1;
                EvictionConfig evictionConfig = new EvictionConfig(this.getMinEvictableIdleTimeMillis(), this.getSoftMinEvictableIdleTimeMillis(), this.getMinIdle());
                __cobertura_counters[334] = __cobertura_counters[334] + 1;
                boolean testWhileIdle = this.getTestWhileIdle();
                __cobertura_counters[335] = __cobertura_counters[335] + 1;
                int i = 0;
                int m = this.getNumTests();
                while (true) {
                    block27: {
                        block33: {
                            block32: {
                                n = 337;
                                if (i >= m) break;
                                __cobertura_counters[336] = __cobertura_counters[336] + 1;
                                n = 0;
                                __cobertura_counters[339] = __cobertura_counters[339] + 1;
                                n = 341;
                                if (this.evictionIterator == null) break block32;
                                __cobertura_counters[340] = __cobertura_counters[340] + 1;
                                n = 0;
                                n = 343;
                                if (this.evictionIterator.hasNext()) break block33;
                                __cobertura_counters[342] = __cobertura_counters[342] + 1;
                                n = 0;
                            }
                            int n2 = n;
                            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                            n = 0;
                            __cobertura_counters[344] = __cobertura_counters[344] + 1;
                            this.evictionIterator = new BaseGenericObjectPool.EvictionIterator(this, this.idleObjects);
                        }
                        int n3 = n;
                        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                        n = 0;
                        __cobertura_counters[345] = __cobertura_counters[345] + 1;
                        n = 347;
                        if (!this.evictionIterator.hasNext()) {
                            __cobertura_counters[346] = __cobertura_counters[346] + 1;
                            n = 0;
                            __cobertura_counters[348] = __cobertura_counters[348] + 1;
                            return;
                        }
                        try {
                            int n4 = n;
                            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                            n = 0;
                            __cobertura_counters[349] = __cobertura_counters[349] + 1;
                            underTest = this.evictionIterator.next();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            __cobertura_counters[350] = __cobertura_counters[350] + 1;
                            NoSuchElementException nsee = noSuchElementException;
                            __cobertura_counters[351] = __cobertura_counters[351] + 1;
                            --i;
                            __cobertura_counters[352] = __cobertura_counters[352] + 1;
                            this.evictionIterator = null;
                            __cobertura_counters[353] = __cobertura_counters[353] + 1;
                            break block27;
                        }
                        __cobertura_counters[354] = __cobertura_counters[354] + 1;
                        __cobertura_counters[355] = __cobertura_counters[355] + 1;
                        n = 357;
                        if (!underTest.startEvictionTest()) {
                            __cobertura_counters[356] = __cobertura_counters[356] + 1;
                            n = 0;
                            __cobertura_counters[358] = __cobertura_counters[358] + 1;
                            --i;
                            __cobertura_counters[359] = __cobertura_counters[359] + 1;
                        } else {
                            boolean evict;
                            block28: {
                                try {
                                    int n5 = n;
                                    __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                                    n = 0;
                                    __cobertura_counters[360] = __cobertura_counters[360] + 1;
                                    __cobertura_counters[362] = __cobertura_counters[362] + 1;
                                    __cobertura_counters[361] = __cobertura_counters[361] + 1;
                                    evict = evictionPolicy.evict(evictionConfig, underTest, this.idleObjects.size());
                                }
                                catch (Throwable throwable) {
                                    __cobertura_counters[363] = __cobertura_counters[363] + 1;
                                    Throwable t = throwable;
                                    __cobertura_counters[364] = __cobertura_counters[364] + 1;
                                    PoolUtils.checkRethrow(t);
                                    __cobertura_counters[365] = __cobertura_counters[365] + 1;
                                    this.swallowException(new Exception(t));
                                    __cobertura_counters[366] = __cobertura_counters[366] + 1;
                                    evict = false;
                                    break block28;
                                }
                                __cobertura_counters[367] = __cobertura_counters[367] + 1;
                            }
                            __cobertura_counters[368] = __cobertura_counters[368] + 1;
                            n = 370;
                            if (evict) {
                                __cobertura_counters[369] = __cobertura_counters[369] + 1;
                                n = 0;
                                __cobertura_counters[371] = __cobertura_counters[371] + 1;
                                this.destroy((PooledObject<T>)underTest);
                                __cobertura_counters[372] = __cobertura_counters[372] + 1;
                                this.destroyedByEvictorCount.incrementAndGet();
                            } else {
                                block30: {
                                    int n6 = n;
                                    __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                                    n = 0;
                                    __cobertura_counters[373] = __cobertura_counters[373] + 1;
                                    n = 375;
                                    if (testWhileIdle) {
                                        Exception e;
                                        boolean active;
                                        block29: {
                                            __cobertura_counters[374] = __cobertura_counters[374] + 1;
                                            n = 0;
                                            __cobertura_counters[376] = __cobertura_counters[376] + 1;
                                            active = false;
                                            try {
                                                __cobertura_counters[377] = __cobertura_counters[377] + 1;
                                                this.factory.activateObject((PooledObject<T>)underTest);
                                                __cobertura_counters[378] = __cobertura_counters[378] + 1;
                                                active = true;
                                            }
                                            catch (Exception exception) {
                                                __cobertura_counters[379] = __cobertura_counters[379] + 1;
                                                e = exception;
                                                __cobertura_counters[380] = __cobertura_counters[380] + 1;
                                                this.destroy((PooledObject<T>)underTest);
                                                __cobertura_counters[381] = __cobertura_counters[381] + 1;
                                                this.destroyedByEvictorCount.incrementAndGet();
                                                break block29;
                                            }
                                            __cobertura_counters[382] = __cobertura_counters[382] + 1;
                                        }
                                        __cobertura_counters[383] = __cobertura_counters[383] + 1;
                                        n = 385;
                                        if (active) {
                                            __cobertura_counters[384] = __cobertura_counters[384] + 1;
                                            n = 0;
                                            __cobertura_counters[386] = __cobertura_counters[386] + 1;
                                            n = 388;
                                            if (!this.factory.validateObject((PooledObject<T>)underTest)) {
                                                __cobertura_counters[387] = __cobertura_counters[387] + 1;
                                                n = 0;
                                                __cobertura_counters[389] = __cobertura_counters[389] + 1;
                                                this.destroy((PooledObject<T>)underTest);
                                                __cobertura_counters[390] = __cobertura_counters[390] + 1;
                                                this.destroyedByEvictorCount.incrementAndGet();
                                            } else {
                                                try {
                                                    int n7 = n;
                                                    __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                                                    n = 0;
                                                    __cobertura_counters[391] = __cobertura_counters[391] + 1;
                                                    this.factory.passivateObject((PooledObject<T>)underTest);
                                                }
                                                catch (Exception exception) {
                                                    __cobertura_counters[392] = __cobertura_counters[392] + 1;
                                                    e = exception;
                                                    __cobertura_counters[393] = __cobertura_counters[393] + 1;
                                                    this.destroy((PooledObject<T>)underTest);
                                                    __cobertura_counters[394] = __cobertura_counters[394] + 1;
                                                    this.destroyedByEvictorCount.incrementAndGet();
                                                    break block30;
                                                }
                                                __cobertura_counters[395] = __cobertura_counters[395] + 1;
                                            }
                                        }
                                    }
                                }
                                int n8 = n;
                                __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                                n = 0;
                                __cobertura_counters[396] = __cobertura_counters[396] + 1;
                                n = 398;
                                if (!underTest.endEvictionTest(this.idleObjects)) {
                                    __cobertura_counters[397] = __cobertura_counters[397] + 1;
                                    n = 0;
                                }
                            }
                        }
                    }
                    int n9 = n;
                    __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                    n = 0;
                    __cobertura_counters[338] = __cobertura_counters[338] + 1;
                    ++i;
                }
                int n10 = n;
                __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
                n = 0;
                __cobertura_counters[399] = __cobertura_counters[399] + 1;
            }
        }
        int n11 = n;
        __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
        n = 0;
        __cobertura_counters[400] = __cobertura_counters[400] + 1;
        AbandonedConfig ac = this.abandonedConfig;
        __cobertura_counters[401] = __cobertura_counters[401] + 1;
        n = 403;
        if (ac != null) {
            __cobertura_counters[402] = __cobertura_counters[402] + 1;
            n = 0;
            n = 405;
            if (ac.getRemoveAbandonedOnMaintenance()) {
                __cobertura_counters[404] = __cobertura_counters[404] + 1;
                n = 0;
                __cobertura_counters[406] = __cobertura_counters[406] + 1;
                this.removeAbandoned(ac);
            }
        }
        int n12 = n;
        __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
        n = 0;
        __cobertura_counters[407] = __cobertura_counters[407] + 1;
    }

    public void preparePool() throws Exception {
        int n = 0;
        __cobertura_counters[408] = __cobertura_counters[408] + 1;
        n = 410;
        if (this.getMinIdle() < 1) {
            __cobertura_counters[409] = __cobertura_counters[409] + 1;
            n = 0;
            __cobertura_counters[411] = __cobertura_counters[411] + 1;
            return;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[412] = __cobertura_counters[412] + 1;
        this.ensureMinIdle();
        __cobertura_counters[413] = __cobertura_counters[413] + 1;
    }

    private PooledObject<T> create() throws Exception {
        PooledObject<T> p;
        int n;
        block9: {
            block8: {
                long newCreateCount;
                block7: {
                    n = 0;
                    __cobertura_counters[414] = __cobertura_counters[414] + 1;
                    int localMaxTotal = this.getMaxTotal();
                    __cobertura_counters[415] = __cobertura_counters[415] + 1;
                    newCreateCount = this.createCount.incrementAndGet();
                    __cobertura_counters[416] = __cobertura_counters[416] + 1;
                    n = 418;
                    if (localMaxTotal <= -1) break block7;
                    __cobertura_counters[417] = __cobertura_counters[417] + 1;
                    n = 0;
                    n = 420;
                    if (newCreateCount > (long)localMaxTotal) break block8;
                    __cobertura_counters[419] = __cobertura_counters[419] + 1;
                    n = 0;
                }
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                n = 422;
                if (newCreateCount <= Integer.MAX_VALUE) break block9;
                __cobertura_counters[421] = __cobertura_counters[421] + 1;
                n = 0;
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[423] = __cobertura_counters[423] + 1;
            this.createCount.decrementAndGet();
            __cobertura_counters[424] = __cobertura_counters[424] + 1;
            return null;
        }
        try {
            int n4 = n;
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n = 0;
            __cobertura_counters[425] = __cobertura_counters[425] + 1;
            p = this.factory.makeObject();
        }
        catch (Exception exception) {
            __cobertura_counters[426] = __cobertura_counters[426] + 1;
            Exception e = exception;
            __cobertura_counters[427] = __cobertura_counters[427] + 1;
            this.createCount.decrementAndGet();
            __cobertura_counters[428] = __cobertura_counters[428] + 1;
            throw e;
        }
        __cobertura_counters[429] = __cobertura_counters[429] + 1;
        __cobertura_counters[430] = __cobertura_counters[430] + 1;
        AbandonedConfig ac = this.abandonedConfig;
        __cobertura_counters[431] = __cobertura_counters[431] + 1;
        n = 433;
        if (ac != null) {
            __cobertura_counters[432] = __cobertura_counters[432] + 1;
            n = 0;
            n = 435;
            if (ac.getLogAbandoned()) {
                __cobertura_counters[434] = __cobertura_counters[434] + 1;
                n = 0;
                __cobertura_counters[436] = __cobertura_counters[436] + 1;
                p.setLogAbandoned(true);
            }
        }
        int n5 = n;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n = 0;
        __cobertura_counters[437] = __cobertura_counters[437] + 1;
        this.createdCount.incrementAndGet();
        __cobertura_counters[438] = __cobertura_counters[438] + 1;
        this.allObjects.put(new BaseGenericObjectPool.IdentityWrapper<T>(p.getObject()), p);
        __cobertura_counters[439] = __cobertura_counters[439] + 1;
        return p;
    }

    /*
     * WARNING - void declaration
     */
    private void destroy(PooledObject<T> pooledObject) throws Exception {
        void toDestory;
        int n = 0;
        __cobertura_counters[440] = __cobertura_counters[440] + 1;
        toDestory.invalidate();
        __cobertura_counters[441] = __cobertura_counters[441] + 1;
        this.idleObjects.remove(toDestory);
        __cobertura_counters[442] = __cobertura_counters[442] + 1;
        this.allObjects.remove(new BaseGenericObjectPool.IdentityWrapper(toDestory.getObject()));
        try {
            __cobertura_counters[443] = __cobertura_counters[443] + 1;
            this.factory.destroyObject((PooledObject<T>)toDestory);
        }
        catch (Throwable throwable) {
            __cobertura_counters[444] = __cobertura_counters[444] + 1;
            Throwable throwable2 = throwable;
            this.destroyedCount.incrementAndGet();
            __cobertura_counters[445] = __cobertura_counters[445] + 1;
            this.createCount.decrementAndGet();
            throw throwable2;
        }
        __cobertura_counters[444] = __cobertura_counters[444] + 1;
        this.destroyedCount.incrementAndGet();
        __cobertura_counters[445] = __cobertura_counters[445] + 1;
        this.createCount.decrementAndGet();
        __cobertura_counters[446] = __cobertura_counters[446] + 1;
        __cobertura_counters[447] = __cobertura_counters[447] + 1;
    }

    @Override
    void ensureMinIdle() throws Exception {
        int n = 0;
        __cobertura_counters[448] = __cobertura_counters[448] + 1;
        this.ensureIdle(this.getMinIdle(), true);
        __cobertura_counters[449] = __cobertura_counters[449] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureIdle(int n, boolean bl) throws Exception {
        void idleCount;
        int n2;
        block9: {
            block8: {
                void always;
                n2 = 0;
                __cobertura_counters[450] = __cobertura_counters[450] + 1;
                n2 = 452;
                if (idleCount < true) break block8;
                __cobertura_counters[451] = __cobertura_counters[451] + 1;
                n2 = 0;
                n2 = 454;
                if (this.isClosed()) break block8;
                __cobertura_counters[453] = __cobertura_counters[453] + 1;
                n2 = 0;
                n2 = 456;
                if (always != false) break block9;
                __cobertura_counters[455] = __cobertura_counters[455] + 1;
                n2 = 0;
                n2 = 458;
                if (this.idleObjects.hasTakeWaiters()) break block9;
                __cobertura_counters[457] = __cobertura_counters[457] + 1;
                n2 = 0;
            }
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            __cobertura_counters[459] = __cobertura_counters[459] + 1;
            return;
        }
        while (true) {
            int n4 = n2;
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n2 = 0;
            __cobertura_counters[460] = __cobertura_counters[460] + 1;
            n2 = 462;
            if (this.idleObjects.size() >= idleCount) break;
            __cobertura_counters[461] = __cobertura_counters[461] + 1;
            n2 = 0;
            __cobertura_counters[463] = __cobertura_counters[463] + 1;
            PooledObject<T> p = this.create();
            __cobertura_counters[464] = __cobertura_counters[464] + 1;
            n2 = 466;
            if (p == null) {
                __cobertura_counters[465] = __cobertura_counters[465] + 1;
                n2 = 0;
                __cobertura_counters[467] = __cobertura_counters[467] + 1;
                break;
            }
            int n5 = n2;
            __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
            n2 = 0;
            __cobertura_counters[468] = __cobertura_counters[468] + 1;
            n2 = 470;
            if (this.getLifo()) {
                __cobertura_counters[469] = __cobertura_counters[469] + 1;
                n2 = 0;
                __cobertura_counters[471] = __cobertura_counters[471] + 1;
                this.idleObjects.addFirst(p);
            } else {
                int n6 = n2;
                __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                n2 = 0;
                __cobertura_counters[472] = __cobertura_counters[472] + 1;
                this.idleObjects.addLast(p);
            }
            __cobertura_counters[473] = __cobertura_counters[473] + 1;
        }
        int n7 = n2;
        __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
        n2 = 0;
        __cobertura_counters[474] = __cobertura_counters[474] + 1;
        n2 = 476;
        if (this.isClosed()) {
            __cobertura_counters[475] = __cobertura_counters[475] + 1;
            n2 = 0;
            __cobertura_counters[477] = __cobertura_counters[477] + 1;
            this.clear();
        }
        int n8 = n2;
        __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
        n2 = 0;
        __cobertura_counters[478] = __cobertura_counters[478] + 1;
    }

    @Override
    public void addObject() throws Exception {
        int n = 0;
        __cobertura_counters[479] = __cobertura_counters[479] + 1;
        this.assertOpen();
        __cobertura_counters[480] = __cobertura_counters[480] + 1;
        n = 482;
        if (this.factory == null) {
            __cobertura_counters[481] = __cobertura_counters[481] + 1;
            n = 0;
            __cobertura_counters[483] = __cobertura_counters[483] + 1;
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[484] = __cobertura_counters[484] + 1;
        PooledObject<T> p = this.create();
        __cobertura_counters[485] = __cobertura_counters[485] + 1;
        this.addIdleObject(p);
        __cobertura_counters[486] = __cobertura_counters[486] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private void addIdleObject(PooledObject<T> pooledObject) throws Exception {
        void p;
        int n = 0;
        __cobertura_counters[487] = __cobertura_counters[487] + 1;
        n = 489;
        if (p != null) {
            __cobertura_counters[488] = __cobertura_counters[488] + 1;
            n = 0;
            __cobertura_counters[490] = __cobertura_counters[490] + 1;
            this.factory.passivateObject((PooledObject<T>)p);
            __cobertura_counters[491] = __cobertura_counters[491] + 1;
            n = 493;
            if (this.getLifo()) {
                __cobertura_counters[492] = __cobertura_counters[492] + 1;
                n = 0;
                __cobertura_counters[494] = __cobertura_counters[494] + 1;
                this.idleObjects.addFirst((PooledObject<T>)p);
            } else {
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[495] = __cobertura_counters[495] + 1;
                this.idleObjects.addLast((PooledObject<T>)p);
            }
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[496] = __cobertura_counters[496] + 1;
    }

    private int getNumTests() {
        int n = 0;
        __cobertura_counters[497] = __cobertura_counters[497] + 1;
        int numTestsPerEvictionRun = this.getNumTestsPerEvictionRun();
        __cobertura_counters[498] = __cobertura_counters[498] + 1;
        n = 500;
        if (numTestsPerEvictionRun >= 0) {
            __cobertura_counters[499] = __cobertura_counters[499] + 1;
            n = 0;
            __cobertura_counters[501] = __cobertura_counters[501] + 1;
            return Math.min(numTestsPerEvictionRun, this.idleObjects.size());
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[502] = __cobertura_counters[502] + 1;
        __cobertura_counters[504] = __cobertura_counters[504] + 1;
        __cobertura_counters[503] = __cobertura_counters[503] + 1;
        return (int)Math.ceil((double)this.idleObjects.size() / Math.abs((double)numTestsPerEvictionRun));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void removeAbandoned(AbandonedConfig abandonedConfig) {
        void ac;
        int n = 0;
        __cobertura_counters[505] = __cobertura_counters[505] + 1;
        long now = System.currentTimeMillis();
        __cobertura_counters[506] = __cobertura_counters[506] + 1;
        __cobertura_counters[507] = __cobertura_counters[507] + 1;
        long timeout = now - (long)ac.getRemoveAbandonedTimeout() * 1000L;
        __cobertura_counters[508] = __cobertura_counters[508] + 1;
        ArrayList<PooledObject<T>> remove = new ArrayList<PooledObject<T>>();
        __cobertura_counters[509] = __cobertura_counters[509] + 1;
        Iterator<PooledObject<T>> it = this.allObjects.values().iterator();
        while (true) {
            __cobertura_counters[510] = __cobertura_counters[510] + 1;
            n = 512;
            if (!it.hasNext()) break;
            __cobertura_counters[511] = __cobertura_counters[511] + 1;
            n = 0;
            __cobertura_counters[513] = __cobertura_counters[513] + 1;
            PooledObject<T> pooledObject = it.next();
            __cobertura_counters[514] = __cobertura_counters[514] + 1;
            PooledObject<T> pooledObject2 = pooledObject;
            synchronized (pooledObject2) {
                __cobertura_counters[515] = __cobertura_counters[515] + 1;
                n = 517;
                if (pooledObject.getState() == PooledObjectState.ALLOCATED) {
                    __cobertura_counters[516] = __cobertura_counters[516] + 1;
                    n = 0;
                    __cobertura_counters[518] = __cobertura_counters[518] + 1;
                    n = 520;
                    if (pooledObject.getLastUsedTime() <= timeout) {
                        __cobertura_counters[519] = __cobertura_counters[519] + 1;
                        n = 0;
                        __cobertura_counters[521] = __cobertura_counters[521] + 1;
                        pooledObject.markAbandoned();
                        __cobertura_counters[522] = __cobertura_counters[522] + 1;
                        remove.add(pooledObject);
                    }
                }
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[523] = __cobertura_counters[523] + 1;
            }
            __cobertura_counters[524] = __cobertura_counters[524] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[525] = __cobertura_counters[525] + 1;
        Iterator itr = remove.iterator();
        while (true) {
            __cobertura_counters[526] = __cobertura_counters[526] + 1;
            n = 528;
            if (!itr.hasNext()) break;
            __cobertura_counters[527] = __cobertura_counters[527] + 1;
            n = 0;
            __cobertura_counters[529] = __cobertura_counters[529] + 1;
            PooledObject pooledObject = (PooledObject)itr.next();
            __cobertura_counters[530] = __cobertura_counters[530] + 1;
            n = 532;
            if (ac.getLogAbandoned()) {
                __cobertura_counters[531] = __cobertura_counters[531] + 1;
                n = 0;
                __cobertura_counters[533] = __cobertura_counters[533] + 1;
                pooledObject.printStackTrace(ac.getLogWriter());
            }
            try {
                int n4 = n;
                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                n = 0;
                __cobertura_counters[534] = __cobertura_counters[534] + 1;
                this.invalidateObject(pooledObject.getObject());
            }
            catch (Exception exception) {
                __cobertura_counters[535] = __cobertura_counters[535] + 1;
                Exception e = exception;
                __cobertura_counters[536] = __cobertura_counters[536] + 1;
                e.printStackTrace();
            }
            __cobertura_counters[537] = __cobertura_counters[537] + 1;
            __cobertura_counters[538] = __cobertura_counters[538] + 1;
        }
        int n5 = n;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n = 0;
        __cobertura_counters[539] = __cobertura_counters[539] + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void use(T t) {
        int n = 0;
        __cobertura_counters[540] = __cobertura_counters[540] + 1;
        AbandonedConfig ac = this.abandonedConfig;
        __cobertura_counters[541] = __cobertura_counters[541] + 1;
        n = 543;
        if (ac != null) {
            __cobertura_counters[542] = __cobertura_counters[542] + 1;
            n = 0;
            n = 545;
            if (ac.getUseUsageTracking()) {
                void pooledObject;
                __cobertura_counters[544] = __cobertura_counters[544] + 1;
                n = 0;
                __cobertura_counters[546] = __cobertura_counters[546] + 1;
                PooledObject<T> wrapper = this.allObjects.get(new BaseGenericObjectPool.IdentityWrapper<void>(pooledObject));
                __cobertura_counters[547] = __cobertura_counters[547] + 1;
                wrapper.use();
            }
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[548] = __cobertura_counters[548] + 1;
    }

    @Override
    public int getNumWaiters() {
        int n = 0;
        __cobertura_counters[550] = __cobertura_counters[550] + 1;
        n = 552;
        if (this.getBlockWhenExhausted()) {
            __cobertura_counters[551] = __cobertura_counters[551] + 1;
            n = 0;
            __cobertura_counters[553] = __cobertura_counters[553] + 1;
            return this.idleObjects.getTakeQueueLength();
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[554] = __cobertura_counters[554] + 1;
        return 0;
    }

    @Override
    public String getFactoryType() {
        int n = 0;
        __cobertura_counters[555] = __cobertura_counters[555] + 1;
        n = 557;
        if (this.factoryType == null) {
            __cobertura_counters[556] = __cobertura_counters[556] + 1;
            n = 0;
            __cobertura_counters[558] = __cobertura_counters[558] + 1;
            StringBuilder result = new StringBuilder();
            __cobertura_counters[559] = __cobertura_counters[559] + 1;
            result.append(this.factory.getClass().getName());
            __cobertura_counters[560] = __cobertura_counters[560] + 1;
            result.append('<');
            __cobertura_counters[561] = __cobertura_counters[561] + 1;
            __cobertura_counters[562] = __cobertura_counters[562] + 1;
            Class<?> pooledObjectType = PoolImplUtils.getFactoryType(this.factory.getClass());
            __cobertura_counters[563] = __cobertura_counters[563] + 1;
            result.append(pooledObjectType.getName());
            __cobertura_counters[564] = __cobertura_counters[564] + 1;
            result.append('>');
            __cobertura_counters[565] = __cobertura_counters[565] + 1;
            this.factoryType = result.toString();
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[566] = __cobertura_counters[566] + 1;
        return this.factoryType;
    }

    @Override
    public Set<DefaultPooledObjectInfo> listAllObjects() {
        int n = 0;
        __cobertura_counters[567] = __cobertura_counters[567] + 1;
        __cobertura_counters[568] = __cobertura_counters[568] + 1;
        HashSet<DefaultPooledObjectInfo> result = new HashSet<DefaultPooledObjectInfo>(this.allObjects.size());
        __cobertura_counters[569] = __cobertura_counters[569] + 1;
        Iterator<PooledObject<T>> iterator = this.allObjects.values().iterator();
        while (true) {
            n = 571;
            if (!iterator.hasNext()) break;
            __cobertura_counters[570] = __cobertura_counters[570] + 1;
            n = 0;
            PooledObject<T> p = iterator.next();
            __cobertura_counters[572] = __cobertura_counters[572] + 1;
            result.add(new DefaultPooledObjectInfo(p));
            __cobertura_counters[573] = __cobertura_counters[573] + 1;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[574] = __cobertura_counters[574] + 1;
        return result;
    }

    static {
        GenericObjectPool.__cobertura_init();
    }

    public static void __cobertura_init() {
        if (__cobertura_counters == null) {
            __cobertura_counters = new int[580];
            TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/GenericObjectPool");
        }
    }

    public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.putLineTouchPoint(90, 1, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(91, 2, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(107, 3, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(109, 4, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putJumpTouchPoint(109, 6, 5);
        lightClassmapListener2.putLineTouchPoint(110, 7, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(111, 8, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(113, 9, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(115, 10, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(117, 11, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(119, 12, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(120, 13, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(137, 14, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(138, 15, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(139, 16, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(157, 17, "getMaxIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(177, 18, "setMaxIdle", "(I)V");
        lightClassmapListener2.putLineTouchPoint(178, 19, "setMaxIdle", "(I)V");
        lightClassmapListener2.putLineTouchPoint(198, 20, "setMinIdle", "(I)V");
        lightClassmapListener2.putLineTouchPoint(199, 21, "setMinIdle", "(I)V");
        lightClassmapListener2.putLineTouchPoint(219, 22, "getMinIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(220, 23, "getMinIdle", "()I");
        lightClassmapListener2.putJumpTouchPoint(220, 25, 24);
        lightClassmapListener2.putLineTouchPoint(221, 26, "getMinIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(223, 27, "getMinIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(235, 28, "isAbandonedConfig", "()Z");
        lightClassmapListener2.putJumpTouchPoint(235, 30, 29);
        lightClassmapListener2.putLineTouchPoint(248, 31, "getLogAbandoned", "()Z");
        lightClassmapListener2.putLineTouchPoint(249, 32, "getLogAbandoned", "()Z");
        lightClassmapListener2.putJumpTouchPoint(249, 34, 33);
        lightClassmapListener2.putJumpTouchPoint(249, 36, 35);
        lightClassmapListener2.putLineTouchPoint(263, 37, "getRemoveAbandonedOnBorrow", "()Z");
        lightClassmapListener2.putLineTouchPoint(264, 38, "getRemoveAbandonedOnBorrow", "()Z");
        lightClassmapListener2.putJumpTouchPoint(264, 40, 39);
        lightClassmapListener2.putJumpTouchPoint(264, 42, 41);
        lightClassmapListener2.putLineTouchPoint(277, 43, "getRemoveAbandonedOnMaintenance", "()Z");
        lightClassmapListener2.putLineTouchPoint(278, 44, "getRemoveAbandonedOnMaintenance", "()Z");
        lightClassmapListener2.putJumpTouchPoint(278, 46, 45);
        lightClassmapListener2.putJumpTouchPoint(278, 48, 47);
        lightClassmapListener2.putLineTouchPoint(292, 49, "getRemoveAbandonedTimeout", "()I");
        lightClassmapListener2.putLineTouchPoint(293, 50, "getRemoveAbandonedTimeout", "()I");
        lightClassmapListener2.putJumpTouchPoint(293, 52, 51);
        lightClassmapListener2.putLineTouchPoint(305, 53, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(306, 54, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(307, 55, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(308, 56, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(309, 57, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(310, 58, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(311, 59, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(312, 60, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(313, 61, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(314, 62, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(315, 63, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(316, 64, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(317, 65, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(317, 66, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(318, 67, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(319, 68, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(319, 69, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(320, 70, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(321, 71, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(322, 72, "setConfig", "(Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(332, 73, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putJumpTouchPoint(332, 75, 74);
        lightClassmapListener2.putLineTouchPoint(333, 76, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(335, 77, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(336, 78, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(337, 79, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(338, 80, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(339, 81, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(340, 82, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(341, 83, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(343, 84, "setAbandonedConfig", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(352, 85, "getFactory", "()Lorg/apache/commons/pool2/PooledObjectFactory;");
        lightClassmapListener2.putLineTouchPoint(363, 86, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(412, 87, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(414, 88, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(415, 89, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(415, 91, 90);
        lightClassmapListener2.putJumpTouchPoint(415, 93, 92);
        lightClassmapListener2.putLineTouchPoint(416, 94, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(416, 96, 95);
        lightClassmapListener2.putLineTouchPoint(417, 97, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(417, 99, 98);
        lightClassmapListener2.putLineTouchPoint(418, 100, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(421, 101, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(425, 102, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(428, 103, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(430, 104, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(430, 106, 105);
        lightClassmapListener2.putLineTouchPoint(431, 107, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(432, 108, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(432, 110, 109);
        lightClassmapListener2.putLineTouchPoint(433, 111, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(434, 112, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(434, 114, 113);
        lightClassmapListener2.putLineTouchPoint(435, 115, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(436, 116, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(436, 118, 117);
        lightClassmapListener2.putLineTouchPoint(437, 119, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(440, 120, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(440, 122, 121);
        lightClassmapListener2.putLineTouchPoint(441, 123, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(441, 125, 124);
        lightClassmapListener2.putLineTouchPoint(442, 126, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(444, 127, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(448, 128, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(448, 130, 129);
        lightClassmapListener2.putLineTouchPoint(449, 131, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(452, 132, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(452, 134, 133);
        lightClassmapListener2.putLineTouchPoint(453, 135, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(456, 136, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(457, 137, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(457, 139, 138);
        lightClassmapListener2.putLineTouchPoint(458, 140, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(459, 141, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(459, 143, 142);
        lightClassmapListener2.putLineTouchPoint(460, 144, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(463, 145, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(463, 147, 146);
        lightClassmapListener2.putLineTouchPoint(464, 148, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(466, 149, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(466, 151, 150);
        lightClassmapListener2.putLineTouchPoint(467, 152, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(471, 153, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(471, 155, 154);
        lightClassmapListener2.putLineTouchPoint(473, 156, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(474, 157, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(476, 158, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(477, 159, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(479, 160, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(480, 161, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(481, 162, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(481, 164, 163);
        lightClassmapListener2.putLineTouchPoint(482, 165, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(484, 166, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(485, 167, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(487, 168, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(488, 169, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(488, 171, 170);
        lightClassmapListener2.putJumpTouchPoint(488, 173, 172);
        lightClassmapListener2.putJumpTouchPoint(488, 175, 174);
        lightClassmapListener2.putJumpTouchPoint(488, 177, 176);
        lightClassmapListener2.putLineTouchPoint(489, 178, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(490, 179, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(492, 180, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(493, 181, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(494, 182, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(495, 183, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(496, 184, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(497, 185, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(497, 187, 186);
        lightClassmapListener2.putLineTouchPoint(499, 188, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(500, 189, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(501, 190, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(503, 191, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(504, 192, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(505, 193, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(505, 195, 194);
        lightClassmapListener2.putLineTouchPoint(506, 196, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(508, 197, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(509, 198, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(512, 199, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(516, 200, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(518, 201, "borrowObject", "(J)Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(537, 202, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(539, 203, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(539, 205, 204);
        lightClassmapListener2.putLineTouchPoint(540, 206, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(540, 208, 207);
        lightClassmapListener2.putLineTouchPoint(541, 209, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(544, 210, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(548, 211, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(549, 212, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(550, 213, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(550, 215, 214);
        lightClassmapListener2.putLineTouchPoint(551, 216, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(554, 217, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(556, 218, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(558, 219, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(560, 220, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(560, 222, 221);
        lightClassmapListener2.putLineTouchPoint(561, 223, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(561, 225, 224);
        lightClassmapListener2.putLineTouchPoint(563, 226, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(564, 227, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(565, 228, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(566, 229, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(568, 230, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(569, 231, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(570, 232, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(571, 233, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(572, 234, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(573, 235, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(578, 236, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(579, 237, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(580, 238, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(582, 239, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(583, 240, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(584, 241, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(585, 242, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(587, 243, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(588, 244, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(589, 245, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(590, 246, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(591, 247, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(592, 248, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(593, 249, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(595, 250, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(595, 252, 251);
        lightClassmapListener2.putLineTouchPoint(596, 253, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(600, 254, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(601, 255, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(601, 257, 256);
        lightClassmapListener2.putJumpTouchPoint(601, 259, 258);
        lightClassmapListener2.putJumpTouchPoint(601, 261, 260);
        lightClassmapListener2.putLineTouchPoint(603, 262, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(604, 263, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(605, 264, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(606, 265, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(606, 266, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(608, 267, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(608, 269, 268);
        lightClassmapListener2.putLineTouchPoint(609, 270, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(611, 271, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(613, 272, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(613, 274, 273);
        lightClassmapListener2.putLineTouchPoint(617, 275, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(620, 276, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(621, 277, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(635, 278, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(636, 279, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(636, 281, 280);
        lightClassmapListener2.putLineTouchPoint(637, 282, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(637, 284, 283);
        lightClassmapListener2.putLineTouchPoint(638, 285, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(640, 286, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(644, 287, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(645, 288, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(645, 290, 289);
        lightClassmapListener2.putLineTouchPoint(646, 291, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(648, 292, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(649, 293, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(650, 294, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(671, 295, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(673, 296, "clear", "()V");
        lightClassmapListener2.putJumpTouchPoint(673, 298, 297);
        lightClassmapListener2.putLineTouchPoint(675, 299, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(676, 300, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(677, 301, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(678, 302, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(679, 303, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(681, 304, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(685, 305, "getNumActive", "()I");
        lightClassmapListener2.putLineTouchPoint(690, 306, "getNumIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(703, 307, "close", "()V");
        lightClassmapListener2.putJumpTouchPoint(703, 309, 308);
        lightClassmapListener2.putLineTouchPoint(704, 310, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(707, 311, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(708, 312, "close", "()V");
        lightClassmapListener2.putJumpTouchPoint(708, 314, 313);
        lightClassmapListener2.putLineTouchPoint(709, 315, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(714, 316, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(716, 317, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(718, 318, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(720, 319, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(723, 320, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(724, 321, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(725, 322, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(735, 323, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(737, 324, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(737, 326, 325);
        lightClassmapListener2.putLineTouchPoint(739, 327, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(740, 328, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(742, 329, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(743, 330, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(744, 331, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(745, 332, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(746, 333, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(748, 334, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(750, 335, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(750, 337, 336);
        lightClassmapListener2.putLineTouchPoint(750, 338, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(751, 339, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(751, 341, 340);
        lightClassmapListener2.putJumpTouchPoint(751, 343, 342);
        lightClassmapListener2.putLineTouchPoint(752, 344, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(754, 345, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(754, 347, 346);
        lightClassmapListener2.putLineTouchPoint(756, 348, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(760, 349, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(761, 350, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(764, 351, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(765, 352, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(766, 353, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(767, 354, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(769, 355, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(769, 357, 356);
        lightClassmapListener2.putLineTouchPoint(772, 358, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(773, 359, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(781, 360, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(781, 361, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(782, 362, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(783, 363, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(786, 364, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(787, 365, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(789, 366, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(790, 367, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(792, 368, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(792, 370, 369);
        lightClassmapListener2.putLineTouchPoint(793, 371, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(794, 372, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(796, 373, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(796, 375, 374);
        lightClassmapListener2.putLineTouchPoint(797, 376, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(799, 377, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(800, 378, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(801, 379, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(802, 380, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(803, 381, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(804, 382, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(805, 383, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(805, 385, 384);
        lightClassmapListener2.putLineTouchPoint(806, 386, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(806, 388, 387);
        lightClassmapListener2.putLineTouchPoint(807, 389, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(808, 390, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(811, 391, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(812, 392, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(813, 393, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(814, 394, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(815, 395, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(819, 396, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(819, 398, 397);
        lightClassmapListener2.putLineTouchPoint(825, 399, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(827, 400, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(828, 401, "evict", "()V");
        lightClassmapListener2.putJumpTouchPoint(828, 403, 402);
        lightClassmapListener2.putJumpTouchPoint(828, 405, 404);
        lightClassmapListener2.putLineTouchPoint(829, 406, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(831, 407, "evict", "()V");
        lightClassmapListener2.putLineTouchPoint(841, 408, "preparePool", "()V");
        lightClassmapListener2.putJumpTouchPoint(841, 410, 409);
        lightClassmapListener2.putLineTouchPoint(842, 411, "preparePool", "()V");
        lightClassmapListener2.putLineTouchPoint(844, 412, "preparePool", "()V");
        lightClassmapListener2.putLineTouchPoint(845, 413, "preparePool", "()V");
        lightClassmapListener2.putLineTouchPoint(858, 414, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(859, 415, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(860, 416, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putJumpTouchPoint(860, 418, 417);
        lightClassmapListener2.putJumpTouchPoint(860, 420, 419);
        lightClassmapListener2.putJumpTouchPoint(860, 422, 421);
        lightClassmapListener2.putLineTouchPoint(862, 423, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(863, 424, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(868, 425, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(869, 426, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(870, 427, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(871, 428, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(872, 429, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(874, 430, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(875, 431, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putJumpTouchPoint(875, 433, 432);
        lightClassmapListener2.putJumpTouchPoint(875, 435, 434);
        lightClassmapListener2.putLineTouchPoint(876, 436, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(879, 437, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(880, 438, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(881, 439, "create", "()Lorg/apache/commons/pool2/PooledObject;");
        lightClassmapListener2.putLineTouchPoint(893, 440, "destroy", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(894, 441, "destroy", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(895, 442, "destroy", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(897, 443, "destroy", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(899, 444, "destroy", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(900, 445, "destroy", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(901, 446, "destroy", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(902, 447, "destroy", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(906, 448, "ensureMinIdle", "()V");
        lightClassmapListener2.putLineTouchPoint(907, 449, "ensureMinIdle", "()V");
        lightClassmapListener2.putLineTouchPoint(922, 450, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putJumpTouchPoint(922, 452, 451);
        lightClassmapListener2.putJumpTouchPoint(922, 454, 453);
        lightClassmapListener2.putJumpTouchPoint(922, 456, 455);
        lightClassmapListener2.putJumpTouchPoint(922, 458, 457);
        lightClassmapListener2.putLineTouchPoint(923, 459, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putLineTouchPoint(926, 460, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putJumpTouchPoint(926, 462, 461);
        lightClassmapListener2.putLineTouchPoint(927, 463, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putLineTouchPoint(928, 464, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putJumpTouchPoint(928, 466, 465);
        lightClassmapListener2.putLineTouchPoint(931, 467, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putLineTouchPoint(933, 468, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putJumpTouchPoint(933, 470, 469);
        lightClassmapListener2.putLineTouchPoint(934, 471, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putLineTouchPoint(936, 472, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putLineTouchPoint(938, 473, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putLineTouchPoint(939, 474, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putJumpTouchPoint(939, 476, 475);
        lightClassmapListener2.putLineTouchPoint(943, 477, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putLineTouchPoint(945, 478, "ensureIdle", "(IZ)V");
        lightClassmapListener2.putLineTouchPoint(956, 479, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(957, 480, "addObject", "()V");
        lightClassmapListener2.putJumpTouchPoint(957, 482, 481);
        lightClassmapListener2.putLineTouchPoint(958, 483, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(961, 484, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(962, 485, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(963, 486, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(975, 487, "addIdleObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putJumpTouchPoint(975, 489, 488);
        lightClassmapListener2.putLineTouchPoint(976, 490, "addIdleObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(977, 491, "addIdleObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putJumpTouchPoint(977, 493, 492);
        lightClassmapListener2.putLineTouchPoint(978, 494, "addIdleObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(980, 495, "addIdleObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(983, 496, "addIdleObject", "(Lorg/apache/commons/pool2/PooledObject;)V");
        lightClassmapListener2.putLineTouchPoint(992, 497, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(993, 498, "getNumTests", "()I");
        lightClassmapListener2.putJumpTouchPoint(993, 500, 499);
        lightClassmapListener2.putLineTouchPoint(994, 501, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(996, 502, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(996, 503, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(997, 504, "getNumTests", "()I");
        lightClassmapListener2.putLineTouchPoint(1009, 505, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1010, 506, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1011, 507, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1012, 508, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1013, 509, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1014, 510, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putJumpTouchPoint(1014, 512, 511);
        lightClassmapListener2.putLineTouchPoint(1015, 513, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1016, 514, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1017, 515, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putJumpTouchPoint(1017, 517, 516);
        lightClassmapListener2.putLineTouchPoint(1018, 518, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putJumpTouchPoint(1018, 520, 519);
        lightClassmapListener2.putLineTouchPoint(1019, 521, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1020, 522, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1022, 523, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1023, 524, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1026, 525, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1027, 526, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putJumpTouchPoint(1027, 528, 527);
        lightClassmapListener2.putLineTouchPoint(1028, 529, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1029, 530, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putJumpTouchPoint(1029, 532, 531);
        lightClassmapListener2.putLineTouchPoint(1030, 533, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1033, 534, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1034, 535, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1035, 536, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1036, 537, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1037, 538, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1038, 539, "removeAbandoned", "(Lorg/apache/commons/pool2/impl/AbandonedConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1045, 540, "use", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1046, 541, "use", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(1046, 543, 542);
        lightClassmapListener2.putJumpTouchPoint(1046, 545, 544);
        lightClassmapListener2.putLineTouchPoint(1047, 546, "use", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1048, 547, "use", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1050, 548, "use", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(1055, 549, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1067, 550, "getNumWaiters", "()I");
        lightClassmapListener2.putJumpTouchPoint(1067, 552, 551);
        lightClassmapListener2.putLineTouchPoint(1068, 553, "getNumWaiters", "()I");
        lightClassmapListener2.putLineTouchPoint(1070, 554, "getNumWaiters", "()I");
        lightClassmapListener2.putLineTouchPoint(1083, 555, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putJumpTouchPoint(1083, 557, 556);
        lightClassmapListener2.putLineTouchPoint(1084, 558, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1085, 559, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1086, 560, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1087, 561, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1088, 562, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1089, 563, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1090, 564, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1091, 565, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1093, 566, "getFactoryType", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1109, 567, "listAllObjects", "()Ljava/util/Set;");
        lightClassmapListener2.putLineTouchPoint(1110, 568, "listAllObjects", "()Ljava/util/Set;");
        lightClassmapListener2.putLineTouchPoint(1111, 569, "listAllObjects", "()Ljava/util/Set;");
        lightClassmapListener2.putJumpTouchPoint(1111, 571, 570);
        lightClassmapListener2.putLineTouchPoint(1112, 572, "listAllObjects", "()Ljava/util/Set;");
        lightClassmapListener2.putLineTouchPoint(1113, 573, "listAllObjects", "()Ljava/util/Set;");
        lightClassmapListener2.putLineTouchPoint(1114, 574, "listAllObjects", "()Ljava/util/Set;");
        lightClassmapListener2.putLineTouchPoint(1119, 575, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1120, 576, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1133, 577, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1142, 578, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
        lightClassmapListener2.putLineTouchPoint(1150, 579, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;)V");
    }

    public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/GenericObjectPool");
        lightClassmapListener2.setSource("GenericObjectPool.java");
        GenericObjectPool.__cobertura_classmap_0(lightClassmapListener2);
    }

    public static int[] __cobertura_get_and_reset_counters() {
        int[] nArray = __cobertura_counters;
        __cobertura_counters = new int[__cobertura_counters.length];
        return nArray;
    }
}

