/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;

final class Utils {
    public static void compare(String message, String[][] expected, List<CSVRecord> actual) {
        int expectedLength = expected.length;
        Assertions.assertEquals((int)expectedLength, (int)actual.size(), (String)(message + "  - outer array size"));
        for (int i = 0; i < expectedLength; ++i) {
            Assertions.assertArrayEquals((Object[])expected[i], (Object[])actual.get(i).values(), (String)(message + " (entry " + i + ")"));
        }
    }

    static InputStream createUtf8Input(byte[] baseData, boolean addBom) {
        byte[] data = baseData;
        if (addBom) {
            data = new byte[baseData.length + 3];
            data[0] = -17;
            data[1] = -69;
            data[2] = -65;
            System.arraycopy(baseData, 0, data, 3, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private Utils() {
    }
}

