/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.DuplicateHeaderMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CSVDuplicateHeaderTest {
    static Stream<Arguments> duplicateHeaderAllowsMissingColumnsNamesData() {
        return CSVDuplicateHeaderTest.duplicateHeaderData().filter(arg -> Boolean.TRUE.equals(arg.get()[1]) && Boolean.FALSE.equals(arg.get()[2])).flatMap(arg -> {
            Object[][] data = new Object[4][];
            Boolean[] flags = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
            int i = 0;
            for (Boolean a : flags) {
                for (Boolean b : flags) {
                    data[i] = (Object[])arg.get().clone();
                    data[i][1] = a;
                    data[i][2] = b;
                    ++i;
                }
            }
            return Arrays.stream(data).map(Arguments::of);
        });
    }

    static Stream<Arguments> duplicateHeaderData() {
        return Stream.of(Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", "B"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", "B"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", "B"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", "B"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", "B"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", "B"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", " "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", " "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", " "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", "A"}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", "A"}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", "A"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", "A"}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", "A"}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", "A"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{" ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{" ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{" ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{" ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{" ", " "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{" ", " "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"   ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"   ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"   ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"   ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"   ", "   "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"   ", "   "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{null, null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{null, null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{" ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{" ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{" ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{" ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{" ", "   "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{" ", "   "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{" ", null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{" ", null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{" ", null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{" ", null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{" ", null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{" ", null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", "A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", "A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", "A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", "A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", "A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", "A", "", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", "B", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", "B", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", "B", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", "B", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", "B", "", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", "B", "", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", "A", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", "A", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", "A", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", "A", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", "A", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", "A", " ", " "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", "A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", "A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", "A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", "A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", "A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", "A", null, null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", "", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", "", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", null, null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", null, null}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, false, new String[]{"A", " ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, false, new String[]{"A", " ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, false, new String[]{"A", " ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, false, new String[]{"A", " ", "   "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, false, new String[]{"A", " ", "   "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, false, new String[]{"A", " ", "   "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, true, new String[]{"A", "a"}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, true, new String[]{"A", "a"}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, true, new String[]{"A", "a"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, true, new String[]{"A", "a"}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, true, new String[]{"A", "a"}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, true, new String[]{"A", "a"}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, true, new String[]{"A", "a", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, true, new String[]{"A", "a", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, true, new String[]{"A", "a", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, true, new String[]{"A", "a", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, true, new String[]{"A", "a", "", ""}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, true, new String[]{"A", "a", "", ""}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, true, new String[]{"A", "a", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, true, new String[]{"A", "a", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, true, new String[]{"A", "a", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, true, new String[]{"A", "a", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, true, new String[]{"A", "a", " ", " "}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, true, new String[]{"A", "a", " ", " "}, true}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, false, true, new String[]{"A", "a", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, false, true, new String[]{"A", "a", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, false, true, new String[]{"A", "a", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.DISALLOW, true, true, new String[]{"A", "a", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_EMPTY, true, true, new String[]{"A", "a", null, null}, false}), Arguments.of((Object[])new Object[]{DuplicateHeaderMode.ALLOW_ALL, true, true, new String[]{"A", "a", null, null}, true}));
    }

    @ParameterizedTest
    @MethodSource(value={"duplicateHeaderAllowsMissingColumnsNamesData"})
    public void testCSVFormat(DuplicateHeaderMode duplicateHeaderMode, boolean allowMissingColumnNames, boolean ignoreHeaderCase, String[] headers, boolean valid) {
        CSVFormat.Builder builder = CSVFormat.DEFAULT.builder().setDuplicateHeaderMode(duplicateHeaderMode).setAllowMissingColumnNames(allowMissingColumnNames).setIgnoreHeaderCase(ignoreHeaderCase).setHeader(headers);
        if (valid) {
            CSVFormat format = builder.get();
            Assertions.assertEquals((Object)duplicateHeaderMode, (Object)format.getDuplicateHeaderMode(), (String)"DuplicateHeaderMode");
            Assertions.assertEquals((Object)allowMissingColumnNames, (Object)format.getAllowMissingColumnNames(), (String)"AllowMissingColumnNames");
            Assertions.assertArrayEquals((Object[])headers, (Object[])format.getHeader(), (String)"Header");
        } else {
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((CSVFormat.Builder)builder).get());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"duplicateHeaderData"})
    public void testCSVParser(DuplicateHeaderMode duplicateHeaderMode, boolean allowMissingColumnNames, boolean ignoreHeaderCase, String[] headers, boolean valid) throws IOException {
        CSVFormat format = CSVFormat.DEFAULT.builder().setDuplicateHeaderMode(duplicateHeaderMode).setAllowMissingColumnNames(allowMissingColumnNames).setIgnoreHeaderCase(ignoreHeaderCase).setNullString("NULL").setHeader(new String[0]).get();
        String input = Arrays.stream(headers).map(s -> s == null ? format.getNullString() : s).collect(Collectors.joining(format.getDelimiterString()));
        if (valid) {
            try (CSVParser parser = CSVParser.parse((String)input, (CSVFormat)format);){
                List expected = Arrays.stream(headers).filter(s -> s != null).collect(Collectors.toList());
                Assertions.assertEquals(expected, (Object)parser.getHeaderNames(), (String)"HeaderNames");
            }
        } else {
            Assertions.assertThrows(IllegalArgumentException.class, () -> CSVParser.parse((String)input, (CSVFormat)format));
        }
    }
}

