/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript;

import java.util.LinkedList;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPropertyPointer;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class ScriptablePropertyPointer
extends DynamicPropertyPointer {
    DynamicPropertyHandler handler;

    public ScriptablePropertyPointer(NodePointer parent, DynamicPropertyHandler handler) {
        super(parent, handler);
        this.handler = handler;
    }

    public int getLength() {
        Object obj = this.getBaseValue();
        if (obj instanceof Scriptable) {
            Object val;
            Scriptable node = (Scriptable)obj;
            if (node instanceof NativeArray) {
                return (int)((NativeArray)node).jsGet_length();
            }
            if (ScriptableObject.hasProperty((Scriptable)node, (String)"length") && (val = ScriptableObject.getProperty((Scriptable)node, (String)"length")) instanceof Number) {
                return ((Number)val).intValue();
            }
        }
        return super.getLength();
    }

    public Object getImmediateNode() {
        Object value;
        if (this.index == Integer.MIN_VALUE) {
            value = this.getBaseValue();
        } else {
            value = this.getBaseValue();
            if (value instanceof Scriptable) {
                Object property = ScriptableObject.getProperty((Scriptable)((Scriptable)value), (int)this.index);
                if (property != Scriptable.NOT_FOUND) {
                    value = property;
                }
            } else {
                return super.getImmediateNode();
            }
        }
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).unwrap();
        }
        return value;
    }

    public Object getValue() {
        Object val = this.getNode();
        if (val instanceof NativeArray) {
            NativeArray arr = (NativeArray)val;
            LinkedList<Object> list = new LinkedList<Object>();
            int len = (int)arr.jsGet_length();
            for (int i = 0; i < len; ++i) {
                Object obj = arr.get(i, (Scriptable)arr);
                if (obj == Undefined.instance) {
                    obj = null;
                }
                list.add(obj);
            }
            return list;
        }
        return super.getValue();
    }

    public void setValue(Object value) {
        if (this.index == Integer.MIN_VALUE) {
            this.handler.setProperty(this.getBean(), this.getPropertyName(), value);
        } else {
            Object val = this.handler.getProperty(this.getBean(), this.getPropertyName());
            if (val instanceof Scriptable) {
                ScriptableObject.putProperty((Scriptable)((Scriptable)val), (int)this.index, (Object)value);
            } else {
                super.setValue(value);
            }
        }
    }

    public void remove() {
        if (this.index == Integer.MIN_VALUE) {
            this.handler.setProperty(this.getBean(), "length", (Object)new Integer(0));
        } else {
            Object val = this.handler.getProperty(this.getBean(), this.getPropertyName());
            if (val instanceof Scriptable) {
                try {
                    ScriptableObject.deleteProperty((Scriptable)((Scriptable)val), (int)this.index);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                super.remove();
            }
        }
    }

    public boolean isCollection() {
        Object obj = this.getBaseValue();
        if (obj instanceof NativeArray) {
            return true;
        }
        return super.isCollection();
    }

    public String asPath() {
        Object obj = this.getBaseValue();
        if (!(obj instanceof Scriptable)) {
            return super.asPath();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getParent().asPath());
        if (buffer.length() == 0) {
            buffer.append("/.");
        } else if (buffer.charAt(buffer.length() - 1) == '/') {
            buffer.append('.');
        }
        buffer.append("[@name = '");
        buffer.append(this.escape(this.getPropertyName()));
        buffer.append("']");
        if (this.index != Integer.MIN_VALUE && obj instanceof NativeArray) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    protected String escape(String string) {
        int index = string.indexOf(39);
        while (index != -1) {
            string = string.substring(0, index) + "&apos;" + string.substring(index + 1);
            index = string.indexOf(39);
        }
        index = string.indexOf(34);
        while (index != -1) {
            string = string.substring(0, index) + "&quot;" + string.substring(index + 1);
            index = string.indexOf(34);
        }
        return string;
    }
}

