/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.web.fileserver.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTypeGuesser {
    static MediaTypeGuesser instance;
    private final Logger logger = LoggerFactory.getLogger(MediaTypeGuesser.class);
    private Map<String, MediaType> extendsion2MediaTypeMap = new HashMap<String, MediaType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaTypeGuesser getInstance() {
        if (instance != null) return instance;
        Class<MediaTypeGuesser> clazz = MediaTypeGuesser.class;
        synchronized (MediaTypeGuesser.class) {
            if (instance != null) return instance;
            instance = new MediaTypeGuesser();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MediaTypeGuesser() {
        try {
            InputStreamReader in = new InputStreamReader(MediaTypeGuesser.class.getResourceAsStream("mime.types"));
            BufferedReader reader = new BufferedReader(in);
            String line = reader.readLine();
            while (line != null) {
                if (line.length() != 0 && line.charAt(0) != '#') {
                    StringTokenizer tokens = new StringTokenizer(line);
                    String mimeTypeString = tokens.nextToken();
                    MediaType mediaType = MediaType.valueOf((String)mimeTypeString);
                    while (tokens.hasMoreTokens()) {
                        String extension = tokens.nextToken();
                        this.extendsion2MediaTypeMap.put(extension, mediaType);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            this.logger.error("IOException thrown {}", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public MediaType getTypeForExtension(String extension) {
        return this.extendsion2MediaTypeMap.get(extension);
    }

    public MediaType guessTypeForName(String fileName) {
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos == -1) {
            return null;
        }
        return this.getTypeForExtension(fileName.substring(dotPos + 1).toLowerCase());
    }
}

