/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.platform.content.imagemetadata;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.ws.rs.core.MediaType;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.metadata.MetaDataGenerator;
import org.apache.clerezza.rdf.ontologies.EXIF;
import org.apache.clerezza.rdf.utils.GraphNode;

public class ImageMetaDataGenerator
implements MetaDataGenerator {
    public void generate(GraphNode node, byte[] data, MediaType mediaType) {
        if (mediaType.getType().startsWith("image")) {
            try {
                BufferedImage buffImage = ImageIO.read(new ByteArrayInputStream(data));
                node.deleteProperties(EXIF.width);
                node.deleteProperties(EXIF.height);
                node.addProperty(EXIF.width, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)buffImage.getWidth()));
                node.addProperty(EXIF.height, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)buffImage.getHeight()));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

