/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.testcontainers;

import java.time.Duration;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.unit.testcontainers.TestContainerProvider;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class OracleContainerProvider
extends TestContainerProvider {
    @Override
    public JdbcDatabaseContainer<?> startContainer(String version) {
        JdbcDatabaseContainer<?> container = super.startContainer(version);
        try {
            Thread.sleep(40000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return container;
    }

    @Override
    JdbcDatabaseContainer<?> createContainer(DockerImageName dockerImageName) {
        return (JdbcDatabaseContainer)((OracleContainer)((OracleContainer)new OracleContainer(dockerImageName).withStartupTimeout(Duration.ofMinutes(5L))).withEnv("ORACLE_ALLOW_REMOTE", "true")).withEnv("ORACLE_DISABLE_ASYNCH_IO", "true");
    }

    @Override
    String getDockerImage() {
        return "oracleinanutshell/oracle-xe-11g";
    }

    @Override
    public Class<? extends JdbcAdapter> getAdapterClass() {
        return OracleAdapter.class;
    }
}

