/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ProcedureResult;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.ProcedureCall;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.ExternalTransaction;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ProcedureCallIT
extends ServerCase {
    public static final String UPDATE_STORED_PROCEDURE = "cayenne_tst_upd_proc";
    public static final String UPDATE_STORED_PROCEDURE_NOPARAM = "cayenne_tst_upd_proc2";
    public static final String SELECT_STORED_PROCEDURE = "cayenne_tst_select_proc";
    public static final String OUT_STORED_PROCEDURE = "cayenne_tst_out_proc";
    @Inject
    private DataContext context;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    private JdbcEventLogger jdbcEventLogger;

    @Test
    public void testUpdate() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        this.createArtist(1000.0);
        this.runProcedureSelect(ProcedureCall.query(UPDATE_STORED_PROCEDURE).param("paintingPrice", 3000));
        List artists = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist a = (Artist)artists.get(0);
        Painting p = a.getPaintingArray().get(0);
        Assert.assertEquals((long)2000L, (long)p.getEstimatedPrice().intValue());
    }

    @Test
    public void testUpdateNoParam() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        this.createArtist(1000.0);
        this.runProcedureSelect(ProcedureCall.query(UPDATE_STORED_PROCEDURE_NOPARAM));
        List artists = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist a = (Artist)artists.get(0);
        Painting p = a.getPaintingArray().get(0);
        Assert.assertEquals((long)2000L, (long)p.getEstimatedPrice().intValue());
    }

    @Test
    public void testSelect() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        this.createArtist(1000.0);
        List artists = this.runProcedureSelect(ProcedureCall.query(SELECT_STORED_PROCEDURE).param("aName", "An Artist").param("paintingPrice", 3000)).firstList();
        Assert.assertNotNull((String)"Null result from StoredProcedure.", artists);
        Assert.assertEquals((long)1L, (long)artists.size());
        DataRow artistRow = (DataRow)artists.get(0);
        Artist a = this.context.objectFromDataRow(Artist.class, this.uppercaseConverter(artistRow));
        Painting p = a.getPaintingArray().get(0);
        this.context.invalidateObjects(p);
        Assert.assertEquals((long)2000L, (long)p.getEstimatedPrice().intValue());
    }

    @Test
    public void testFetchLimit() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        this.createArtist(1000.0);
        this.createArtist(2000.0);
        this.createArtist(3000.0);
        List artists = this.runProcedureSelect(ProcedureCall.query(SELECT_STORED_PROCEDURE).param("aName", "An Artist").param("paintingPrice", 3000).limit(2)).firstList();
        Assert.assertEquals((long)2L, (long)artists.size());
    }

    @Test
    public void testFetchOffset() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        this.createArtist(1000.0);
        this.createArtist(2000.0);
        this.createArtist(3000.0);
        List artists = this.runProcedureSelect(ProcedureCall.query(SELECT_STORED_PROCEDURE).param("aName", "An Artist").param("paintingPrice", 3000).offset(2)).firstList();
        Assert.assertEquals((long)1L, (long)artists.size());
    }

    @Test
    public void testColumnNameCapitalization() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        this.createArtist(1000.0);
        List artists = this.runProcedureSelect(ProcedureCall.query(SELECT_STORED_PROCEDURE).param("aName", "An Artist").capsStrategy(CapsStrategy.LOWER)).firstList();
        List artists1 = this.runProcedureSelect(ProcedureCall.query(SELECT_STORED_PROCEDURE).param("aName", "An Artist").capsStrategy(CapsStrategy.UPPER)).firstList();
        Assert.assertTrue((boolean)((DataRow)artists.get(0)).containsKey("date_of_birth"));
        Assert.assertFalse((boolean)((DataRow)artists.get(0)).containsKey("DATE_OF_BIRTH"));
        Assert.assertFalse((boolean)((DataRow)artists1.get(0)).containsKey("date_of_birth"));
        Assert.assertTrue((boolean)((DataRow)artists1.get(0)).containsKey("DATE_OF_BIRTH"));
    }

    @Test
    public void testOutParams() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        ProcedureResult result = this.runProcedureSelect(ProcedureCall.query(OUT_STORED_PROCEDURE).param("in_param", 20));
        Number price = (Number)result.getOutParam("out_param");
        Assert.assertEquals((long)40L, (long)price.intValue());
    }

    @Test
    public void testSelectDataObject() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        if (!this.accessStackAdapter.canMakeObjectsOutOfProcedures()) {
            return;
        }
        this.createArtist(1101.01);
        List artists = this.runProcedureSelect(ProcedureCall.query(SELECT_STORED_PROCEDURE, Artist.class).param("aName", "An Artist")).firstList();
        Assert.assertNotNull((String)"Null result from StoredProcedure.", artists);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist a = (Artist)artists.get(0);
        Painting p = a.getPaintingArray().get(0);
        this.context.invalidateObjects(p);
        Assert.assertEquals((double)1101.01, (double)p.getEstimatedPrice().doubleValue(), (double)0.02);
    }

    @Test
    public void testSelectWithRowDescriptor() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        this.createArtist(1000.0);
        ColumnDescriptor[] columns = new ColumnDescriptor[]{new ColumnDescriptor("ARTIST_ID", -5), new ColumnDescriptor("ARTIST_NAME", 1), new ColumnDescriptor("DATE_OF_BIRTH", 91)};
        List rows = this.runProcedureSelect(ProcedureCall.dataRowQuery(SELECT_STORED_PROCEDURE).param("aName", "An Artist").param("paintingPrice", 3000).resultDescriptor(columns)).firstList();
        Assert.assertNotNull((String)"Null result from StoredProcedure.", rows);
        Assert.assertEquals((long)1L, (long)rows.size());
        DataRow artistRow = (DataRow)rows.get(0);
        Assert.assertEquals((long)3L, (long)artistRow.size());
        artistRow = this.uppercaseConverter(artistRow);
        Object id = artistRow.get("ARTIST_ID");
        Assert.assertNotNull(id);
        Assert.assertTrue((String)("Expected Long, got: " + id.getClass().getName()), (boolean)(id instanceof Long));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ProcedureResult<T> runProcedureSelect(ProcedureCall<T> q) {
        ExternalTransaction t = new ExternalTransaction(this.jdbcEventLogger);
        BaseTransaction.bindThreadTransaction(t);
        try {
            ProcedureResult<T> procedureResult = q.call(this.context);
            return procedureResult;
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
            t.commit();
        }
    }

    private void createArtist(double paintingPrice) {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("An Artist");
        Painting p = this.context.newObject(Painting.class);
        p.setPaintingTitle("A Painting");
        p.setEstimatedPrice(new BigDecimal("" + paintingPrice));
        a.addToPaintingArray(p);
        this.context.commitChanges();
    }

    private DataRow uppercaseConverter(DataRow row) {
        DataRow converted = new DataRow(row.size());
        for (Map.Entry entry : row.entrySet()) {
            converted.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
        }
        return converted;
    }
}

