/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectSelect_CacheKeyIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testNoCache() {
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class);
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNull((Object)md1.getCacheKey());
        QueryMetadata md2 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md2.getCacheStrategy()));
        Assert.assertNull((Object)md2.getCacheKey());
    }

    @Test
    public void testLocalCache() {
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).localCache();
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
    }

    @Test
    public void testUseLocalCache() {
        ObjectSelect<Artist> q1 = ObjectSelect.query(Artist.class).localCache();
        QueryMetadata md1 = q1.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
        Assert.assertNull((Object)md1.getCacheGroup());
        ObjectSelect<Artist> q2 = ObjectSelect.query(Artist.class);
        q2.useLocalCache("g1");
        QueryMetadata md2 = q2.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)md2.getCacheStrategy()));
        Assert.assertNotNull((Object)md2.getCacheKey());
        Assert.assertEquals((Object)"g1", (Object)md2.getCacheGroup());
    }

    @Test
    public void testSharedCache() {
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).sharedCache();
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
    }

    @Test
    public void testUseSharedCache() {
        ObjectSelect<Artist> q1 = ObjectSelect.query(Artist.class).sharedCache();
        QueryMetadata md1 = q1.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
        Assert.assertNull((Object)md1.getCacheGroup());
        ObjectSelect<Artist> q2 = ObjectSelect.query(Artist.class).sharedCache("g1");
        QueryMetadata md2 = q2.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md2.getCacheStrategy()));
        Assert.assertNotNull((Object)md2.getCacheKey());
        Assert.assertEquals((Object)"g1", (Object)md2.getCacheGroup());
    }

    @Test
    public void testNamedQuery() {
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).sharedCache();
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotEquals((Object)"XYZ", (Object)md1.getCacheKey());
    }

    @Test
    public void testUniqueKeyEntity() {
        ObjectSelect<Artist> q1 = ObjectSelect.query(Artist.class).localCache();
        ObjectSelect<Artist> q2 = ObjectSelect.query(Artist.class).localCache();
        ObjectSelect<Painting> q3 = ObjectSelect.query(Painting.class).localCache();
        Assert.assertNotNull((Object)q1.getMetaData(this.resolver).getCacheKey());
        Assert.assertEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q2.getMetaData(this.resolver).getCacheKey());
        Assert.assertNotEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q3.getMetaData(this.resolver).getCacheKey());
    }

    @Test
    public void testUniqueKeyQualifier() {
        ObjectSelect<Artist> q1 = ObjectSelect.query(Artist.class).localCache().where(ExpressionFactory.matchExp("a", (Object)"b"));
        ObjectSelect<Artist> q2 = ObjectSelect.query(Artist.class).localCache().where(ExpressionFactory.matchExp("a", (Object)"b"));
        ObjectSelect<Artist> q3 = ObjectSelect.query(Artist.class).localCache().where(ExpressionFactory.matchExp("a", (Object)"c"));
        Assert.assertNotNull((Object)q1.getMetaData(this.resolver).getCacheKey());
        Assert.assertEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q2.getMetaData(this.resolver).getCacheKey());
        Assert.assertNotEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q3.getMetaData(this.resolver).getCacheKey());
    }

    @Test
    public void testUniqueKeyFetchLimit() {
        ObjectSelect<Artist> q1 = ObjectSelect.query(Artist.class).localCache().limit(5);
        ObjectSelect<Artist> q2 = ObjectSelect.query(Artist.class).localCache().limit(5);
        ObjectSelect<Artist> q3 = ObjectSelect.query(Artist.class).localCache().limit(6);
        ObjectSelect<Artist> q4 = ObjectSelect.query(Artist.class).localCache();
        Assert.assertNotNull((Object)q1.getMetaData(this.resolver).getCacheKey());
        Assert.assertEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q2.getMetaData(this.resolver).getCacheKey());
        Assert.assertNotEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q3.getMetaData(this.resolver).getCacheKey());
        Assert.assertNotEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q4.getMetaData(this.resolver).getCacheKey());
    }

    @Test
    public void testUniqueKeyHaving() {
        ObjectSelect<Artist> q1 = ObjectSelect.query(Artist.class).localCache().having(ExpressionFactory.expFalse());
        ObjectSelect<Artist> q2 = ObjectSelect.query(Artist.class).localCache().having(ExpressionFactory.expFalse());
        ObjectSelect<Artist> q3 = ObjectSelect.query(Artist.class).localCache().having(ExpressionFactory.expTrue());
        ObjectSelect<Artist> q4 = ObjectSelect.query(Artist.class).localCache();
        Assert.assertNotNull((Object)q1.getMetaData(this.resolver).getCacheKey());
        Assert.assertEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q2.getMetaData(this.resolver).getCacheKey());
        Assert.assertNotEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q3.getMetaData(this.resolver).getCacheKey());
        Assert.assertNotEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q4.getMetaData(this.resolver).getCacheKey());
    }
}

