/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class ObjectIdQueryTest {
    @Test
    public void testConstructorObjectId() {
        ObjectId oid = ObjectId.of("MockDataObject", "a", "b");
        ObjectIdQuery query = new ObjectIdQuery(oid);
        Assert.assertSame((Object)oid, (Object)query.getObjectId());
    }

    @Test
    public void testSerializability() throws Exception {
        ObjectId oid = ObjectId.of("test", "a", "b");
        ObjectIdQuery query = new ObjectIdQuery(oid);
        ObjectIdQuery o = Util.cloneViaSerialization(query);
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof ObjectIdQuery));
        Assert.assertEquals((Object)oid, (Object)o.getObjectId());
    }

    @Test
    public void testEquals() throws Exception {
        ObjectIdQuery q1 = new ObjectIdQuery(ObjectId.of("abc", "a", 1));
        ObjectIdQuery q2 = new ObjectIdQuery(ObjectId.of("abc", "a", 1));
        ObjectIdQuery q3 = new ObjectIdQuery(ObjectId.of("abc", "a", 3));
        ObjectIdQuery q4 = new ObjectIdQuery(ObjectId.of("123", "a", 1));
        Assert.assertTrue((boolean)q1.equals(q2));
        Assert.assertEquals((long)q1.hashCode(), (long)q2.hashCode());
        Assert.assertFalse((boolean)q1.equals(q3));
        Assert.assertFalse((q1.hashCode() == q3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)q1.equals(q4));
        Assert.assertFalse((q1.hashCode() == q4.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testMetadata() {
        ObjectIdQuery q1 = new ObjectIdQuery(ObjectId.of("abc", "a", 1), true, 2);
        Assert.assertTrue((boolean)q1.isFetchAllowed());
        Assert.assertTrue((boolean)q1.isFetchMandatory());
        QueryMetadata md1 = q1.getMetaData(null);
        Assert.assertTrue((boolean)md1.isFetchingDataRows());
        ObjectIdQuery q2 = new ObjectIdQuery(ObjectId.of("abc", "a", 1), false, 1);
        Assert.assertTrue((boolean)q2.isFetchAllowed());
        Assert.assertFalse((boolean)q2.isFetchMandatory());
        QueryMetadata md2 = q2.getMetaData(null);
        Assert.assertFalse((boolean)md2.isFetchingDataRows());
        ObjectIdQuery q3 = new ObjectIdQuery(ObjectId.of("abc", "a", 1), false, 3);
        Assert.assertFalse((boolean)q3.isFetchAllowed());
        Assert.assertFalse((boolean)q3.isFetchMandatory());
        QueryMetadata md3 = q3.getMetaData(null);
        Assert.assertFalse((boolean)md3.isFetchingDataRows());
    }
}

