/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.FluentSelectPrefetchRouterAction;
import org.apache.cayenne.query.MockQueryRouter;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.testdo.inheritance_people.Department;
import org.apache.cayenne.testdo.inheritance_people.Employee;
import org.apache.cayenne.testdo.inheritance_people.Manager;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.junit.Assert;
import org.junit.Test;

public class FluentSelectPrefetchRouterActionQualifiedEntityIT
extends PeopleProjectCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testPrefetchEmployee() {
        ObjEntity departmentEntity = this.resolver.getObjEntity(Department.class);
        ObjectSelect<Employee> query = ObjectSelect.query(Employee.class, Employee.NAME.eq("abc")).prefetch(Employee.TO_DEPARTMENT.disjoint());
        FluentSelectPrefetchRouterAction action = new FluentSelectPrefetchRouterAction();
        MockQueryRouter router = new MockQueryRouter();
        action.route(query, router, this.resolver);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        PrefetchSelectQuery prefetch = (PrefetchSelectQuery)router.getQueries().get(0);
        Assert.assertEquals((Object)departmentEntity.getName(), (Object)prefetch.getEntityName());
        Assert.assertEquals((Object)ExpressionFactory.exp("db:employees.NAME = 'abc' and (db:employees.PERSON_TYPE = 'EE' or db:employees.PERSON_TYPE = 'EM')", new Object[0]), (Object)prefetch.getWhere());
    }

    @Test
    public void testPrefetchManager() {
        ObjEntity departmentEntity = this.resolver.getObjEntity(Department.class);
        ObjectSelect<Manager> query = ObjectSelect.query(Manager.class, Employee.NAME.eq("abc")).prefetch(Manager.TO_DEPARTMENT.disjoint());
        FluentSelectPrefetchRouterAction action = new FluentSelectPrefetchRouterAction();
        MockQueryRouter router = new MockQueryRouter();
        action.route(query, router, this.resolver);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        PrefetchSelectQuery prefetch = (PrefetchSelectQuery)router.getQueries().get(0);
        Assert.assertEquals((Object)departmentEntity.getName(), (Object)prefetch.getEntityName());
        Assert.assertEquals((Object)ExpressionFactory.exp("db:employees.NAME = 'abc' and db:employees.PERSON_TYPE = 'EM'", new Object[0]), (Object)prefetch.getWhere());
    }
}

