/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.Date;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CAY2541IT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis();
        for (int i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"});
        for (int i = 1; i <= 20; ++i) {
            tPaintings.insert(new Object[]{i, "painting" + i, i % 5 + 1, 1});
        }
    }

    @Test
    public void testCay2541() {
        ObjectId id = ObjectId.of("ARTIST", "ARTIST_ID", 1);
        ASTDbPath astDbPath = new ASTDbPath("ARTIST_ID");
        ASTScalar astScalar = new ASTScalar(id);
        ASTEqual astEqual = new ASTEqual();
        astEqual.setOperand(0, astDbPath);
        astEqual.setOperand(1, astScalar);
        List artistList = ObjectSelect.query(Artist.class).where(astEqual).select(this.context);
        Assert.assertEquals((long)1L, (long)artistList.size());
        Assert.assertEquals((Object)"artist1", (Object)((Artist)artistList.get(0)).getArtistName());
    }
}

