/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.DateProperty;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.MapProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SetProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class PropertyFactoryTest {
    @Test
    public void createBase() {
        BaseProperty<Integer> property = PropertyFactory.createBase("path", Integer.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Integer.class, property.getType());
    }

    @Test
    public void createBase1() {
        BaseProperty<Boolean> property = PropertyFactory.createBase("path", ExpressionFactory.exp("path = 1", new Object[0]), Boolean.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path = 1", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Boolean.class, property.getType());
    }

    @Test
    public void createBase2() {
        BaseProperty<Boolean> property = PropertyFactory.createBase(ExpressionFactory.exp("path = 1", new Object[0]), Boolean.class);
        Assert.assertNull((Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path = 1", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Boolean.class, property.getType());
    }

    @Test
    public void createString() {
        StringProperty<String> property = PropertyFactory.createString("path", String.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(String.class, property.getType());
    }

    @Test
    public void createString1() {
        StringProperty<String> property = PropertyFactory.createString(ExpressionFactory.exp("path", new Object[0]), String.class);
        Assert.assertNull((Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(String.class, property.getType());
    }

    @Test
    public void createString2() {
        StringProperty<StringBuilder> property = PropertyFactory.createString("path", ExpressionFactory.exp("concat(path, 'abc')", new Object[0]), StringBuilder.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("concat(path, 'abc')", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(StringBuilder.class, property.getType());
    }

    @Test
    public void createNumeric() {
        NumericProperty<Integer> property = PropertyFactory.createNumeric("path", Integer.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Integer.class, property.getType());
    }

    @Test
    public void createNumeric1() {
        NumericProperty<Integer> property = PropertyFactory.createNumeric(ExpressionFactory.exp("path + 1", new Object[0]), Integer.class);
        Assert.assertNull((Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path + 1", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Integer.class, property.getType());
    }

    @Test
    public void createNumeric2() {
        NumericProperty<Double> property = PropertyFactory.createNumeric("path", ExpressionFactory.exp("path / 2", new Object[0]), Double.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path / 2", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Double.class, property.getType());
    }

    @Test
    public void createDate() {
        DateProperty<LocalDate> property = PropertyFactory.createDate("path", LocalDate.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(LocalDate.class, property.getType());
    }

    @Test
    public void createDate1() {
        DateProperty<LocalDate> property = PropertyFactory.createDate(ExpressionFactory.exp("year(path)", new Object[0]), LocalDate.class);
        Assert.assertNull((Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("year(path)", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(LocalDate.class, property.getType());
    }

    @Test
    public void createDate2() {
        DateProperty<LocalDate> property = PropertyFactory.createDate("path", ExpressionFactory.exp("year(path)", new Object[0]), LocalDate.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("year(path)", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(LocalDate.class, property.getType());
    }

    @Test
    public void createEntity() {
        EntityProperty<Artist> property = PropertyFactory.createEntity("path", Artist.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Artist.class, property.getType());
    }

    @Test
    public void createEntity1() {
        EntityProperty<Artist> property = PropertyFactory.createEntity(ExpressionFactory.exp("path+.subpath", new Object[0]), Artist.class);
        Assert.assertNull((Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path+.subpath", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Artist.class, property.getType());
    }

    @Test
    public void createEntity2() {
        EntityProperty<Artist> property = PropertyFactory.createEntity("path", ExpressionFactory.exp("path+.subpath", new Object[0]), Artist.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path+.subpath", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Artist.class, property.getType());
    }

    @Test
    public void createSelf() {
        EntityProperty<Artist> property = PropertyFactory.createSelf(Artist.class);
        Assert.assertNull((Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.fullObjectExp(), (Object)property.getExpression());
        Assert.assertEquals(Artist.class, property.getType());
    }

    @Test
    public void createSelf1() {
        EntityProperty<Artist> property = PropertyFactory.createSelf(ExpressionFactory.exp("path", new Object[0]), Artist.class);
        Assert.assertNull((Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.fullObjectExp(ExpressionFactory.exp("path", new Object[0])), (Object)property.getExpression());
        Assert.assertEquals(Artist.class, property.getType());
    }

    @Test
    public void createList() {
        ListProperty<Artist> property = PropertyFactory.createList("path", Artist.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(List.class, property.getType());
        Assert.assertEquals(Artist.class, property.getEntityType());
    }

    @Test
    public void createList1() {
        ListProperty<Artist> property = PropertyFactory.createList("path", ExpressionFactory.exp("path+.sub", new Object[0]), Artist.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path+.sub", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(List.class, property.getType());
        Assert.assertEquals(Artist.class, property.getEntityType());
    }

    @Test
    public void createSet() {
        SetProperty<Artist> property = PropertyFactory.createSet("path", Artist.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Set.class, property.getType());
        Assert.assertEquals(Artist.class, property.getEntityType());
    }

    @Test
    public void createSet1() {
        SetProperty<Artist> property = PropertyFactory.createSet("path", ExpressionFactory.exp("path+.sub", new Object[0]), Artist.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path+.sub", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Set.class, property.getType());
        Assert.assertEquals(Artist.class, property.getEntityType());
    }

    @Test
    public void createMap() {
        MapProperty<Integer, Artist> property = PropertyFactory.createMap("path", Integer.class, Artist.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Map.class, property.getType());
        Assert.assertEquals(Integer.class, property.getKeyType());
        Assert.assertEquals(Artist.class, property.getEntityType());
    }

    @Test
    public void createMap1() {
        MapProperty<Integer, Artist> property = PropertyFactory.createMap("path", ExpressionFactory.exp("path+.sub", new Object[0]), Integer.class, Artist.class);
        Assert.assertEquals((Object)"path", (Object)property.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path+.sub", new Object[0]), (Object)property.getExpression());
        Assert.assertEquals(Map.class, property.getType());
        Assert.assertEquals(Integer.class, property.getKeyType());
        Assert.assertEquals(Artist.class, property.getEntityType());
    }
}

