/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.sql.Date;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PathAliasesIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis();
        for (int i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tGallery1 = new TableHelper(this.dbHelper, "GALLERY");
        tGallery1.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery1.insert(new Object[]{2, "test gallery"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"});
        for (int i = 1; i <= 20; ++i) {
            tPaintings.insert(new Object[]{i, "painting" + i, i % 2 == 0 ? 4 : i % 5 + 1, i % 2 == 0 ? 2 : 1});
        }
    }

    @Test
    public void testBeginAlias() {
        List artists = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.alias("p1").dot(Painting.PAINTING_TITLE).eq("painting2")).and(Artist.PAINTING_ARRAY.alias("p2").dot(Painting.PAINTING_TITLE).eq("painting4")).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"artist4", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testTheSameAliases() {
        List results = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.PAINTING_ARRAY.alias("p1").dot(Painting.PAINTING_TITLE), Artist.PAINTING_ARRAY.alias("p2").dot(Painting.PAINTING_TITLE)).where(Artist.PAINTING_ARRAY.alias("p1").dot(Painting.PAINTING_TITLE).eq("painting2")).and(Artist.PAINTING_ARRAY.alias("p2").dot(Painting.PAINTING_TITLE).eq("painting4")).select(this.context);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"artist4", (Object)((Object[])results.get(0))[0]);
        Assert.assertEquals((Object)"painting2", (Object)((Object[])results.get(0))[1]);
        Assert.assertEquals((Object)"painting4", (Object)((Object[])results.get(0))[2]);
    }

    @Test
    public void testMiddleAlias() {
        List artists = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY).dot(Gallery.PAINTING_ARRAY).alias("p1").dot(Painting.PAINTING_TITLE).eq("painting2")).and(Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY).dot(Gallery.PAINTING_ARRAY).alias("p2").dot(Painting.PAINTING_TITLE).eq("painting4")).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"artist4", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testEntityPropertyAliases() {
        Artist artist = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 1);
        List paintings = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.alias("p1").eq(artist)).select(this.context);
        Assert.assertEquals((long)2L, (long)paintings.size());
        Assert.assertEquals((Object)"artist1", (Object)((Painting)paintings.get(0)).getToArtist().getArtistName());
        Assert.assertEquals((Object)"artist1", (Object)((Painting)paintings.get(1)).getToArtist().getArtistName());
    }

    @Test
    public void testAliases() {
        List artists = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.alias("p1").dot(Painting.PAINTING_TITLE).eq("painting2")).and(Artist.PAINTING_ARRAY.alias("p2").dot(Painting.PAINTING_TITLE).eq("painting4")).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertNotNull(artists.get(0));
        Assert.assertEquals((Object)"artist4", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testAliasForPath() {
        ASTObjPath astPath = new ASTObjPath("paintingArray.a.galleryName");
        astPath.setPathAliases(Collections.singletonMap("a", "toGallery"));
        ASTEqual astEqual = new ASTEqual(astPath, "tate modern");
        List artists = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, PropertyFactory.createBase(astPath, String.class)).where(astEqual).orderBy(Artist.ARTIST_NAME.asc()).select(this.context);
        Assert.assertEquals((long)5L, (long)artists.size());
        Assert.assertEquals((Object)"artist1", (Object)((Object[])artists.get(0))[0]);
    }

    @Test
    public void testAggregationWithAliases() {
        List artistAndPaintingCount = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.PAINTING_ARRAY.count()).having(Artist.PAINTING_ARRAY.alias("p1").count().lt(5L)).select(this.context);
        Assert.assertEquals((long)4L, (long)artistAndPaintingCount.size());
        TestCase.assertTrue(((Long)((Object[])artistAndPaintingCount.get(0))[1] < 5L ? 1 : 0) != 0);
    }

    @Test
    public void testOrderWithAlias() {
        ObjectSelect<Painting> query = ObjectSelect.query(Painting.class).orderBy(Painting.TO_ARTIST.alias("p1").dot(Artist.ARTIST_NAME).asc()).prefetch(Painting.TO_ARTIST.disjoint());
        List paintings = query.select(this.context);
        Assert.assertEquals((long)20L, (long)paintings.size());
        Assert.assertEquals((Object)"artist1", (Object)((Painting)paintings.get(0)).getToArtist().getArtistName());
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testPrefetchWithAliases() {
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class);
        query.prefetch(Artist.PAINTING_ARRAY.alias("p1").disjoint());
        query.select(this.context);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testTheSameAliasesToDifferentProperties() {
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class);
        query.where(Artist.PAINTING_ARRAY.alias("p1").dot(Painting.PAINTING_TITLE).eq("p1"));
        query.and(Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY).alias("p1").dot(Gallery.GALLERY_NAME).eq("g1"));
        query.select(this.context);
    }

    @Test
    public void testExpWithAliases() {
        Expression e1 = ExpressionFactory.exp("paintingArray#p1.paintingTitle = 'painting2'", new Object[0]);
        Expression e2 = ExpressionFactory.exp("paintingArray#p2.paintingTitle = 'painting4'", new Object[0]);
        List artists = ObjectSelect.query(Artist.class).where(e1).and(e2).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"artist4", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testExpWithSeveralAliases() {
        Expression e1 = ExpressionFactory.exp("paintingArray#p1.toGallery#g1.galleryName = 'tate modern'", new Object[0]);
        List artists = ObjectSelect.query(Artist.class).where(e1).orderBy(Artist.ARTIST_NAME.asc()).select(this.context);
        Assert.assertEquals((long)5L, (long)artists.size());
        Assert.assertEquals((Object)"artist1", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testMiddleAliasForExp() {
        Expression e1 = ExpressionFactory.exp("paintingArray.toGallery.paintingArray#p1.paintingTitle = 'painting2'", new Object[0]);
        Expression e2 = ExpressionFactory.exp("paintingArray.toGallery.paintingArray#p2.paintingTitle = 'painting4'", new Object[0]);
        List artists = ObjectSelect.query(Artist.class).where(e1).and(e2).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"artist4", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testEntityPropertyAliasesInExp() {
        Painting painting2 = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 2);
        Painting painting4 = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 4);
        List artists = ObjectSelect.query(Artist.class).where(ExpressionFactory.exp("paintingArray#p1 = $painting1", painting2)).and(ExpressionFactory.exp("paintingArray#p2 = $painting2", painting4)).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"artist4", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testAliasForPathExp() {
        ASTObjPath astPath = new ASTObjPath("paintingArray.p1.galleryName");
        astPath.setPathAliases(Collections.singletonMap("a", "toGallery"));
        ASTEqual astEqual = new ASTEqual(astPath, "test gallery");
        Expression e1 = ExpressionFactory.exp("paintingArray.toGallery#p1.galleryName", new Object[0]);
        List artists = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, PropertyFactory.createBase(e1, String.class)).where(astEqual).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"artist4", (Object)((Object[])artists.get(0))[0]);
        Assert.assertEquals((Object)"test gallery", (Object)((Object[])artists.get(0))[1]);
    }

    @Test
    public void testTheSameAliasesForExp() {
        Expression e1 = ExpressionFactory.exp("paintingArray#p1.paintingTitle", new Object[0]);
        Expression e2 = ExpressionFactory.exp("paintingArray#p2.paintingTitle", new Object[0]);
        Expression e3 = ExpressionFactory.exp("paintingArray#p1.paintingTitle = 'painting2'", new Object[0]);
        Expression e4 = ExpressionFactory.exp("paintingArray#p2.paintingTitle = 'painting4'", new Object[0]);
        List results = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, PropertyFactory.createBase(e1, String.class), PropertyFactory.createBase(e2, String.class)).where(e3).and(e4).select(this.context);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"artist4", (Object)((Object[])results.get(0))[0]);
        Assert.assertEquals((Object)"painting2", (Object)((Object[])results.get(0))[1]);
        Assert.assertEquals((Object)"painting4", (Object)((Object[])results.get(0))[2]);
    }

    @Test
    public void testOrderWithAliasForExp() {
        Expression e1 = ExpressionFactory.exp("toArtist#p1.artistName", new Object[0]);
        ObjectSelect<Painting> query = ObjectSelect.query(Painting.class).orderBy(PropertyFactory.createBase(e1, String.class).asc()).prefetch(Painting.TO_ARTIST.disjoint());
        List paintings = query.select(this.context);
        Assert.assertEquals((long)20L, (long)paintings.size());
        Assert.assertEquals((Object)"artist1", (Object)((Painting)paintings.get(0)).getToArtist().getArtistName());
    }

    @Test
    public void testAggregationWithAliasesForExp() {
        Expression e1 = ExpressionFactory.exp("paintingArray#p1", new Object[0]);
        List artistAndPaintingCount = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.PAINTING_ARRAY.count()).having(PropertyFactory.createBase(e1, Number.class).count().lt(5L)).select(this.context);
        Assert.assertEquals((long)4L, (long)artistAndPaintingCount.size());
        TestCase.assertTrue(((Long)((Object[])artistAndPaintingCount.get(0))[1] < 5L ? 1 : 0) != 0);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testPrefetchWithAliasesForExp() {
        Expression e1 = ExpressionFactory.exp("paintingArray#p1", new Object[0]);
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class);
        query.prefetch(PropertyFactory.createList("p1", e1, Painting.class).disjoint());
        query.select(this.context);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testExpWithAliasNotToRelSegment() {
        Expression e1 = ExpressionFactory.exp("paintingArray.paintingTitle#p1 = 'painting2'", new Object[0]);
        ObjectSelect.query(Artist.class).where(e1).select(this.context);
    }
}

