/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.sql.Date;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class IdPropertyIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis();
        int artistCount = 4;
        for (int i = 1; i <= artistCount; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"});
        for (int i = 1; i <= 16; ++i) {
            tPaintings.insert(new Object[]{i, "painting" + i, i % artistCount + 1, 1});
        }
    }

    @Test
    public void filterDb() {
        List artists = ObjectSelect.query(Artist.class).where(Artist.ARTIST_ID_PK_PROPERTY.gt(2L)).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
    }

    @Test
    public void filterDbRelated() {
        List artists = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.dot(Painting.PAINTING_ID_PK_PROPERTY).gt(13)).select(this.context);
        Assert.assertEquals((long)3L, (long)artists.size());
    }

    @Test
    public void filterInMemory() {
        List artists = Artist.ARTIST_ID_PK_PROPERTY.gt(2L).filterObjects(ObjectSelect.query(Artist.class).select(this.context));
        Assert.assertEquals((long)2L, (long)artists.size());
    }

    @Test
    public void filterInMemoryRelated() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_ID_PK_PROPERTY).gt(13);
        List artists = exp.filterObjects(ObjectSelect.query(Artist.class).select(this.context));
        Assert.assertEquals((long)3L, (long)artists.size());
    }

    @Test
    public void orderingDb() {
        List paintings = ObjectSelect.query(Painting.class).orderBy(Painting.PAINTING_ID_PK_PROPERTY.desc()).select(this.context);
        Assert.assertEquals((long)16L, (long)paintings.size());
        Assert.assertEquals((long)16L, (long)Cayenne.longPKForObject((Persistent)paintings.get(0)));
        Assert.assertEquals((long)1L, (long)Cayenne.longPKForObject((Persistent)paintings.get(15)));
    }

    @Test
    public void orderingDbRelated() {
        List paintings = ObjectSelect.query(Painting.class).orderBy(Painting.TO_ARTIST.dot(Artist.ARTIST_ID_PK_PROPERTY).asc()).select(this.context);
        Assert.assertEquals((long)16L, (long)paintings.size());
        Assert.assertEquals((long)1L, (long)Cayenne.longPKForObject(((Painting)paintings.get(0)).getToArtist()));
        Assert.assertEquals((long)4L, (long)Cayenne.longPKForObject(((Painting)paintings.get(15)).getToArtist()));
    }

    @Test
    public void orderingInMemory() {
        List paintings = ObjectSelect.query(Painting.class).select(this.context);
        Painting.PAINTING_ID_PK_PROPERTY.desc().orderList(paintings);
        Assert.assertEquals((long)16L, (long)paintings.size());
        Assert.assertEquals((long)16L, (long)Cayenne.longPKForObject((Persistent)paintings.get(0)));
        Assert.assertEquals((long)1L, (long)Cayenne.longPKForObject((Persistent)paintings.get(15)));
    }

    @Test
    public void orderingInMemoryRelated() {
        List paintings = ObjectSelect.query(Painting.class).select(this.context);
        Painting.TO_ARTIST.dot(Artist.ARTIST_ID_PK_PROPERTY).asc().orderList(paintings);
        Assert.assertEquals((long)16L, (long)paintings.size());
        Assert.assertEquals((long)1L, (long)Cayenne.longPKForObject(((Painting)paintings.get(0)).getToArtist()));
        Assert.assertEquals((long)4L, (long)Cayenne.longPKForObject(((Painting)paintings.get(15)).getToArtist()));
    }

    @Test
    public void columnQuery() {
        List ids = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_ID_PK_PROPERTY).orderBy(Artist.ARTIST_ID_PK_PROPERTY.desc()).select(this.context);
        Assert.assertEquals((long)4L, (long)ids.size());
        Assert.assertEquals((Object)1L, ids.get(3));
        Assert.assertEquals((Object)2L, ids.get(2));
        Assert.assertEquals((Object)3L, ids.get(1));
        Assert.assertEquals((Object)4L, ids.get(0));
    }

    @Test
    public void columnQueryWithGroupBy() {
        List ids = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_ID_PK_PROPERTY, Artist.PAINTING_ARRAY.count()).orderBy(Artist.ARTIST_ID_PK_PROPERTY.asc()).select(this.context);
        Assert.assertEquals((long)4L, (long)ids.size());
        Assert.assertEquals((Object)1L, (Object)((Object[])ids.get(0))[0]);
        Assert.assertEquals((Object)2L, (Object)((Object[])ids.get(1))[0]);
        Assert.assertEquals((Object)3L, (Object)((Object[])ids.get(2))[0]);
        Assert.assertEquals((Object)4L, (Object)((Object[])ids.get(3))[0]);
    }

    @Test
    public void filterDirectAttributeExpression() {
        List artists = ObjectSelect.query(Artist.class).where(ExpressionFactory.matchDbIdExp("ARTIST_ID", 2)).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
    }

    @Test
    public void filterStringExpression() {
        List paintings = ObjectSelect.query(Painting.class).where(ExpressionFactory.exp("dbid:toArtist.ARTIST_ID in (1)", new Object[0])).select(this.context);
        Assert.assertEquals((long)4L, (long)paintings.size());
    }

    @Test
    public void filterByObjectId() {
        Artist artist = ObjectSelect.query(Artist.class).selectFirst(this.context);
        Assert.assertNotNull((Object)artist);
        List paintings = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.dot(Artist.ARTIST_ID_PK_PROPERTY).eq(artist.getObjectId())).select(this.context);
        Assert.assertEquals((long)4L, (long)paintings.size());
    }

    @Test
    public void testEvaluateObject() {
        Expression exp = Painting.TO_ARTIST.dot(Artist.ARTIST_ID_PK_PROPERTY).getExpression();
        Painting painting = ObjectSelect.query(Painting.class).selectFirst(this.context);
        Object result = exp.evaluate(painting);
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Long.class));
        Assert.assertEquals((Object)painting.getToArtist().getObjectId().getIdSnapshot().get("ARTIST_ID"), (Object)result);
    }

    @Test
    public void testEvaluateCollection() {
        Expression exp = Painting.TO_ARTIST.dot(Artist.ARTIST_ID_PK_PROPERTY).getExpression();
        List paintings = ObjectSelect.query(Painting.class).select(this.context);
        Object result = exp.evaluate(paintings);
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(List.class));
        List ids = (List)result;
        Assert.assertEquals((long)paintings.size(), (long)ids.size());
        for (int i = 0; i < paintings.size(); ++i) {
            Assert.assertEquals((Object)((Painting)paintings.get(i)).getToArtist().getObjectId().getIdSnapshot().get("ARTIST_ID"), ids.get(i));
        }
    }

    @Test
    public void testEvaluateEntity() {
        Expression exp = Painting.TO_ARTIST.dot(Artist.ARTIST_ID_PK_PROPERTY).getExpression();
        ObjEntity painting = this.context.getEntityResolver().getObjEntity(Painting.class);
        Object result = exp.evaluate(painting);
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(DbAttribute.class));
        DbAttribute pk = (DbAttribute)result;
        Assert.assertEquals((Object)"ARTIST_ID", (Object)pk.getName());
        Assert.assertTrue((boolean)pk.isPrimaryKey());
    }
}

