/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Arrays;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EntityPropertyTest {
    private EntityProperty<Artist> property;
    private EntityProperty<Artist> property1;

    @Before
    public void createProperty() {
        this.property = new EntityProperty<Artist>("path", null, Artist.class);
        this.property1 = new EntityProperty<Artist>("path.artist", null, Artist.class);
    }

    @Test
    public void alias() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        this.property = this.property.alias("alias");
        Assert.assertEquals((Object)"alias", (Object)this.property.getName());
        Assert.assertEquals((long)1L, (long)this.property.getExpression().getPathAliases().size());
        Assert.assertEquals((Object)"path.artist", (Object)this.property1.getName());
        this.property1 = this.property1.alias("a");
        Assert.assertEquals((Object)"path.a", (Object)this.property1.getName());
        Assert.assertEquals((long)1L, (long)this.property1.getExpression().getPathAliases().size());
        Assert.assertEquals((Object)"artist", (Object)this.property1.getExpression().getPathAliases().get("a"));
    }

    @Test
    public void outer() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path"), (Object)this.property.getExpression());
        this.property = this.property.outer();
        Assert.assertEquals((Object)"path+", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path+"), (Object)this.property.getExpression());
        this.property = this.property.outer();
        Assert.assertEquals((Object)"path+", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path+"), (Object)this.property.getExpression());
    }

    @Test
    public void dot() {
        BaseProperty<Object> other = this.property.dot("other");
        Assert.assertEquals((Object)"path.other", (Object)other.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path.other"), (Object)other.getExpression());
    }

    @Test
    public void eqId() {
        Expression exp = this.property.eqId(1);
        Assert.assertEquals((Object)ExpressionFactory.exp("path = 1", new Object[0]), (Object)exp);
    }

    @Test
    public void inIdCollection() {
        Expression exp = this.property.inId(Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)ExpressionFactory.exp("path in (1, 2, 3)", new Object[0]), (Object)exp);
    }

    @Test
    public void inIdVararg() {
        Expression exp = this.property.inId(1, 2, 3);
        Assert.assertEquals((Object)ExpressionFactory.exp("path in (1, 2, 3)", new Object[0]), (Object)exp);
    }

    @Test
    public void neqId() {
        Expression exp = this.property.neqId(1);
        Assert.assertEquals((Object)ExpressionFactory.exp("path <> 1", new Object[0]), (Object)exp);
    }

    @Test
    public void ninIdCollection() {
        Expression exp = this.property.ninId(Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)ExpressionFactory.exp("path not in (1, 2, 3)", new Object[0]), (Object)exp);
    }

    @Test
    public void ninIdVararg() {
        Expression exp = this.property.ninId(1, 2, 3);
        Assert.assertEquals((Object)ExpressionFactory.exp("path not in (1, 2, 3)", new Object[0]), (Object)exp);
    }
}

