/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.time.LocalDate;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.DateProperty;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatePropertyTest {
    private DateProperty<LocalDate> property;

    @Before
    public void createProperty() {
        this.property = new DateProperty<LocalDate>("path", null, LocalDate.class);
    }

    @Test
    public void year() {
        Expression exp = this.property.year().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.exp("year(path)", new Object[0]), (Object)exp);
    }

    @Test
    public void month() {
        Expression exp = this.property.month().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.exp("month(path)", new Object[0]), (Object)exp);
    }

    @Test
    public void dayOfMonth() {
        Expression exp = this.property.dayOfMonth().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.exp("dayOfMonth(path)", new Object[0]), (Object)exp);
    }

    @Test
    public void hour() {
        Expression exp = this.property.hour().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.exp("hour(path)", new Object[0]), (Object)exp);
    }

    @Test
    public void minute() {
        Expression exp = this.property.minute().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.exp("minute(path)", new Object[0]), (Object)exp);
    }

    @Test
    public void second() {
        Expression exp = this.property.second().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.exp("second(path)", new Object[0]), (Object)exp);
    }

    @Test
    public void max() {
        Expression exp = this.property.max().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.exp("max(path)", new Object[0]), (Object)exp);
    }

    @Test
    public void min() {
        Expression exp = this.property.min().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.exp("min(path)", new Object[0]), (Object)exp);
    }

    @Test
    public void alias() {
        BaseProperty aliased = this.property.alias("test");
        Assert.assertEquals((Object)"test", (Object)aliased.getAlias());
        Assert.assertEquals((Object)"test", (Object)aliased.getName());
        Assert.assertEquals((Object)ExpressionFactory.exp("path", new Object[0]), (Object)aliased.getExpression());
    }
}

