/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ExpressionCollectionEvaluationIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        tArtist.insert(new Object[]{1, "artist1", new Date(System.currentTimeMillis())});
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID", "ESTIMATED_PRICE"});
        for (int i = 1; i <= 3; ++i) {
            tPaintings.insert(new Object[]{i, i + "painting" + Math.pow(10.0, i), 1, 1, i * 100});
        }
        tPaintings.insert(new Object[]{4, "4painting", null, 1, 10000});
    }

    @Test
    public void testSubstringWithCollection() {
        this.testExpression("substring(paintingArray.paintingTitle, 1, 1)", String.class);
    }

    @Test
    public void testTrimWithCollection() {
        this.testExpression("trim(paintingArray.paintingTitle)", String.class);
    }

    @Test
    public void testUpperWithCollection() {
        this.testExpression("upper(paintingArray.paintingTitle)", String.class);
    }

    @Test
    public void testLowerWithCollection() {
        this.testExpression("lower(paintingArray.paintingTitle)", String.class);
    }

    @Test
    public void testLengthWithCollection() {
        this.testExpression("length(paintingArray.paintingTitle)", Integer.class);
    }

    @Test
    public void testConcatWithCollection() {
        this.testExpression("concat(paintingArray.paintingTitle, ' ', 'xyz')", String.class);
    }

    @Test
    public void testMathWithCollection() {
        this.testExpression("paintingArray.estimatedPrice + 2", BigDecimal.class);
    }

    private <T extends Comparable<T>> void testExpression(String expStr, Class<T> tClass) {
        Expression exp = ExpressionFactory.exp(expStr, new Object[0]);
        Object res = exp.evaluate(ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjoint()).selectOne(this.context));
        List sqlResult = ObjectSelect.query(Artist.class).column(PropertyFactory.createBase(exp, tClass)).orderBy("db:paintingArray.PAINTING_ID").select(this.context);
        Collections.sort((List)res);
        Collections.sort(sqlResult);
        Assert.assertEquals((long)3L, (long)sqlResult.size());
        Assert.assertEquals((Object)res, sqlResult);
    }
}

