/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.table_primitives.TablePrimitives;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Test;

@UseServerRuntime(value="cayenne-table-primitives.xml")
public class ASTFunctionCallMathIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    private TablePrimitives createPrimitives(int value) {
        TablePrimitives primitives = this.context.newObject(TablePrimitives.class);
        primitives.setIntColumn(value);
        this.context.commitChanges();
        return primitives;
    }

    @Test
    public void testASTAbs() throws Exception {
        TablePrimitives p1 = this.createPrimitives(-10);
        TablePrimitives p2 = (TablePrimitives)ObjectSelect.query(TablePrimitives.class).where(TablePrimitives.INT_COLUMN.abs().eq(10)).selectOne(this.context);
        TestCase.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void testASTSqrt() throws Exception {
        TablePrimitives p1 = this.createPrimitives(9);
        TablePrimitives p2 = (TablePrimitives)ObjectSelect.query(TablePrimitives.class).where(TablePrimitives.INT_COLUMN.sqrt().eq(3)).selectOne(this.context);
        TestCase.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void testASTMod() throws Exception {
        TablePrimitives p1 = this.createPrimitives(10);
        TablePrimitives p2 = (TablePrimitives)ObjectSelect.query(TablePrimitives.class).where(TablePrimitives.INT_COLUMN.mod(3).eq(1)).selectOne(this.context);
        TestCase.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void testASTAbsParse() {
        Expression exp = ExpressionFactory.exp("abs(-3)", new Object[0]);
        TestCase.assertEquals((Object)3.0, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTSqrtParse() {
        Expression exp = ExpressionFactory.exp("sqrt(16)", new Object[0]);
        TestCase.assertEquals((Object)4.0, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTModParse() {
        Expression exp = ExpressionFactory.exp("mod(11,2)", new Object[0]);
        TestCase.assertEquals((Object)1.0, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testComplexParse() {
        Expression exp = ExpressionFactory.exp("10 - mod(sqrt(abs(-9)), 2)", new Object[0]);
        TestCase.assertEquals((Object)BigDecimal.valueOf(9L), (Object)exp.evaluate(new Object()));
    }
}

