/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTDbIdPath;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.Node;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ASTDbIdPathTest {
    @Test
    public void testShallowCopy() {
        ASTDbIdPath path = new ASTDbIdPath("test");
        Expression exp = path.shallowCopy();
        Assert.assertEquals((long)exp.getType(), (long)52L);
        Assert.assertThat((Object)exp, (Matcher)CoreMatchers.instanceOf(ASTDbIdPath.class));
        ASTDbIdPath clone = (ASTDbIdPath)exp;
        Assert.assertEquals((Object)"test", (Object)clone.getPath());
    }

    @Test
    public void testAppendAsString() throws IOException {
        ASTDbIdPath path = new ASTDbIdPath("test");
        StringBuilder sb = new StringBuilder();
        path.appendAsString(sb);
        Assert.assertEquals((Object)"dbid:test", (Object)sb.toString());
    }

    @Test
    public void testSimpleParse() {
        Expression exp = ExpressionFactory.exp("dbid:test", new Object[0]);
        Assert.assertThat((Object)exp, (Matcher)CoreMatchers.instanceOf(ASTDbIdPath.class));
        ASTDbIdPath path = (ASTDbIdPath)exp;
        Assert.assertEquals((Object)"test", (Object)path.getPath());
    }

    @Test
    public void testExpParse() {
        Expression exp = ExpressionFactory.exp("dbid:test = 1", new Object[0]);
        Assert.assertThat((Object)exp, (Matcher)CoreMatchers.instanceOf(ASTEqual.class));
        ASTEqual equal = (ASTEqual)exp;
        Node child0 = equal.jjtGetChild(0);
        Assert.assertThat((Object)child0, (Matcher)CoreMatchers.instanceOf(ASTDbIdPath.class));
        ASTDbIdPath path = (ASTDbIdPath)child0;
        Assert.assertEquals((Object)"test", (Object)path.getPath());
    }
}

