/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.cayenne.MockSerializable;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-empty.xml")
public class TypesMappingIT
extends ServerCase {
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;

    @Test
    public void testGetSqlTypeByJava() throws Exception {
        Assert.assertEquals((long)12L, (long)TypesMapping.getSqlTypeByJava(String.class));
        Assert.assertEquals((long)-2L, (long)TypesMapping.getSqlTypeByJava(byte[].class));
        Assert.assertEquals((long)93L, (long)TypesMapping.getSqlTypeByJava(Calendar.class));
        Assert.assertEquals((long)93L, (long)TypesMapping.getSqlTypeByJava(GregorianCalendar.class));
        Assert.assertEquals((long)-5L, (long)TypesMapping.getSqlTypeByJava(BigInteger.class));
        Assert.assertEquals((long)-3L, (long)TypesMapping.getSqlTypeByJava(MockSerializable.class));
        Assert.assertEquals((long)12L, (long)TypesMapping.getSqlTypeByJava(char[].class));
        Assert.assertEquals((long)12L, (long)TypesMapping.getSqlTypeByJava(Character[].class));
        Assert.assertEquals((long)-3L, (long)TypesMapping.getSqlTypeByJava(Byte[].class));
    }

    @Test
    public void testGetSqlTypeByJavaString() throws Exception {
        Assert.assertEquals((long)12L, (long)TypesMapping.getSqlTypeByJava(String.class.getName()));
        Assert.assertEquals((long)-2L, (long)TypesMapping.getSqlTypeByJava("byte[]"));
        Assert.assertEquals((long)93L, (long)TypesMapping.getSqlTypeByJava(Calendar.class.getName()));
        Assert.assertEquals((long)93L, (long)TypesMapping.getSqlTypeByJava(GregorianCalendar.class.getName()));
        Assert.assertEquals((long)-5L, (long)TypesMapping.getSqlTypeByJava(BigInteger.class.getName()));
        Assert.assertEquals((long)-3L, (long)TypesMapping.getSqlTypeByJava(MockSerializable.class.getName()));
        Assert.assertEquals((long)12L, (long)TypesMapping.getSqlTypeByJava("char[]"));
        Assert.assertEquals((long)12L, (long)TypesMapping.getSqlTypeByJava("java.lang.Character[]"));
        Assert.assertEquals((long)-3L, (long)TypesMapping.getSqlTypeByJava("java.lang.Byte[]"));
    }

    @Test
    public void testGetSqlTypeByJavaPrimitive() throws Exception {
        Assert.assertEquals((long)4L, (long)TypesMapping.getSqlTypeByJava(Integer.TYPE));
        Assert.assertEquals((long)-5L, (long)TypesMapping.getSqlTypeByJava(Long.TYPE));
    }

    @Test
    public void testDecimalType() {
        DbAttribute attribute = new DbAttribute("test");
        attribute.setType(3);
        attribute.setScale(0);
        attribute.setMaxLength(38);
        Assert.assertEquals((Object)BigInteger.class.getName(), (Object)TypesMapping.getJavaBySqlType(attribute));
        attribute.setScale(0);
        attribute.setMaxLength(5);
        Assert.assertEquals((Object)Integer.class.getName(), (Object)TypesMapping.getJavaBySqlType(attribute));
        attribute.setScale(0);
        attribute.setMaxLength(10);
        Assert.assertEquals((Object)Long.class.getName(), (Object)TypesMapping.getJavaBySqlType(attribute));
        attribute.setScale(1);
        attribute.setMaxLength(5);
        Assert.assertEquals((Object)BigDecimal.class.getName(), (Object)TypesMapping.getJavaBySqlType(attribute));
        attribute.setScale(5);
        attribute.setMaxLength(38);
        Assert.assertEquals((Object)BigDecimal.class.getName(), (Object)TypesMapping.getJavaBySqlType(attribute));
    }

    @Test
    public void testTypeInfoCompleteness() throws Exception {
        int len = 0;
        try (Connection conn = this.dataSourceFactory.getSharedDataSource().getConnection();){
            DatabaseMetaData md = conn.getMetaData();
            try (ResultSet rs = md.getTypeInfo();){
                while (rs.next()) {
                    ++len;
                }
            }
        }
        int actualLen = 0;
        TypesMapping map = this.createTypesMapping();
        for (List<TypesMapping.TypeInfo> entry : map.databaseTypes.values()) {
            actualLen += entry.size();
        }
        Assert.assertTrue((len <= actualLen ? 1 : 0) != 0);
    }

    private TypesMapping createTypesMapping() throws Exception {
        try (Connection conn = this.dataSourceFactory.getSharedDataSource().getConnection();){
            DatabaseMetaData md = conn.getMetaData();
            TypesMapping typesMapping = new TypesMapping(md);
            return typesMapping;
        }
    }
}

