/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.qualified.Qualified1;
import org.apache.cayenne.unit.DerbyUnitDbAdapter;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-qualified.xml")
public class ConcurrentPkGeneratorIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Before
    public void prepareDerbyDb() {
        if (this.unitDbAdapter instanceof DerbyUnitDbAdapter) {
            try (Connection connection = this.runtime.getDataDomain().getDataNode("qualified").getDataSource().getConnection();){
                CallableStatement cs = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
                cs.setString(1, "derby.language.sequence.preallocator");
                cs.setString(2, "1000");
                cs.execute();
                cs.close();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Test
    public void testConcurrentInserts() {
        if (!this.unitDbAdapter.supportsPKGeneratorConcurrency()) {
            return;
        }
        DataMap dataMap = this.runtime.getDataDomain().getDataMap("qualified");
        ObjectContext context = this.runtime.newContext();
        List<Qualified1> qualified1s = context.select(ObjectSelect.query(Qualified1.class));
        context.deleteObjects((Collection<?>)qualified1s);
        context.commitChanges();
        int numThreads = 2;
        int insertsPerThread = 100;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        Runnable task = () -> {
            try {
                ObjectContext context1 = this.runtime.newContext();
                for (ObjEntity entity : dataMap.getObjEntities()) {
                    context1.newObject(entity.getJavaClass());
                }
                context1.commitChanges();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        for (int j = 0; j < insertsPerThread; ++j) {
            for (int i = 0; i < numThreads; ++i) {
                executor.submit(task);
            }
        }
        executor.shutdown();
        try {
            boolean didFinish = executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!didFinish) {
                Assert.fail((String)"Concurrent inserts either deadlocked or contended over the lock too long.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        qualified1s = context.select(ObjectSelect.query(Qualified1.class));
        Assert.assertEquals((long)(insertsPerThread * numThreads), (long)qualified1s.size());
    }
}

