/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.log.NoopJdbcEventLogger;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class AutoAdapterIT
extends ServerCase {
    @Inject
    private DataNode dataNode;

    @Test
    public void testGetAdapter_Proxy() {
        AutoAdapter adapter = new AutoAdapter((Provider<DbAdapter>)((Provider)() -> this.dataNode.getAdapter()), NoopJdbcEventLogger.getInstance());
        DbAdapter detected = adapter.getAdapter();
        Assert.assertSame((Object)this.dataNode.getAdapter(), (Object)detected);
    }

    @Test
    public void testCreateSQLTemplateAction() {
        AutoAdapter autoAdapter = new AutoAdapter((Provider<DbAdapter>)((Provider)() -> this.dataNode.getAdapter()), NoopJdbcEventLogger.getInstance());
        SQLTemplateAction action = (SQLTemplateAction)autoAdapter.getAction(new SQLTemplate(Artist.class, "select * from artist"), this.dataNode);
        Assert.assertNotNull((Object)action.getAdapter());
        Assert.assertFalse((boolean)(action.getAdapter() instanceof AutoAdapter));
        Assert.assertSame((Object)this.dataNode.getAdapter(), (Object)action.getAdapter());
    }

    @Test
    public void testCorrectProxyMethods() {
        DbAdapter adapter = this.dataNode.getAdapter();
        AutoAdapter autoAdapter = new AutoAdapter((Provider<DbAdapter>)((Provider)() -> adapter), NoopJdbcEventLogger.getInstance());
        ObjectSelect<Artist> select = ObjectSelect.query(Artist.class);
        Assert.assertEquals((Object)adapter.supportsBatchUpdates(), (Object)autoAdapter.supportsBatchUpdates());
        Assert.assertEquals((Object)adapter.supportsGeneratedKeys(), (Object)autoAdapter.supportsGeneratedKeys());
        Assert.assertEquals((Object)adapter.supportsGeneratedKeysForBatchInserts(), (Object)autoAdapter.supportsGeneratedKeysForBatchInserts());
        Assert.assertSame((Object)adapter.getBatchTerminator(), (Object)autoAdapter.getBatchTerminator());
        Assert.assertSame((Object)adapter.getPkGenerator(), (Object)autoAdapter.getPkGenerator());
        Assert.assertSame((Object)adapter.getQuotingStrategy(), (Object)autoAdapter.getQuotingStrategy());
        Assert.assertSame(adapter.getSqlTreeProcessor().getClass(), autoAdapter.getSqlTreeProcessor().getClass());
        Assert.assertSame((Object)adapter.getExtendedTypes(), (Object)autoAdapter.getExtendedTypes());
        Assert.assertSame((Object)adapter.getEjbqlTranslatorFactory(), (Object)autoAdapter.getEjbqlTranslatorFactory());
        Assert.assertSame(adapter.getSelectTranslator(select, this.dataNode.getEntityResolver()).getClass(), autoAdapter.getSelectTranslator(select, this.dataNode.getEntityResolver()).getClass());
        Assert.assertEquals((Object)adapter.supportsCatalogsOnReverseEngineering(), (Object)autoAdapter.supportsCatalogsOnReverseEngineering());
        Assert.assertSame(adapter.getSystemCatalogs(), autoAdapter.getSystemCatalogs());
        Assert.assertSame(adapter.getSystemSchemas(), autoAdapter.getSystemSchemas());
        Assert.assertSame((Object)adapter.tableTypeForTable(), (Object)autoAdapter.tableTypeForTable());
        Assert.assertSame((Object)adapter.tableTypeForView(), (Object)autoAdapter.tableTypeForView());
        Assert.assertEquals((Object)adapter.supportsUniqueConstraints(), (Object)autoAdapter.supportsUniqueConstraints());
    }
}

