/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;

public class ValueObjectTypeFactory
implements ExtendedTypeFactory {
    ValueObjectTypeRegistry valueObjectTypeRegistry;
    private ExtendedTypeMap map;

    public ValueObjectTypeFactory(ExtendedTypeMap map, ValueObjectTypeRegistry valueObjectTypeRegistry) {
        this.map = map;
        this.valueObjectTypeRegistry = valueObjectTypeRegistry;
    }

    @Override
    public ExtendedType<? extends ValueObjectType> getType(Class<?> objectClass) {
        ValueObjectType<?, ?> valueObjectType = this.valueObjectTypeRegistry.getValueType(objectClass);
        if (valueObjectType == null) {
            return null;
        }
        ExtendedType decorator = this.map.getExplictlyRegisteredType(valueObjectType.getTargetType().getCanonicalName());
        return new ExtendedTypeConverter(decorator, valueObjectType);
    }

    static class ExtendedTypeConverter<T, E>
    implements ExtendedType<T> {
        ExtendedType<E> extendedType;
        ValueObjectType<T, E> valueObjectType;

        ExtendedTypeConverter(ExtendedType<E> extendedType, ValueObjectType<T, E> valueObjectType) {
            this.extendedType = Objects.requireNonNull(extendedType);
            this.valueObjectType = Objects.requireNonNull(valueObjectType);
        }

        @Override
        public String getClassName() {
            return this.valueObjectType.getValueType().getName();
        }

        protected T toJavaObject(E materializedValue) {
            if (materializedValue == null) {
                return null;
            }
            return this.valueObjectType.toJavaObject(materializedValue);
        }

        @Override
        public T materializeObject(CallableStatement rs, int index, int type) throws Exception {
            return this.toJavaObject(this.extendedType.materializeObject(rs, index, type));
        }

        @Override
        public T materializeObject(ResultSet rs, int index, int type) throws Exception {
            return this.toJavaObject(this.extendedType.materializeObject(rs, index, type));
        }

        @Override
        public void setJdbcObject(PreparedStatement statement, T value, int pos, int type, int precision) throws Exception {
            Object dbValue = value == null ? null : (Object)this.valueObjectType.fromJavaObject(value);
            this.extendedType.setJdbcObject(statement, dbValue, pos, type, precision);
        }

        @Override
        public String toString(T value) {
            if (value == null) {
                return "NULL";
            }
            return this.valueObjectType.toCacheKey(value);
        }
    }
}

