/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.temporal.ChronoField;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.testdo.java8.DurationTestEntity;
import org.apache.cayenne.testdo.java8.LocalDateTestEntity;
import org.apache.cayenne.testdo.java8.LocalDateTimeTestEntity;
import org.apache.cayenne.testdo.java8.LocalTimeTestEntity;
import org.apache.cayenne.testdo.java8.PeriodTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-java8.xml")
public class Java8TimeIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void before() throws SQLException {
        this.dbHelper.deleteAll("LOCAL_DATE_TEST");
        this.dbHelper.deleteAll("LOCAL_DATETIME_TEST");
        this.dbHelper.deleteAll("LOCAL_TIME_TEST");
        this.dbHelper.deleteAll("DURATION_TEST");
        this.dbHelper.deleteAll("PERIOD_TEST");
    }

    @Test
    public void testJava8LocalDate_Null() {
        LocalDateTestEntity localDateTestEntity = this.context.newObject(LocalDateTestEntity.class);
        localDateTestEntity.setDate(null);
        this.context.commitChanges();
        LocalDateTestEntity testRead = (LocalDateTestEntity)ObjectSelect.query(LocalDateTestEntity.class).selectOne(this.context);
        Assert.assertNull((Object)testRead.getDate());
    }

    @Test
    public void testJava8LocalDate() {
        LocalDateTestEntity localDateTestEntity = this.context.newObject(LocalDateTestEntity.class);
        LocalDate localDate = LocalDate.now();
        localDateTestEntity.setDate(localDate);
        this.context.commitChanges();
        LocalDateTestEntity testRead = (LocalDateTestEntity)ObjectSelect.query(LocalDateTestEntity.class).selectOne(this.context);
        Assert.assertNotNull((Object)testRead.getDate());
        Assert.assertEquals(LocalDate.class, testRead.getDate().getClass());
        Assert.assertEquals((Object)localDate, (Object)testRead.getDate());
    }

    @Test
    public void testJava8LocalTime() {
        LocalTimeTestEntity localTimeTestEntity = this.context.newObject(LocalTimeTestEntity.class);
        LocalTime localTime = LocalTime.now();
        localTimeTestEntity.setTime(localTime);
        this.context.commitChanges();
        LocalTimeTestEntity testRead = (LocalTimeTestEntity)ObjectSelect.query(LocalTimeTestEntity.class).selectOne(this.context);
        Assert.assertNotNull((Object)testRead.getTime());
        Assert.assertEquals(LocalTime.class, testRead.getTime().getClass());
        Assert.assertEquals((long)localTime.toSecondOfDay(), (long)testRead.getTime().toSecondOfDay());
    }

    @Test
    public void testJava8LocalDateTime() {
        LocalDateTimeTestEntity localDateTimeTestEntity = this.context.newObject(LocalDateTimeTestEntity.class);
        LocalDateTime localDateTime = LocalDateTime.now().with(ChronoField.NANO_OF_SECOND, 0L);
        localDateTimeTestEntity.setTimestamp(localDateTime);
        this.context.commitChanges();
        LocalDateTimeTestEntity testRead = (LocalDateTimeTestEntity)ObjectSelect.query(LocalDateTimeTestEntity.class).selectOne(this.context);
        Assert.assertNotNull((Object)testRead.getTimestamp());
        Assert.assertEquals(LocalDateTime.class, testRead.getTimestamp().getClass());
        Assert.assertEquals((Object)localDateTime, (Object)testRead.getTimestamp());
    }

    @Test
    public void columnSelectWithJava8Type() {
        LocalDateTime localDateTime = LocalDateTime.now().with(ChronoField.NANO_OF_SECOND, 0L);
        LocalDateTimeTestEntity localDateTimeTestEntity = this.context.newObject(LocalDateTimeTestEntity.class);
        localDateTimeTestEntity.setTimestamp(localDateTime);
        this.context.commitChanges();
        LocalDateTime value = (LocalDateTime)ObjectSelect.query(LocalDateTimeTestEntity.class).column(LocalDateTimeTestEntity.TIMESTAMP).selectOne(this.context);
        Assert.assertEquals((Object)localDateTime, (Object)value);
        LocalDateTime value2 = (LocalDateTime)ObjectSelect.query(LocalDateTimeTestEntity.class).min(LocalDateTimeTestEntity.TIMESTAMP).selectOne(this.context);
        Assert.assertEquals((Object)localDateTime, (Object)value2);
    }

    @Test
    public void testJava8Duration() {
        DurationTestEntity durationTestEntity = this.context.newObject(DurationTestEntity.class);
        Duration duration = Duration.ofDays(10L);
        durationTestEntity.setDurationBigInt(duration);
        durationTestEntity.setDurationDecimal(duration);
        durationTestEntity.setDurationInt(duration);
        durationTestEntity.setDurationLongVarchar(duration);
        durationTestEntity.setDurationNumeric(duration);
        durationTestEntity.setDurationVarchar(duration);
        this.context.commitChanges();
        DurationTestEntity testRead = (DurationTestEntity)ObjectSelect.query(DurationTestEntity.class).selectOne(this.context);
        Assert.assertNotNull((Object)testRead.getDurationBigInt());
        Assert.assertEquals(Duration.class, testRead.getDurationBigInt().getClass());
        Assert.assertEquals((Object)duration, (Object)testRead.getDurationBigInt());
        Assert.assertNotNull((Object)testRead.getDurationDecimal());
        Assert.assertEquals(Duration.class, testRead.getDurationDecimal().getClass());
        Assert.assertEquals((Object)duration, (Object)testRead.getDurationDecimal());
        Assert.assertNotNull((Object)testRead.getDurationInt());
        Assert.assertEquals(Duration.class, testRead.getDurationInt().getClass());
        Assert.assertEquals((Object)duration, (Object)testRead.getDurationInt());
        Assert.assertNotNull((Object)testRead.getDurationLongVarchar());
        Assert.assertEquals(Duration.class, testRead.getDurationLongVarchar().getClass());
        Assert.assertEquals((Object)duration, (Object)testRead.getDurationLongVarchar());
        Assert.assertNotNull((Object)testRead.getDurationNumeric());
        Assert.assertEquals(Duration.class, testRead.getDurationNumeric().getClass());
        Assert.assertEquals((Object)duration, (Object)testRead.getDurationNumeric());
        Assert.assertNotNull((Object)testRead.getDurationVarchar());
        Assert.assertEquals(Duration.class, testRead.getDurationVarchar().getClass());
        Assert.assertEquals((Object)duration, (Object)testRead.getDurationVarchar());
    }

    @Test
    public void testJava8Period() {
        PeriodTestEntity periodTestEntity = this.context.newObject(PeriodTestEntity.class);
        Period period = Period.of(100, 10, 5);
        periodTestEntity.setPeriodField(period);
        this.context.commitChanges();
        PeriodTestEntity testRead = (PeriodTestEntity)ObjectSelect.query(PeriodTestEntity.class).selectOne(this.context);
        Assert.assertNotNull((Object)testRead.getPeriodField());
        Assert.assertEquals(Period.class, testRead.getPeriodField().getClass());
        Assert.assertEquals((Object)period, (Object)testRead.getPeriodField());
    }
}

