/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.EmptyNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.GroupByNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.GroupByStage;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByStageTest {
    private TranslatorContext context;

    @Before
    public void prepareContext() {
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().build();
        this.context = new MockTranslatorContext(wrapper);
    }

    @Test
    public void emptyContext() {
        GroupByStage stage = new GroupByStage();
        stage.perform(this.context);
        Node node = this.context.getSelectBuilder().build();
        Assert.assertEquals((long)0L, (long)node.getChildrenCount());
    }

    @Test
    public void noAggregates() {
        this.context.addResultNode(new ColumnNode("t0", "column", null, null));
        GroupByStage stage = new GroupByStage();
        stage.perform(this.context);
        Node node = this.context.getSelectBuilder().build();
        Assert.assertEquals((long)0L, (long)node.getChildrenCount());
    }

    @Test
    public void groupByWithAggregates() {
        this.context.addResultNode(new ColumnNode("t0", "column", null, null));
        this.context.addResultNode(new EmptyNode(), true, PropertyFactory.COUNT, "count");
        GroupByStage stage = new GroupByStage();
        stage.perform(this.context);
        Node node = this.context.getSelectBuilder().build();
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        Assert.assertThat((Object)node.getChild(0), (Matcher)CoreMatchers.instanceOf(GroupByNode.class));
        Assert.assertEquals((long)1L, (long)node.getChild(0).getChildrenCount());
        Assert.assertThat((Object)node.getChild(0).getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        ColumnNode columnNode = (ColumnNode)node.getChild(0).getChild(0);
        Assert.assertEquals((Object)"t0", (Object)columnNode.getTable());
        Assert.assertEquals((Object)"column", (Object)columnNode.getColumn());
    }
}

