/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.translator.select.DistinctStage;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.map.DbAttribute;
import org.junit.Assert;
import org.junit.Test;

public class DistinctStageTest {
    @Test
    public void isUnsupportedForDistinct() {
        Assert.assertTrue((boolean)DistinctStage.isUnsupportedForDistinct(2004));
        Assert.assertTrue((boolean)DistinctStage.isUnsupportedForDistinct(2005));
        Assert.assertTrue((boolean)DistinctStage.isUnsupportedForDistinct(2011));
        Assert.assertTrue((boolean)DistinctStage.isUnsupportedForDistinct(-1));
        Assert.assertTrue((boolean)DistinctStage.isUnsupportedForDistinct(-16));
        Assert.assertTrue((boolean)DistinctStage.isUnsupportedForDistinct(-4));
        Assert.assertFalse((boolean)DistinctStage.isUnsupportedForDistinct(4));
        Assert.assertFalse((boolean)DistinctStage.isUnsupportedForDistinct(91));
        Assert.assertFalse((boolean)DistinctStage.isUnsupportedForDistinct(1));
        Assert.assertFalse((boolean)DistinctStage.isUnsupportedForDistinct(3));
        Assert.assertFalse((boolean)DistinctStage.isUnsupportedForDistinct(6));
        Assert.assertFalse((boolean)DistinctStage.isUnsupportedForDistinct(12));
    }

    @Test
    public void noSuppression() {
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withDistinct(true).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        Assert.assertFalse((boolean)context.isDistinctSuppression());
        DistinctStage stage = new DistinctStage();
        stage.perform(context);
        Assert.assertFalse((boolean)context.isDistinctSuppression());
    }

    @Test
    public void explicitSuppression() {
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withDistinct(true).withMetaData(new MockQueryMetadataBuilder().withSuppressDistinct().build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        Assert.assertFalse((boolean)context.isDistinctSuppression());
        DistinctStage stage = new DistinctStage();
        stage.perform(context);
        Assert.assertTrue((boolean)context.isDistinctSuppression());
    }

    @Test
    public void suppressionByType() {
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withDistinct(true).withMetaData(new MockQueryMetadataBuilder().build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        DbAttribute attribute = new DbAttribute();
        attribute.setType(-4);
        ColumnNode node = new ColumnNode("t0", "attr", null, attribute);
        context.addResultNode(node);
        Assert.assertFalse((boolean)context.isDistinctSuppression());
        DistinctStage stage = new DistinctStage();
        stage.perform(context);
        Assert.assertTrue((boolean)context.isDistinctSuppression());
    }
}

