/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DefaultObjectSelectTranslatorIT
extends ServerCase {
    @Inject
    DataContext context;
    @Inject
    DbAdapter adapter;

    @Test
    public void simpleSql() {
        ObjectSelect<Artist> select = ObjectSelect.query(Artist.class);
        DefaultSelectTranslator translator = new DefaultSelectTranslator(select, this.adapter, this.context.getEntityResolver());
        String sql = translator.getSql();
        Assert.assertTrue((boolean)sql.startsWith("SELECT "));
        Assert.assertTrue((boolean)sql.contains("t0.ARTIST_NAME"));
        Assert.assertTrue((boolean)sql.contains("t0.DATE_OF_BIRTH"));
        Assert.assertTrue((boolean)sql.contains("t0.ARTIST_ID"));
        Assert.assertTrue((sql.indexOf("FROM ARTIST t0") > sql.indexOf("t0.ARTIST_ID") ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)translator.getBindings().length);
        Assert.assertEquals((long)3L, (long)translator.getResultColumns().length);
        Assert.assertEquals((Object)"ARTIST_NAME", (Object)translator.getResultColumns()[0].getDataRowKey());
        Assert.assertEquals((Object)"DATE_OF_BIRTH", (Object)translator.getResultColumns()[1].getDataRowKey());
        Assert.assertEquals((Object)"ARTIST_ID", (Object)translator.getResultColumns()[2].getDataRowKey());
        Assert.assertFalse((boolean)translator.hasJoins());
        Assert.assertFalse((boolean)translator.isSuppressingDistinct());
    }

    @Test
    public void selectWithComplexWhere() {
        ObjectSelect<Artist> select = ObjectSelect.query(Artist.class, Artist.ARTIST_NAME.eq("artist").andExp(Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).eq("painting")));
        DefaultSelectTranslator translator = new DefaultSelectTranslator(select, this.adapter, this.context.getEntityResolver());
        String sql = translator.getSql();
        Assert.assertTrue((boolean)sql.startsWith("SELECT DISTINCT"));
        Assert.assertTrue((boolean)sql.contains("t0.ARTIST_NAME"));
        Assert.assertTrue((boolean)sql.contains("t0.DATE_OF_BIRTH"));
        Assert.assertTrue((boolean)sql.contains("t0.ARTIST_ID"));
        Assert.assertTrue((sql.indexOf("FROM ARTIST t0") > sql.indexOf("t0.ARTIST_ID") ? 1 : 0) != 0);
        Assert.assertTrue((sql.indexOf("JOIN PAINTING t1") > sql.indexOf("FROM ARTIST t0") ? 1 : 0) != 0);
        Assert.assertTrue((sql.indexOf("WHERE") > sql.indexOf("JOIN PAINTING t1") ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)translator.getBindings().length);
        Assert.assertEquals((Object)"ARTIST_NAME", (Object)translator.getBindings()[0].getAttribute().getName());
        Assert.assertEquals((Object)"PAINTING_TITLE", (Object)translator.getBindings()[1].getAttribute().getName());
        Assert.assertEquals((long)3L, (long)translator.getResultColumns().length);
        Assert.assertEquals((Object)"ARTIST_NAME", (Object)translator.getResultColumns()[0].getDataRowKey());
        Assert.assertEquals((Object)"DATE_OF_BIRTH", (Object)translator.getResultColumns()[1].getDataRowKey());
        Assert.assertEquals((Object)"ARTIST_ID", (Object)translator.getResultColumns()[2].getDataRowKey());
        Assert.assertTrue((boolean)translator.hasJoins());
        Assert.assertFalse((boolean)translator.isSuppressingDistinct());
    }

    @Test
    public void selectWithJointPrefetch() {
        ObjectSelect<Painting> select = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.joint());
        DefaultSelectTranslator translator = new DefaultSelectTranslator(select, this.adapter, this.context.getEntityResolver());
        String sql = translator.getSql();
        Assert.assertTrue((boolean)sql.startsWith("SELECT "));
        Assert.assertTrue((boolean)sql.contains("t0.ESTIMATED_PRICE"));
        Assert.assertTrue((boolean)sql.contains("t0.PAINTING_DESCRIPTION"));
        Assert.assertTrue((boolean)sql.contains("t0.PAINTING_TITLE"));
        Assert.assertTrue((boolean)sql.contains("t0.ARTIST_ID"));
        Assert.assertTrue((boolean)sql.contains("t0.GALLERY_ID"));
        Assert.assertTrue((boolean)sql.contains("t0.PAINTING_ID"));
        Assert.assertTrue((boolean)sql.contains("t1.ARTIST_ID"));
        Assert.assertTrue((boolean)sql.contains("t1.DATE_OF_BIRTH"));
        Assert.assertTrue((boolean)sql.contains("t1.ARTIST_NAME"));
        Assert.assertTrue((sql.indexOf("FROM PAINTING t0") > sql.indexOf("t1.ARTIST_NAME") ? 1 : 0) != 0);
        Assert.assertTrue((sql.indexOf("LEFT JOIN ARTIST t1") > sql.indexOf("FROM PAINTING t0") ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)translator.getBindings().length);
        Assert.assertEquals((long)9L, (long)translator.getResultColumns().length);
        Assert.assertEquals((Object)"ESTIMATED_PRICE", (Object)translator.getResultColumns()[0].getDataRowKey());
        Assert.assertEquals((Object)"PAINTING_DESCRIPTION", (Object)translator.getResultColumns()[1].getDataRowKey());
        Assert.assertEquals((Object)"PAINTING_TITLE", (Object)translator.getResultColumns()[2].getDataRowKey());
        Assert.assertEquals((Object)"ARTIST_ID", (Object)translator.getResultColumns()[3].getDataRowKey());
        Assert.assertEquals((Object)"GALLERY_ID", (Object)translator.getResultColumns()[4].getDataRowKey());
        Assert.assertEquals((Object)"PAINTING_ID", (Object)translator.getResultColumns()[5].getDataRowKey());
        Assert.assertEquals((Object)"toArtist.ARTIST_ID", (Object)translator.getResultColumns()[6].getDataRowKey());
        Assert.assertEquals((Object)"toArtist.DATE_OF_BIRTH", (Object)translator.getResultColumns()[7].getDataRowKey());
        Assert.assertEquals((Object)"toArtist.ARTIST_NAME", (Object)translator.getResultColumns()[8].getDataRowKey());
        Assert.assertTrue((boolean)translator.hasJoins());
        Assert.assertFalse((boolean)translator.isSuppressingDistinct());
    }
}

