/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.access.translator.batch.InsertBatchTranslator;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.testdo.locking.SimpleLockingTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-locking.xml")
public class InsertBatchTranslatorIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DbAdapter adapter;
    @Inject
    private UnitDbAdapter unitAdapter;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testConstructor() {
        DbAdapter adapter = (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
        InsertBatchQuery query = (InsertBatchQuery)Mockito.mock(InsertBatchQuery.class);
        InsertBatchTranslator builder = new InsertBatchTranslator(query, adapter);
        Assert.assertSame((Object)adapter, (Object)builder.context.getAdapter());
        Assert.assertSame((Object)query, builder.context.getQuery());
    }

    @Test
    public void testCreateSqlString() {
        DbEntity entity = this.runtime.getDataDomain().getEntityResolver().getObjEntity(SimpleLockingTestEntity.class).getDbEntity();
        DbAdapter adapter = (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
        InsertBatchQuery insertQuery = new InsertBatchQuery(entity, 1);
        InsertBatchTranslator builder = new InsertBatchTranslator(insertQuery, adapter);
        String generatedSql = builder.getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertEquals((Object)("INSERT INTO " + entity.getName() + "( DESCRIPTION, INT_COLUMN_NOTNULL, INT_COLUMN_NULL, LOCKING_TEST_ID, NAME) VALUES( ?, ?, ?, ?, ?)"), (Object)generatedSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithIdentifiersQuote() {
        DbEntity entity = this.runtime.getDataDomain().getEntityResolver().getObjEntity(SimpleLockingTestEntity.class).getDbEntity();
        try {
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            JdbcAdapter adapter = (JdbcAdapter)this.adapter;
            InsertBatchQuery insertQuery = new InsertBatchQuery(entity, 1);
            InsertBatchTranslator builder = new InsertBatchTranslator(insertQuery, (DbAdapter)adapter);
            String generatedSql = builder.getSql();
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertEquals((Object)("INSERT INTO " + charStart + entity.getName() + charEnd + "( " + charStart + "DESCRIPTION" + charEnd + ", " + charStart + "INT_COLUMN_NOTNULL" + charEnd + ", " + charStart + "INT_COLUMN_NULL" + charEnd + ", " + charStart + "LOCKING_TEST_ID" + charEnd + ", " + charStart + "NAME" + charEnd + ") VALUES( ?, ?, ?, ?, ?)"), (Object)generatedSql);
        }
        finally {
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }
}

