/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.Collections;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.Values;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ValuesTest {
    @Test
    public void testEmptyValues() {
        ObjectId id = ObjectId.of("test", "id", 123);
        Persistent persistent = this.mockObject(id);
        DbRowOp row = this.mockRow(persistent);
        Values values = new Values(row, false);
        Assert.assertTrue((boolean)values.getUpdatedAttributes().isEmpty());
        Assert.assertTrue((boolean)values.getSnapshot().isEmpty());
        Assert.assertTrue((boolean)values.getFlattenedIds().isEmpty());
        Assert.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testValuesWithId() {
        ObjectId id = ObjectId.of("test", "id", 123);
        Persistent persistent = this.mockObject(id);
        DbRowOp row = this.mockRow(persistent);
        Values values = new Values(row, true);
        Assert.assertTrue((boolean)values.getUpdatedAttributes().isEmpty());
        Assert.assertTrue((boolean)values.getFlattenedIds().isEmpty());
        Assert.assertEquals(Collections.singletonMap("id", 123), values.getSnapshot());
        Assert.assertFalse((boolean)values.isEmpty());
    }

    @Test
    public void testValuesWithUpdatedAttributes() {
        ObjectId id = ObjectId.of("test", "id", 123);
        Persistent persistent = this.mockObject(id);
        DbRowOp row = this.mockRow(persistent);
        Values values = new Values(row, false);
        DbAttribute attr1 = new DbAttribute("attr1");
        values.addValue(attr1, 32, false);
        Assert.assertEquals(Collections.singletonList(attr1), values.getUpdatedAttributes());
        Assert.assertEquals(Collections.singletonMap("attr1", 32), values.getSnapshot());
        Assert.assertTrue((boolean)values.getFlattenedIds().isEmpty());
        Assert.assertFalse((boolean)values.isEmpty());
    }

    private DbRowOp mockRow(Persistent persistent) {
        DbRowOp row = (DbRowOp)Mockito.mock(DbRowOp.class);
        ObjectId objectId = persistent.getObjectId();
        Mockito.when((Object)row.getChangeId()).thenReturn((Object)objectId);
        Mockito.when((Object)row.getObject()).thenReturn((Object)persistent);
        Mockito.when((Object)row.getEntity()).thenReturn((Object)this.mockEntity());
        return row;
    }

    private Persistent mockObject(ObjectId id) {
        Persistent persistent = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)persistent.getObjectId()).thenReturn((Object)id);
        Mockito.when((Object)persistent.getPersistenceState()).thenReturn((Object)4);
        return persistent;
    }

    private DbEntity mockEntity() {
        DbAttribute attribute1 = new DbAttribute("id");
        attribute1.setPrimaryKey(true);
        DbAttribute attribute2 = new DbAttribute("attr");
        DbEntity testEntity = new DbEntity("TEST");
        testEntity.addAttribute(attribute1);
        testEntity.addAttribute(attribute2);
        return testEntity;
    }
}

