/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BaseDbRowOpTest {
    @Test
    public void testEquals_SameId() {
        ObjectId id = ObjectId.of("test");
        InsertDbRowOp row1 = new InsertDbRowOp(this.mockObject(id), this.mockEntity(), id);
        InsertDbRowOp row2 = new InsertDbRowOp(this.mockObject(id), this.mockEntity(), id);
        Assert.assertEquals((Object)row1, (Object)row2);
        Assert.assertEquals((Object)row2, (Object)row1);
    }

    @Test
    public void testEquals_EqualId() {
        ObjectId id1 = ObjectId.of("test", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 1);
        InsertDbRowOp row1 = new InsertDbRowOp(this.mockObject(id1), this.mockEntity(), id1);
        InsertDbRowOp row2 = new InsertDbRowOp(this.mockObject(id2), this.mockEntity(), id2);
        Assert.assertEquals((Object)row1, (Object)row2);
        Assert.assertEquals((Object)row2, (Object)row1);
    }

    @Test
    public void testNotEquals_EqualId() {
        ObjectId id1 = ObjectId.of("test", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 1);
        InsertDbRowOp row1 = new InsertDbRowOp(this.mockObject(id1), this.mockEntity(), id1);
        DeleteDbRowOp row2 = new DeleteDbRowOp(this.mockObject(id2), this.mockEntity(), id2);
        Assert.assertNotEquals((Object)row1, (Object)row2);
        Assert.assertNotEquals((Object)row2, (Object)row1);
    }

    @Test
    public void testEqualsInsertUpdate_EqualId() {
        ObjectId id1 = ObjectId.of("test", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 1);
        InsertDbRowOp row1 = new InsertDbRowOp(this.mockObject(id1), this.mockEntity(), id1);
        UpdateDbRowOp row2 = new UpdateDbRowOp(this.mockObject(id2), this.mockEntity(), id2);
        Assert.assertEquals((Object)row1, (Object)row2);
        Assert.assertEquals((Object)row2, (Object)row1);
    }

    @Test
    public void testEqualsUpdateDelete_EqualId() {
        ObjectId id1 = ObjectId.of("test", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 1);
        DeleteDbRowOp row1 = new DeleteDbRowOp(this.mockObject(id1), this.mockEntity(), id1);
        UpdateDbRowOp row2 = new UpdateDbRowOp(this.mockObject(id2), this.mockEntity(), id2);
        Assert.assertEquals((Object)row1, (Object)row2);
        Assert.assertEquals((Object)row2, (Object)row1);
    }

    @Test
    public void testNotEquals_NotEqualId() {
        ObjectId id1 = ObjectId.of("test", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 2);
        InsertDbRowOp row1 = new InsertDbRowOp(this.mockObject(id1), this.mockEntity(), id1);
        InsertDbRowOp row2 = new InsertDbRowOp(this.mockObject(id2), this.mockEntity(), id2);
        Assert.assertNotEquals((Object)row1, (Object)row2);
        Assert.assertNotEquals((Object)row2, (Object)row1);
    }

    private Persistent mockObject(ObjectId id) {
        Persistent persistent = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)persistent.getObjectId()).thenReturn((Object)id);
        Mockito.when((Object)persistent.getPersistenceState()).thenReturn((Object)4);
        return persistent;
    }

    private DbEntity mockEntity() {
        DbAttribute attribute1 = new DbAttribute("id");
        attribute1.setPrimaryKey(true);
        DbAttribute attribute2 = new DbAttribute("attr");
        DbEntity testEntity = new DbEntity("TEST");
        testEntity.addAttribute(attribute1);
        testEntity.addAttribute(attribute2);
        return testEntity;
    }
}

