/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.flush.IdGenerationMarker;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

class PermanentObjectIdVisitor
implements DbRowOpVisitor<Void> {
    private final DataDomain dataDomain;
    private final EntityResolver resolver;
    private ClassDescriptor lastDescriptor;
    private ObjEntity lastObjEntity;
    private DbEntity lastDbEntity;
    private DataNode lastNode;
    private String lastEntityName;

    PermanentObjectIdVisitor(DataDomain dataDomain) {
        this.dataDomain = dataDomain;
        this.resolver = dataDomain.getEntityResolver();
    }

    @Override
    public Void visitInsert(InsertDbRowOp dbRow) {
        ObjectId id = dbRow.getChangeId();
        if (id == null || !id.isTemporary()) {
            return null;
        }
        if (this.lastObjEntity == null && this.lastDbEntity == null || !id.getEntityName().equals(this.lastEntityName)) {
            this.lastEntityName = id.getEntityName();
            if (this.lastEntityName.startsWith("db:")) {
                this.lastDbEntity = this.resolver.getDbEntity(this.lastEntityName.substring("db:".length()));
                this.lastObjEntity = null;
                this.lastDescriptor = null;
                this.lastNode = this.dataDomain.lookupDataNode(this.lastDbEntity.getDataMap());
            } else {
                this.lastObjEntity = this.resolver.getObjEntity(id.getEntityName());
                this.lastDbEntity = this.lastObjEntity.getDbEntity();
                this.lastDescriptor = this.resolver.getClassDescriptor(this.lastObjEntity.getName());
                this.lastNode = this.dataDomain.lookupDataNode(this.lastObjEntity.getDataMap());
            }
        }
        this.createPermanentId(dbRow);
        return null;
    }

    @Override
    public Void visitDelete(DeleteDbRowOp dbRow) {
        if (dbRow.getChangeId().isTemporary() && dbRow.getChangeId().isReplacementIdAttached()) {
            dbRow.setChangeId(dbRow.getChangeId().createReplacementId());
        }
        return null;
    }

    private void createPermanentId(InsertDbRowOp dbRow) {
        ObjectId id = dbRow.getChangeId();
        boolean supportsGeneratedKeys = this.lastNode.getAdapter().supportsGeneratedKeys();
        PkGenerator pkGenerator = this.lastNode.getAdapter().getPkGenerator();
        Map<String, Object> idMap = id.getReplacementIdMap();
        boolean autoPkDone = false;
        for (DbAttribute dbAttr : this.lastDbEntity.getPrimaryKeys()) {
            Class<?> javaClass;
            Object value;
            ObjAttribute objAttr;
            String dbAttrName = dbAttr.getName();
            if (idMap.containsKey(dbAttrName)) continue;
            if (!(this.lastObjEntity == null || (objAttr = this.lastObjEntity.getAttributeForDbAttribute(dbAttr)) == null || (value = this.lastDescriptor.getProperty(objAttr.getName()).readPropertyDirectly(dbRow.getObject())) == null || (javaClass = objAttr.getJavaClass()).isPrimitive() && value instanceof Number && ((Number)value).intValue() == 0)) {
                idMap.put(dbAttrName, value);
                continue;
            }
            if (supportsGeneratedKeys && dbAttr.isGenerated()) {
                idMap.put(dbAttrName, new IdGenerationMarker(id));
                continue;
            }
            if (autoPkDone) {
                throw new CayenneRuntimeException("Primary Key autogeneration only works for a single attribute.", new Object[0]);
            }
            try {
                Object pkValue = pkGenerator.generatePk(this.lastNode, dbAttr);
                idMap.put(dbAttrName, pkValue);
                autoPkDone = true;
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error generating PK: %s", (Throwable)ex, ex.getMessage());
            }
        }
    }
}

