/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.flush.DefaultDataDomainFlushAction;
import org.apache.cayenne.access.flush.operation.BaseDbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DefaultDataDomainFlushActionTest {
    @Test
    public void mergeSameObjectIds() {
        ObjectId id1 = ObjectId.of("test2", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 2);
        ObjectId id3 = ObjectId.of("test", "id", 2);
        ObjectId id4 = ObjectId.of("test", "id", 3);
        ObjectId id5 = ObjectId.of("test2", "id", 4);
        ObjectId id6 = ObjectId.of("test", "id", 5);
        ObjectId id7 = ObjectId.of("test", "id", 6);
        ObjectId id8 = ObjectId.of("test2", "id", 3);
        ObjectId id9 = ObjectId.of("test2", "id", 4);
        ObjectId id10 = ObjectId.of("test", "id", 6);
        DbEntity test = this.mockEntity("test");
        DbEntity test2 = this.mockEntity("test2");
        BaseDbRowOp[] op = new BaseDbRowOp[]{new InsertDbRowOp(this.mockObject(id1), test2, id1), new InsertDbRowOp(this.mockObject(id2), test, id2), new DeleteDbRowOp(this.mockObject(id3), test, id3), new UpdateDbRowOp(this.mockObject(id4), test, id4), new InsertDbRowOp(this.mockObject(id5), test2, id5), new DeleteDbRowOp(this.mockObject(id6), test, id6), new InsertDbRowOp(this.mockObject(id7), test, id7), new UpdateDbRowOp(this.mockObject(id8), test2, id8), new DeleteDbRowOp(this.mockObject(id9), test2, id9), new DeleteDbRowOp(this.mockObject(id10), test, id10)};
        DefaultDataDomainFlushAction action = (DefaultDataDomainFlushAction)Mockito.mock(DefaultDataDomainFlushAction.class);
        Mockito.when(action.mergeSameObjectIds((List)ArgumentMatchers.any(List.class))).thenCallRealMethod();
        List<DbRowOp> merged = action.mergeSameObjectIds(new ArrayList<DbRowOp>(Arrays.asList(op)));
        Assert.assertEquals((long)7L, (long)merged.size());
        Assert.assertThat(merged, (Matcher)CoreMatchers.hasItems((Object[])new DbRowOp[]{op[0], op[3], op[5], op[7]}));
        Assert.assertThat(merged, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.sameInstance((Object)op[1]))));
        Assert.assertThat(merged, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.sameInstance((Object)op[2]))));
        Assert.assertThat(merged, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.sameInstance((Object)op[4]))));
        Assert.assertThat(merged, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.sameInstance((Object)op[6]))));
        Assert.assertThat(merged, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.sameInstance((Object)op[8]))));
        Assert.assertThat(merged, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.sameInstance((Object)op[9]))));
    }

    @Test
    public void createQueries() {
        ObjectId id1 = ObjectId.of("test", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 2);
        ObjectId id3 = ObjectId.of("test2", "id", 3);
        ObjectId id4 = ObjectId.of("test2", "id", 4);
        ObjectId id5 = ObjectId.of("test", "id", 5);
        ObjectId id6 = ObjectId.of("test2", "id", 6);
        ObjectId id7 = ObjectId.of("test", "id", 7);
        DbEntity test = this.mockEntity("test");
        DbEntity test2 = this.mockEntity("test2");
        ArrayList<DbRowOp> ops = new ArrayList<DbRowOp>();
        ops.add(new InsertDbRowOp(this.mockObject(id1), test, id1));
        ops.add(new InsertDbRowOp(this.mockObject(id2), test, id2));
        ops.add(new InsertDbRowOp(this.mockObject(id3), test2, id5));
        ops.add(new InsertDbRowOp(this.mockObject(id4), test2, id7));
        ops.add(new UpdateDbRowOp(this.mockObject(id5), test, id3));
        ops.add(new DeleteDbRowOp(this.mockObject(id6), test2, id6));
        ops.add(new DeleteDbRowOp(this.mockObject(id7), test, id4));
        DefaultDataDomainFlushAction action = (DefaultDataDomainFlushAction)Mockito.mock(DefaultDataDomainFlushAction.class);
        Mockito.when(action.createQueries((List)ArgumentMatchers.any(List.class))).thenCallRealMethod();
        List<? extends Query> queries = action.createQueries(ops);
        Assert.assertEquals((long)4L, (long)queries.size());
        Assert.assertThat((Object)queries.get(0), (Matcher)CoreMatchers.instanceOf(InsertBatchQuery.class));
        InsertBatchQuery insert1 = (InsertBatchQuery)queries.get(0);
        Assert.assertSame((Object)test, (Object)insert1.getDbEntity());
        Assert.assertEquals((long)2L, (long)insert1.getRows().size());
        Assert.assertThat((Object)queries.get(1), (Matcher)CoreMatchers.instanceOf(InsertBatchQuery.class));
        InsertBatchQuery insert2 = (InsertBatchQuery)queries.get(1);
        Assert.assertSame((Object)test2, (Object)insert2.getDbEntity());
        Assert.assertEquals((long)2L, (long)insert2.getRows().size());
        Assert.assertThat((Object)queries.get(2), (Matcher)CoreMatchers.instanceOf(DeleteBatchQuery.class));
        DeleteBatchQuery delete1 = (DeleteBatchQuery)queries.get(2);
        Assert.assertSame((Object)test2, (Object)delete1.getDbEntity());
        Assert.assertEquals((long)1L, (long)delete1.getRows().size());
        Assert.assertThat((Object)queries.get(3), (Matcher)CoreMatchers.instanceOf(DeleteBatchQuery.class));
        DeleteBatchQuery delete2 = (DeleteBatchQuery)queries.get(3);
        Assert.assertSame((Object)test, (Object)delete2.getDbEntity());
        Assert.assertEquals((long)1L, (long)delete2.getRows().size());
    }

    private Persistent mockObject(ObjectId id) {
        Persistent persistent = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)persistent.getObjectId()).thenReturn((Object)id);
        Mockito.when((Object)persistent.getPersistenceState()).thenReturn((Object)4);
        return persistent;
    }

    private DbEntity mockEntity(String name) {
        DbAttribute attribute1 = new DbAttribute("id");
        attribute1.setPrimaryKey(true);
        DbAttribute attribute2 = new DbAttribute("attr");
        DbEntity testEntity = new DbEntity(name);
        testEntity.addAttribute(attribute1);
        testEntity.addAttribute(attribute2);
        return testEntity;
    }
}

