/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.flush.ArcValuesCreationHandler;
import org.apache.cayenne.access.flush.DbRowOpFactory;
import org.apache.cayenne.access.flush.operation.DbRowOpType;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.Values;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ArcValuesCreationHandlerTest {
    private ArcValuesCreationHandler handler;
    private DbRowOpFactory factory;
    private InsertDbRowOp dbRowOp;
    private Values values;

    @Before
    public void setup() {
        this.factory = (DbRowOpFactory)Mockito.mock(DbRowOpFactory.class);
        this.handler = new ArcValuesCreationHandler(this.factory, DbRowOpType.INSERT);
        this.dbRowOp = (InsertDbRowOp)Mockito.mock(InsertDbRowOp.class);
        this.values = new Values(this.dbRowOp, false);
        ObjectDiff diff = (ObjectDiff)Mockito.mock(ObjectDiff.class);
        ClassDescriptor descriptor = (ClassDescriptor)Mockito.mock(ClassDescriptor.class);
        ObjEntity entity = (ObjEntity)Mockito.mock(ObjEntity.class);
        ObjRelationship relationship = (ObjRelationship)Mockito.mock(ObjRelationship.class);
        DbRelationship dbRelationship = (DbRelationship)Mockito.mock(DbRelationship.class);
        ObjectStore store = (ObjectStore)Mockito.mock(ObjectStore.class);
        Persistent object = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when(relationship.getDbRelationships()).thenReturn(Collections.singletonList(dbRelationship));
        Mockito.when((Object)entity.getRelationship(Mockito.anyString())).thenReturn((Object)relationship);
        Mockito.when((Object)descriptor.getEntity()).thenReturn((Object)entity);
        Mockito.when(this.dbRowOp.accept((DbRowOpVisitor)Mockito.any(DbRowOpVisitor.class))).thenCallRealMethod();
        Mockito.when((Object)this.dbRowOp.getValues()).thenReturn((Object)this.values);
        Mockito.when((Object)this.factory.getDiff()).thenReturn((Object)diff);
        Mockito.when((Object)this.factory.getDescriptor()).thenReturn((Object)descriptor);
        Mockito.when((Object)this.factory.getStore()).thenReturn((Object)store);
        Mockito.when((Object)this.factory.getObject()).thenReturn((Object)object);
        Mockito.when(this.factory.getOrCreate((DbEntity)Mockito.isNull(), (ObjectId)Mockito.any(ObjectId.class), (DbRowOpType)Mockito.any(DbRowOpType.class))).thenReturn((Object)this.dbRowOp);
    }

    @Test
    public void processRelationshipPkPkMaster() {
        ObjectId srcId = ObjectId.of("test1", "id1", 1);
        ObjectId targetId = ObjectId.of("test2", "id2", 2);
        DbRelationship relationship = DbRelBuilder.of("id1", "id2").withToDepPk().withDstPk().withSrcPk().build();
        this.handler.processRelationship(relationship, srcId, targetId, true);
        Assert.assertNotNull((Object)this.handler);
        ((DbRowOpFactory)Mockito.verify((Object)this.factory)).getOrCreate((DbEntity)Mockito.isNull(), (ObjectId)Mockito.eq((Object)targetId), (DbRowOpType)Mockito.eq((Object)DbRowOpType.UPDATE));
        Assert.assertTrue((boolean)targetId.isReplacementIdAttached());
        Assert.assertEquals((long)1L, (long)targetId.getReplacementIdMap().size());
        Assert.assertEquals((Object)1, (Object)targetId.getReplacementIdMap().get("id2"));
        Assert.assertFalse((boolean)srcId.isReplacementIdAttached());
    }

    @Test
    public void processRelationshipPkPkDependent() {
        ObjectId srcId = ObjectId.of("test1", "id1", 1);
        ObjectId targetId = ObjectId.of("test2", "id2", 2);
        DbRelationship relationship = DbRelBuilder.of("id1", "id2").withDstPk().withSrcPk().build();
        this.handler.processRelationship(relationship, srcId, targetId, true);
        Assert.assertNotNull((Object)this.handler);
        ((DbRowOpFactory)Mockito.verify((Object)this.factory)).getOrCreate((DbEntity)Mockito.isNull(), (ObjectId)Mockito.eq((Object)srcId), (DbRowOpType)Mockito.eq((Object)DbRowOpType.INSERT));
        Assert.assertTrue((boolean)srcId.isReplacementIdAttached());
        Assert.assertEquals((long)1L, (long)srcId.getReplacementIdMap().size());
        Assert.assertEquals((Object)2, (Object)srcId.getReplacementIdMap().get("id1"));
        Assert.assertFalse((boolean)targetId.isReplacementIdAttached());
    }

    @Test
    public void processRelationshipPkFkMaster() {
        ObjectId srcId = ObjectId.of("test1", "pk", 1);
        ObjectId targetId = ObjectId.of("test2", "id2", 2);
        DbRelationship relationship = DbRelBuilder.of("pk", "fk").withSrcPk().build();
        this.handler.processRelationship(relationship, srcId, targetId, true);
        Assert.assertNotNull((Object)this.handler);
        ((DbRowOpFactory)Mockito.verify((Object)this.factory)).getOrCreate((DbEntity)Mockito.isNull(), (ObjectId)Mockito.eq((Object)targetId), (DbRowOpType)Mockito.eq((Object)DbRowOpType.UPDATE));
        Assert.assertFalse((boolean)srcId.isReplacementIdAttached());
        Assert.assertFalse((boolean)targetId.isReplacementIdAttached());
        ((InsertDbRowOp)Mockito.verify((Object)this.dbRowOp)).getValues();
        Map<String, Object> snapshot = this.values.getSnapshot();
        Assert.assertEquals((long)1L, (long)snapshot.size());
        Assert.assertEquals((Object)1, (Object)snapshot.get("fk"));
    }

    @Test
    public void processRelationshipFkPkDependent() {
        ObjectId srcId = ObjectId.of("test1", "id1", 1);
        ObjectId targetId = ObjectId.of("test2", "pk", 2);
        DbRelationship relationship = DbRelBuilder.of("fk", "pk").withDstPk().build();
        this.handler.processRelationship(relationship, srcId, targetId, true);
        Assert.assertNotNull((Object)this.handler);
        ((DbRowOpFactory)Mockito.verify((Object)this.factory)).getOrCreate((DbEntity)Mockito.isNull(), (ObjectId)Mockito.eq((Object)srcId), (DbRowOpType)Mockito.eq((Object)DbRowOpType.INSERT));
        Assert.assertFalse((boolean)srcId.isReplacementIdAttached());
        Assert.assertFalse((boolean)targetId.isReplacementIdAttached());
        ((InsertDbRowOp)Mockito.verify((Object)this.dbRowOp)).getValues();
        Map<String, Object> snapshot = this.values.getSnapshot();
        Assert.assertEquals((long)1L, (long)snapshot.size());
        Assert.assertEquals((Object)2, (Object)snapshot.get("fk"));
    }

    static final class DbRelBuilder {
        private String srcName;
        private String dstName;
        private boolean srcPk;
        private boolean dstPk;
        private boolean toDepPk;

        DbRelBuilder() {
        }

        static DbRelBuilder of(String srcName, String dstName) {
            DbRelBuilder builder = new DbRelBuilder();
            builder.srcName = srcName;
            builder.dstName = dstName;
            return builder;
        }

        DbRelBuilder withSrcPk() {
            this.srcPk = true;
            return this;
        }

        DbRelBuilder withDstPk() {
            this.dstPk = true;
            return this;
        }

        DbRelBuilder withToDepPk() {
            this.toDepPk = true;
            return this;
        }

        DbRelationship build() {
            DbRelationship relationship = (DbRelationship)Mockito.mock(DbRelationship.class);
            Mockito.when((Object)relationship.isToDependentPK()).thenReturn((Object)this.toDepPk);
            DbJoin join = (DbJoin)Mockito.mock(DbJoin.class);
            DbAttribute src = new DbAttribute(this.srcName);
            src.setPrimaryKey(this.srcPk);
            DbAttribute target = new DbAttribute(this.dstName);
            target.setPrimaryKey(this.dstPk);
            Mockito.when((Object)join.getSource()).thenReturn((Object)src);
            Mockito.when((Object)join.getSourceName()).thenReturn((Object)src.getName());
            Mockito.when((Object)join.getTarget()).thenReturn((Object)target);
            Mockito.when((Object)join.getTargetName()).thenReturn((Object)target.getName());
            Mockito.when(relationship.getJoins()).thenReturn(Collections.singletonList(join));
            DbRelationship mockRel = (DbRelationship)Mockito.mock(DbRelationship.class);
            Mockito.when((Object)relationship.getReverseRelationship()).thenReturn((Object)mockRel);
            return relationship;
        }
    }
}

