/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.unit.di.server.ServerCase;

public class SchemaUpdateStrategyBase
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DataNode node;
    @Inject
    protected DbAdapter adapter;

    @Override
    public void cleanUpDB() throws Exception {
        DataMap map = this.node.getEntityResolver().getDataMap("sus-map");
        for (String name : this.existingTables()) {
            for (String drop : this.adapter.dropTableStatements(map.getDbEntity(name))) {
                this.context.performGenericQuery(new SQLTemplate(Object.class, drop));
            }
        }
    }

    protected void setStrategy(Class<? extends SchemaUpdateStrategy> type) throws Exception {
        this.node.setSchemaUpdateStrategy(type.newInstance());
    }

    protected Collection<String> existingTables() {
        ArrayList<String> present = new ArrayList<String>();
        for (Map.Entry<String, Boolean> e : this.tablesMap().entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            present.add(e.getKey());
        }
        return present;
    }

    protected void createOneTable(String entityName) {
        DataMap map = this.node.getEntityResolver().getDataMap("sus-map");
        String createTable = this.adapter.createTable(map.getDbEntity(entityName));
        this.context.performGenericQuery(new SQLTemplate(Object.class, createTable));
    }

    protected Map<String, Boolean> tablesMap() {
        DataMap map = this.node.getEntityResolver().getDataMap("sus-map");
        HashMap<String, String> tables = new HashMap<String, String>();
        for (String string : map.getDbEntityMap().keySet()) {
            tables.put(string.toLowerCase(), string);
            tables.put(string.toUpperCase(), string);
        }
        HashMap<String, Boolean> presentInDB = new HashMap<String, Boolean>();
        for (String name : map.getDbEntityMap().keySet()) {
            presentInDB.put(name, false);
        }
        String string = this.node.getAdapter().tableTypeForTable();
        try (Connection con = this.node.getDataSource().getConnection();
             ResultSet rs = con.getMetaData().getTables(null, null, "%", new String[]{string});){
            while (rs.next()) {
                String dbName = rs.getString("TABLE_NAME");
                String name = (String)tables.get(dbName);
                if (name == null) continue;
                presentInDB.put(name, true);
            }
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException(e);
        }
        return presentInDB;
    }
}

