/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SelectById;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.inheritance_vertical.Iv1Root;
import org.apache.cayenne.testdo.inheritance_vertical.Iv1Sub1;
import org.apache.cayenne.testdo.inheritance_vertical.Iv2Sub1;
import org.apache.cayenne.testdo.inheritance_vertical.Iv2X;
import org.apache.cayenne.testdo.inheritance_vertical.IvConcrete;
import org.apache.cayenne.testdo.inheritance_vertical.IvGenKeySub;
import org.apache.cayenne.testdo.inheritance_vertical.IvImpl;
import org.apache.cayenne.testdo.inheritance_vertical.IvImplWithLock;
import org.apache.cayenne.testdo.inheritance_vertical.IvOther;
import org.apache.cayenne.testdo.inheritance_vertical.IvRoot;
import org.apache.cayenne.testdo.inheritance_vertical.IvSub1;
import org.apache.cayenne.testdo.inheritance_vertical.IvSub1Sub1;
import org.apache.cayenne.testdo.inheritance_vertical.IvSub2;
import org.apache.cayenne.testdo.inheritance_vertical.IvSub3;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.validation.ValidationException;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-inheritance-vertical.xml")
public class VerticalInheritanceIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected ServerRuntime runtime;

    @Test
    public void testInsert_Root() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"});
        Assert.assertEquals((long)0L, (long)ivRootTable.getRowCount());
        IvRoot root = this.context.newObject(IvRoot.class);
        root.setName("XyZ");
        root.getObjectContext().commitChanges();
        Assert.assertEquals((long)1L, (long)ivRootTable.getRowCount());
        Object[] rootData = ivRootTable.select();
        Assert.assertEquals((long)3L, (long)rootData.length);
        Assert.assertTrue((boolean)(rootData[0] instanceof Number));
        Assert.assertTrue((((Number)rootData[0]).intValue() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"XyZ", (Object)rootData[1]);
        Assert.assertNull((Object)rootData[2]);
    }

    @Test
    public void testInsert_Sub1() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"});
        TableHelper ivSub1Table = new TableHelper(this.dbHelper, "IV_SUB1");
        ivSub1Table.setColumns(new String[]{"ID", "SUB1_NAME"});
        IvSub1 sub1 = this.context.newObject(IvSub1.class);
        sub1.setName("XyZX");
        sub1.getObjectContext().commitChanges();
        Assert.assertEquals((long)1L, (long)ivRootTable.getRowCount());
        Assert.assertEquals((long)0L, (long)ivSub1Table.getRowCount());
        Object[] data = ivRootTable.select();
        Assert.assertEquals((long)3L, (long)data.length);
        Assert.assertTrue((boolean)(data[0] instanceof Number));
        Assert.assertTrue((((Number)data[0]).intValue() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"XyZX", (Object)data[1]);
        Assert.assertEquals((Object)"IvSub1", (Object)data[2]);
        ivSub1Table.deleteAll();
        ivRootTable.deleteAll();
        IvSub1 sub11 = this.context.newObject(IvSub1.class);
        sub11.setName("XyZXY");
        sub11.setSub1Name("BdE2");
        sub11.getObjectContext().commitChanges();
        data = ivRootTable.select();
        Assert.assertEquals((long)3L, (long)data.length);
        Assert.assertTrue((boolean)(data[0] instanceof Number));
        Assert.assertTrue((((Number)data[0]).intValue() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"XyZXY", (Object)data[1]);
        Assert.assertEquals((Object)"IvSub1", (Object)data[2]);
        Object[] subdata = ivSub1Table.select();
        Assert.assertEquals((long)2L, (long)subdata.length);
        Assert.assertEquals((Object)data[0], (Object)subdata[0]);
        Assert.assertEquals((Object)"BdE2", (Object)subdata[1]);
    }

    @Test
    public void testInsert_Sub2() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"});
        TableHelper ivSub2Table = new TableHelper(this.dbHelper, "IV_SUB2");
        ivSub2Table.setColumns(new String[]{"ID", "SUB2_NAME", "SUB2_ATTR"});
        IvSub2 sub2 = this.context.newObject(IvSub2.class);
        sub2.setName("XyZX");
        sub2.getObjectContext().commitChanges();
        Assert.assertEquals((long)1L, (long)ivRootTable.getRowCount());
        Assert.assertEquals((long)0L, (long)ivSub2Table.getRowCount());
        Object[] data = ivRootTable.select();
        Assert.assertEquals((long)3L, (long)data.length);
        Assert.assertTrue((boolean)(data[0] instanceof Number));
        Assert.assertTrue((((Number)data[0]).intValue() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"XyZX", (Object)data[1]);
        Assert.assertEquals((Object)"IvSub2", (Object)data[2]);
        ivSub2Table.deleteAll();
        ivRootTable.deleteAll();
        IvSub2 sub21 = this.context.newObject(IvSub2.class);
        sub21.setName("XyZXY");
        sub21.setSub2Name("BdE2");
        sub21.setSub2Attr("aTtR");
        sub21.getObjectContext().commitChanges();
        data = ivRootTable.select();
        Assert.assertEquals((long)3L, (long)data.length);
        Assert.assertTrue((boolean)(data[0] instanceof Number));
        Assert.assertTrue((((Number)data[0]).intValue() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"XyZXY", (Object)data[1]);
        Assert.assertEquals((Object)"IvSub2", (Object)data[2]);
        Object[] subdata = ivSub2Table.select();
        Assert.assertEquals((long)3L, (long)subdata.length);
        Assert.assertEquals((Object)data[0], (Object)subdata[0]);
        Assert.assertEquals((Object)"BdE2", (Object)subdata[1]);
        Assert.assertEquals((Object)"aTtR", (Object)subdata[2]);
        sub21.setSub2Attr("BUuT");
        sub21.getObjectContext().commitChanges();
        subdata = ivSub2Table.select();
        Assert.assertEquals((long)3L, (long)subdata.length);
        Assert.assertEquals((Object)data[0], (Object)subdata[0]);
        Assert.assertEquals((Object)"BdE2", (Object)subdata[1]);
        Assert.assertEquals((Object)"BUuT", (Object)subdata[2]);
        sub21.getObjectContext().deleteObjects(sub21);
        sub21.getObjectContext().commitChanges();
        Assert.assertEquals((long)0L, (long)ivRootTable.getRowCount());
        Assert.assertEquals((long)0L, (long)ivSub2Table.getRowCount());
    }

    @Test(expected=ValidationException.class)
    public void testValidationOnInsert_Sub3_Exception() {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"});
        TableHelper ivSub3Table = new TableHelper(this.dbHelper, "IV_SUB3");
        ivSub3Table.setColumns(new String[]{"ID", "IV_ROOT_ID"});
        IvSub3 sub3 = this.context.newObject(IvSub3.class);
        sub3.setName("XyZX");
        this.context.commitChanges();
    }

    @Test
    public void testValidationOnInsert_Sub3_Ok() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"});
        TableHelper ivSub3Table = new TableHelper(this.dbHelper, "IV_SUB3");
        ivSub3Table.setColumns(new String[]{"ID", "IV_ROOT_ID"});
        IvSub3 sub3 = this.context.newObject(IvSub3.class);
        sub3.setName("XyZX");
        sub3.setIvRoot(sub3);
        this.context.commitChanges();
        Assert.assertEquals((long)1L, (long)ivRootTable.getRowCount());
        Assert.assertEquals((long)1L, (long)ivSub3Table.getRowCount());
    }

    @Test
    public void testUpdateRelation_Sub3() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"});
        ivRootTable.insert(new Object[]{1, "root1", null});
        ivRootTable.insert(new Object[]{2, "root2", null});
        ivRootTable.insert(new Object[]{3, "name", "IvSub3"});
        TableHelper ivSub3Table = new TableHelper(this.dbHelper, "IV_SUB3");
        ivSub3Table.setColumns(new String[]{"ID", "IV_ROOT_ID"});
        ivSub3Table.insert(new Object[]{3, 1});
        IvRoot root = SelectById.query(IvRoot.class, 2).selectOne(this.context);
        IvSub3 sub3 = SelectById.query(IvSub3.class, 3).selectOne(this.context);
        sub3.setName("new name");
        sub3.setIvRoot(root);
        this.context.commitChanges();
        ObjectContext cleanContext = this.runtime.newContext();
        IvSub3 sub3Clean = SelectById.query(IvSub3.class, 3).selectOne(cleanContext);
        Assert.assertNotNull((Object)sub3Clean);
        Assert.assertNotSame((Object)sub3, (Object)sub3Clean);
        Assert.assertEquals((Object)"new name", (Object)sub3.getName());
        Assert.assertNotNull((Object)sub3Clean.getIvRoot());
        Assert.assertEquals((Object)"root2", (Object)sub3Clean.getIvRoot().getName());
    }

    @Test
    public void testInsert_Sub1Sub1() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"});
        TableHelper ivSub1Table = new TableHelper(this.dbHelper, "IV_SUB1");
        ivSub1Table.setColumns(new String[]{"ID", "SUB1_NAME"});
        TableHelper ivSub1Sub1Table = new TableHelper(this.dbHelper, "IV_SUB1_SUB1");
        ivSub1Sub1Table.setColumns(new String[]{"ID", "SUB1_SUB1_NAME"});
        IvSub1Sub1 sub1Sub1 = this.context.newObject(IvSub1Sub1.class);
        sub1Sub1.setName("XyZN");
        sub1Sub1.setSub1Name("mDA");
        sub1Sub1.setSub1Sub1Name("3DQa");
        sub1Sub1.getObjectContext().commitChanges();
        Assert.assertEquals((long)1L, (long)ivRootTable.getRowCount());
        Assert.assertEquals((long)1L, (long)ivSub1Table.getRowCount());
        Assert.assertEquals((long)1L, (long)ivSub1Sub1Table.getRowCount());
        Object[] data = ivRootTable.select();
        Assert.assertEquals((long)3L, (long)data.length);
        Assert.assertTrue((boolean)(data[0] instanceof Number));
        Assert.assertTrue((((Number)data[0]).intValue() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"XyZN", (Object)data[1]);
        Assert.assertEquals((Object)"IvSub1Sub1", (Object)data[2]);
        Object[] subdata = ivSub1Table.select();
        Assert.assertEquals((long)2L, (long)subdata.length);
        Assert.assertEquals((Object)data[0], (Object)subdata[0]);
        Assert.assertEquals((Object)"mDA", (Object)subdata[1]);
        Object[] subsubdata = ivSub1Sub1Table.select();
        Assert.assertEquals((long)2L, (long)subsubdata.length);
        Assert.assertEquals((Object)data[0], (Object)subsubdata[0]);
        Assert.assertEquals((Object)"3DQa", (Object)subsubdata[1]);
    }

    @Test
    public void testSelectQuery_SuperSub() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"}).setColumnTypes(new int[]{4, 12, 12});
        TableHelper ivSub1Table = new TableHelper(this.dbHelper, "IV_SUB1");
        ivSub1Table.setColumns(new String[]{"ID", "SUB1_NAME"});
        ivRootTable.insert(new Object[]{1, "xROOT", null});
        ivRootTable.insert(new Object[]{2, "xSUB1_ROOT", "IvSub1"});
        ivSub1Table.insert(new Object[]{2, "xSUB1"});
        ObjectSelect<IvRoot> query = ObjectSelect.query(IvRoot.class);
        List<IvRoot> results = this.context.select(query);
        Assert.assertEquals((long)2L, (long)results.size());
        HashMap<String, IvRoot> resultTypes = new HashMap<String, IvRoot>();
        for (IvRoot result : results) {
            resultTypes.put(result.getClass().getName(), result);
        }
        Assert.assertEquals((long)2L, (long)resultTypes.size());
        IvRoot root = (IvRoot)resultTypes.get(IvRoot.class.getName());
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)"xROOT", (Object)root.getName());
        Assert.assertNull((Object)root.getDiscriminator());
        IvSub1 sub1 = (IvSub1)resultTypes.get(IvSub1.class.getName());
        Assert.assertNotNull((Object)sub1);
        Assert.assertEquals((Object)"xSUB1_ROOT", (Object)sub1.getName());
        Assert.assertEquals((Object)"IvSub1", (Object)sub1.getDiscriminator());
    }

    @Test
    public void testSelectQuery_DeepAndWide() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"}).setColumnTypes(new int[]{4, 12, 12});
        TableHelper ivSub1Table = new TableHelper(this.dbHelper, "IV_SUB1");
        ivSub1Table.setColumns(new String[]{"ID", "SUB1_NAME"});
        TableHelper ivSub2Table = new TableHelper(this.dbHelper, "IV_SUB2");
        ivSub2Table.setColumns(new String[]{"ID", "SUB2_NAME"});
        TableHelper ivSub1Sub1Table = new TableHelper(this.dbHelper, "IV_SUB1_SUB1");
        ivSub1Sub1Table.setColumns(new String[]{"ID", "SUB1_SUB1_NAME"});
        ivRootTable.insert(new Object[]{1, "xROOT", null});
        ivRootTable.insert(new Object[]{2, "xSUB1_ROOT", "IvSub1"});
        ivSub1Table.insert(new Object[]{2, "xSUB1"});
        ivRootTable.insert(new Object[]{3, "xSUB1_SUB1_ROOT", "IvSub1Sub1"});
        ivSub1Table.insert(new Object[]{3, "xSUB1_SUB1_SUBROOT"});
        ivSub1Sub1Table.insert(new Object[]{3, "xSUB1_SUB1"});
        ivRootTable.insert(new Object[]{4, "xROOT_SUB2", "IvSub2"});
        ivSub2Table.insert(new Object[]{4, "xSUB2"});
        ObjectSelect<IvRoot> query = ObjectSelect.query(IvRoot.class);
        List<IvRoot> results = this.context.select(query);
        Assert.assertEquals((long)4L, (long)results.size());
        HashMap<String, IvRoot> resultTypes = new HashMap<String, IvRoot>();
        for (IvRoot result : results) {
            resultTypes.put(result.getClass().getName(), result);
        }
        Assert.assertEquals((long)4L, (long)resultTypes.size());
        IvRoot root = (IvRoot)resultTypes.get(IvRoot.class.getName());
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)"xROOT", (Object)root.getName());
        Assert.assertNull((Object)root.getDiscriminator());
        IvSub1 sub1 = (IvSub1)resultTypes.get(IvSub1.class.getName());
        Assert.assertNotNull((Object)sub1);
        Assert.assertEquals((Object)"xSUB1_ROOT", (Object)sub1.getName());
        Assert.assertEquals((Object)"IvSub1", (Object)sub1.getDiscriminator());
        IvSub1Sub1 sub1Sub1 = (IvSub1Sub1)resultTypes.get(IvSub1Sub1.class.getName());
        Assert.assertNotNull((Object)sub1Sub1);
        Assert.assertEquals((Object)"xSUB1_SUB1_ROOT", (Object)sub1Sub1.getName());
        Assert.assertEquals((Object)"IvSub1Sub1", (Object)sub1Sub1.getDiscriminator());
        Assert.assertEquals((Object)"xSUB1_SUB1_SUBROOT", (Object)sub1Sub1.getSub1Name());
        Assert.assertEquals((Object)"xSUB1_SUB1", (Object)sub1Sub1.getSub1Sub1Name());
        IvSub2 sub2 = (IvSub2)resultTypes.get(IvSub2.class.getName());
        Assert.assertNotNull((Object)sub2);
        Assert.assertEquals((Object)"xROOT_SUB2", (Object)sub2.getName());
        Assert.assertEquals((Object)"IvSub2", (Object)sub2.getDiscriminator());
        Assert.assertEquals((Object)"xSUB2", (Object)sub2.getSub2Name());
    }

    @Test
    public void testSelectQuery_MiddleLeaf() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"}).setColumnTypes(new int[]{4, 12, 12});
        TableHelper ivSub1Table = new TableHelper(this.dbHelper, "IV_SUB1");
        ivSub1Table.setColumns(new String[]{"ID", "SUB1_NAME"});
        TableHelper ivSub2Table = new TableHelper(this.dbHelper, "IV_SUB2");
        ivSub2Table.setColumns(new String[]{"ID", "SUB2_NAME"});
        TableHelper ivSub1Sub1Table = new TableHelper(this.dbHelper, "IV_SUB1_SUB1");
        ivSub1Sub1Table.setColumns(new String[]{"ID", "SUB1_SUB1_NAME"});
        ivRootTable.insert(new Object[]{1, "xROOT", null});
        ivRootTable.insert(new Object[]{2, "xSUB1_ROOT", "IvSub1"});
        ivSub1Table.insert(new Object[]{2, "xSUB1"});
        ivRootTable.insert(new Object[]{3, "xSUB1_SUB1_ROOT", "IvSub1Sub1"});
        ivSub1Table.insert(new Object[]{3, "xSUB1_SUB1_SUBROOT"});
        ivSub1Sub1Table.insert(new Object[]{3, "xSUB1_SUB1"});
        ivRootTable.insert(new Object[]{4, "xROOT_SUB2", "IvSub2"});
        ivSub2Table.insert(new Object[]{4, "xSUB2"});
        ObjectSelect<IvSub1> query = ObjectSelect.query(IvSub1.class);
        List<IvSub1> results = this.context.select(query);
        Assert.assertEquals((long)2L, (long)results.size());
        HashMap<String, IvRoot> resultTypes = new HashMap<String, IvRoot>();
        for (IvRoot ivRoot : results) {
            resultTypes.put(ivRoot.getClass().getName(), ivRoot);
        }
        Assert.assertEquals((long)2L, (long)resultTypes.size());
        IvSub1 sub1 = (IvSub1)resultTypes.get(IvSub1.class.getName());
        Assert.assertNotNull((Object)sub1);
        Assert.assertEquals((Object)"xSUB1_ROOT", (Object)sub1.getName());
        Assert.assertEquals((Object)"IvSub1", (Object)sub1.getDiscriminator());
        IvSub1Sub1 ivSub1Sub1 = (IvSub1Sub1)resultTypes.get(IvSub1Sub1.class.getName());
        Assert.assertNotNull((Object)ivSub1Sub1);
        Assert.assertEquals((Object)"xSUB1_SUB1_ROOT", (Object)ivSub1Sub1.getName());
        Assert.assertEquals((Object)"IvSub1Sub1", (Object)ivSub1Sub1.getDiscriminator());
        Assert.assertEquals((Object)"xSUB1_SUB1_SUBROOT", (Object)ivSub1Sub1.getSub1Name());
        Assert.assertEquals((Object)"xSUB1_SUB1", (Object)ivSub1Sub1.getSub1Sub1Name());
    }

    @Test
    public void testDelete_Mix() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"}).setColumnTypes(new int[]{4, 12, 12});
        TableHelper ivSub1Table = new TableHelper(this.dbHelper, "IV_SUB1");
        ivSub1Table.setColumns(new String[]{"ID", "SUB1_NAME"});
        TableHelper ivSub2Table = new TableHelper(this.dbHelper, "IV_SUB2");
        ivSub2Table.setColumns(new String[]{"ID", "SUB2_NAME"});
        TableHelper ivSub1Sub1Table = new TableHelper(this.dbHelper, "IV_SUB1_SUB1");
        ivSub1Sub1Table.setColumns(new String[]{"ID", "SUB1_SUB1_NAME"});
        ivRootTable.insert(new Object[]{1, "xROOT", null});
        ivRootTable.insert(new Object[]{2, "xSUB1_ROOT", "IvSub1"});
        ivSub1Table.insert(new Object[]{2, "xSUB1"});
        ivRootTable.insert(new Object[]{3, "xSUB1_SUB1_ROOT", "IvSub1Sub1"});
        ivSub1Table.insert(new Object[]{3, "xSUB1_SUB1_SUBROOT"});
        ivSub1Sub1Table.insert(new Object[]{3, "xSUB1_SUB1"});
        ivRootTable.insert(new Object[]{4, "xROOT_SUB2", "IvSub2"});
        ivSub2Table.insert(new Object[]{4, "xSUB2"});
        ObjectSelect<IvRoot> query = ObjectSelect.query(IvRoot.class);
        List<Object> results = query.select(this.context);
        Assert.assertEquals((long)4L, (long)results.size());
        HashMap<String, IvRoot> resultTypes = new HashMap<String, IvRoot>();
        for (IvRoot ivRoot : results) {
            resultTypes.put(ivRoot.getClass().getName(), ivRoot);
        }
        Assert.assertEquals((long)4L, (long)resultTypes.size());
        IvRoot root = (IvRoot)resultTypes.get(IvRoot.class.getName());
        this.context.deleteObjects(root);
        IvSub1 ivSub1 = (IvSub1)resultTypes.get(IvSub1.class.getName());
        this.context.deleteObjects(ivSub1);
        this.context.commitChanges();
        Assert.assertEquals((long)2L, (long)ivRootTable.getRowCount());
        Assert.assertEquals((long)1L, (long)ivSub1Table.getRowCount());
        Assert.assertEquals((long)1L, (long)ivSub1Sub1Table.getRowCount());
        Assert.assertEquals((long)1L, (long)ivSub2Table.getRowCount());
        results = this.context.select(query);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    @Deprecated
    public void testSelectQuery_AttributeOverrides() throws Exception {
        TableHelper iv1RootTable = new TableHelper(this.dbHelper, "IV1_ROOT");
        iv1RootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"}).setColumnTypes(new int[]{4, 12, 12});
        TableHelper iv1Sub1Table = new TableHelper(this.dbHelper, "IV1_SUB1");
        iv1Sub1Table.setColumns(new String[]{"ID", "SUB1_NAME"});
        iv1RootTable.insert(new Object[]{1, "xROOT", null});
        iv1RootTable.insert(new Object[]{2, "xSUB1_ROOT", "Iv1Sub1"});
        iv1Sub1Table.insert(new Object[]{2, "xSUB1"});
        ObjectSelect<Iv1Root> query = ObjectSelect.query(Iv1Root.class);
        List<Iv1Root> results = this.context.select(query);
        Assert.assertEquals((long)2L, (long)results.size());
        HashMap<String, Iv1Root> resultTypes = new HashMap<String, Iv1Root>();
        for (Iv1Root result : results) {
            resultTypes.put(result.getClass().getName(), result);
        }
        Assert.assertEquals((long)2L, (long)resultTypes.size());
        Iv1Root root = (Iv1Root)resultTypes.get(Iv1Root.class.getName());
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)"xROOT", (Object)root.getName());
        Assert.assertNull((Object)root.getDiscriminator());
        Iv1Sub1 sub1 = (Iv1Sub1)resultTypes.get(Iv1Sub1.class.getName());
        Assert.assertNotNull((Object)sub1);
        Assert.assertEquals((Object)"xSUB1", (Object)sub1.getName());
    }

    @Test
    public void testInsertWithRelationship() throws SQLException {
        TableHelper xTable = new TableHelper(this.dbHelper, "IV2_X");
        TableHelper rootTable = new TableHelper(this.dbHelper, "IV2_ROOT");
        TableHelper sub1Table = new TableHelper(this.dbHelper, "IV2_SUB1");
        Assert.assertEquals((long)0L, (long)xTable.getRowCount());
        Assert.assertEquals((long)0L, (long)rootTable.getRowCount());
        Assert.assertEquals((long)0L, (long)sub1Table.getRowCount());
        Iv2Sub1 root = this.context.newObject(Iv2Sub1.class);
        Iv2X x = this.context.newObject(Iv2X.class);
        root.setX(x);
        this.context.commitChanges();
        Assert.assertEquals((long)1L, (long)xTable.getRowCount());
        Assert.assertEquals((long)1L, (long)rootTable.getRowCount());
        Assert.assertEquals((long)1L, (long)sub1Table.getRowCount());
    }

    @Test
    public void testUpdateWithRelationship() {
        IvConcrete parent1 = this.context.newObject(IvConcrete.class);
        parent1.setName("Parent1");
        this.context.commitChanges();
        IvConcrete parent2 = this.context.newObject(IvConcrete.class);
        parent2.setName("Parent2");
        this.context.commitChanges();
        IvConcrete child = this.context.newObject(IvConcrete.class);
        child.setName("Child");
        child.setParent(parent1);
        this.context.commitChanges();
        child.setParent(parent2);
        this.context.commitChanges();
        Assert.assertEquals((Object)parent2, (Object)child.getParent());
        this.context.deleteObject(child);
        this.context.commitChanges();
    }

    @Test
    public void testInsertWithAttributeAndRelationship() {
        IvOther other = this.context.newObject(IvOther.class);
        other.setName("other");
        IvImpl impl = this.context.newObject(IvImpl.class);
        impl.setName("Impl 1");
        impl.setAttr1("attr1");
        impl.setOther1(other);
        this.context.commitChanges();
    }

    @Test
    public void testInsertWithMultipleAttributeAndMultipleRelationship() {
        IvOther other1 = this.context.newObject(IvOther.class);
        other1.setName("other1");
        IvOther other2 = this.context.newObject(IvOther.class);
        other2.setName("other2");
        IvImpl impl = this.context.newObject(IvImpl.class);
        impl.setName("Impl 1");
        impl.setAttr1("attr1");
        impl.setAttr2("attr2");
        impl.setOther1(other1);
        impl.setOther2(other2);
        this.context.commitChanges();
        IvImpl impl2 = ObjectSelect.query(IvImpl.class).selectFirst(this.context);
        Assert.assertEquals((Object)other1, (Object)impl2.getOther1());
        Assert.assertEquals((Object)other2, (Object)impl2.getOther2());
    }

    @Test
    public void testInsertTwoObjectsWithMultipleAttributeAndMultipleRelationship() {
        IvOther other1 = this.context.newObject(IvOther.class);
        other1.setName("other1");
        IvOther other2 = this.context.newObject(IvOther.class);
        other2.setName("other2");
        IvImpl impl1 = this.context.newObject(IvImpl.class);
        impl1.setName("Impl 1");
        impl1.setAttr1("attr1");
        impl1.setAttr2("attr2");
        impl1.setOther1(other1);
        impl1.setOther2(other2);
        IvImpl impl2 = this.context.newObject(IvImpl.class);
        impl2.setName("Impl 2");
        impl2.setAttr1("attr1");
        impl2.setAttr2("attr2");
        impl2.setOther1(other1);
        impl2.setOther2(other2);
        this.context.commitChanges();
        Assert.assertEquals((long)2L, (long)ObjectSelect.query(IvImpl.class).selectCount(this.context));
    }

    @Test
    public void testUpdateWithOptimisticLocks() throws SQLException {
        TableHelper ivOtherTable = new TableHelper(this.dbHelper, "IV_OTHER");
        ivOtherTable.setColumns(new String[]{"ID", "NAME"}).setColumnTypes(new int[]{4, 12});
        TableHelper ivBaseWithLockTable = new TableHelper(this.dbHelper, "IV_BASE_WITH_LOCK");
        ivBaseWithLockTable.setColumns(new String[]{"ID", "NAME", "TYPE"}).setColumnTypes(new int[]{4, 12, 1});
        TableHelper ivImplWithLockTable = new TableHelper(this.dbHelper, "IV_IMPL_WITH_LOCK");
        ivImplWithLockTable.setColumns(new String[]{"ID", "ATTR1", "OTHER1_ID"}).setColumnTypes(new int[]{4, 12, 4});
        ivOtherTable.insert(new Object[]{1, "other1"});
        ivBaseWithLockTable.insert(new Object[]{1, "Impl 1", "I"});
        ivImplWithLockTable.insert(new Object[]{1, "attr1", 1});
        for (IvImplWithLock record : ObjectSelect.query(IvImplWithLock.class).select(this.context)) {
            record.setName(record.getName() + "-Change");
            record.setAttr1(record.getAttr1() + "-Change");
        }
        this.context.commitChanges();
    }

    @Test
    public void testCountEjbqlQuery() throws Exception {
        TableHelper ivRootTable = new TableHelper(this.dbHelper, "IV_ROOT");
        ivRootTable.setColumns(new String[]{"ID", "NAME", "DISCRIMINATOR"});
        TableHelper ivSub1Table = new TableHelper(this.dbHelper, "IV_SUB1");
        ivSub1Table.setColumns(new String[]{"ID", "SUB1_NAME"});
        TableHelper ivSub2Table = new TableHelper(this.dbHelper, "IV_SUB2");
        ivSub2Table.setColumns(new String[]{"ID", "SUB2_ATTR", "SUB2_NAME"});
        ivRootTable.insert(new Object[]{1, "root1", ""});
        ivRootTable.insert(new Object[]{2, "sub11", "IvSub1"});
        ivSub1Table.insert(new Object[]{2, "sub_name1_1"});
        ivRootTable.insert(new Object[]{3, "sub21", "IvSub2"});
        ivRootTable.insert(new Object[]{4, "sub22", "IvSub2"});
        ivSub2Table.insert(new Object[]{3, "attr1", "sub_name2_1"});
        ivSub2Table.insert(new Object[]{4, "attr2", "sub_name2_2"});
        EJBQLQuery query1 = new EJBQLQuery("SELECT COUNT(a) FROM IvRoot a");
        Assert.assertEquals(Collections.singletonList(4L), (Object)this.context.performQuery(query1));
        EJBQLQuery query2 = new EJBQLQuery("SELECT COUNT(a) FROM IvSub1 a");
        Assert.assertEquals(Collections.singletonList(1L), (Object)this.context.performQuery(query2));
        EJBQLQuery query3 = new EJBQLQuery("SELECT COUNT(a) FROM IvSub2 a");
        Assert.assertEquals(Collections.singletonList(2L), (Object)this.context.performQuery(query3));
    }

    @Test
    public void testPropagatedGeneratedPK() {
        IvGenKeySub sub = this.context.newObject(IvGenKeySub.class);
        sub.setName("test");
        this.context.commitChanges();
        Assert.assertTrue((Cayenne.intPKForObject(sub) > 0 ? 1 : 0) != 0);
    }
}

