/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ToManyList;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCaseContextsSync;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.unit.util.SQLTemplateCustomizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextSharedCacheIT
extends ServerCaseContextsSync {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;
    @Inject
    private SQLTemplateCustomizer sqlTemplateCustomizer;
    private Artist artist;

    @Before
    public void setUp() throws Exception {
        this.artist = (Artist)this.context.newObject("Artist");
        this.artist.setArtistName("version1");
        this.artist.setDateOfBirth(new Date());
        this.context.commitChanges();
    }

    @Test
    public void testSnapshotChangePropagationOnSelect() throws Exception {
        String originalName = this.artist.getArtistName();
        String newName = "version2";
        SQLTemplate query = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, "UPDATE ARTIST SET ARTIST_NAME = #bind($newName) WHERE ARTIST_NAME = #bind($oldName)");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("newName", "version2");
        map.put("oldName", originalName);
        query.setParams(map);
        this.context.performNonSelectingQuery(query);
        List artists = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("version2")).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist altArtist = (Artist)artists.get(0);
        DataRow freshSnapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId());
        Assert.assertNotNull((Object)freshSnapshot);
        Assert.assertEquals((Object)"version2", freshSnapshot.get("ARTIST_NAME"));
        Assert.assertEquals((Object)"version2", (Object)altArtist.getArtistName());
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((String)"Peer object state wasn't refreshed on fetch", (Object)"version2", (Object)DataContextSharedCacheIT.this.artist.getArtistName());
            }
        };
        helper.runTest(3000L);
    }

    @Test
    public void testSnapshotChangePropagation() throws Exception {
        String originalName = this.artist.getArtistName();
        String newName = "version2";
        final Artist altArtist = this.context1.localObject(this.artist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        Assert.assertEquals((Object)originalName, (Object)altArtist.getArtistName());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        this.artist.setArtistName("version2");
        Assert.assertEquals((Object)originalName, (Object)altArtist.getArtistName());
        this.context.commitChanges();
        DataRow freshSnapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId());
        Assert.assertEquals((Object)"version2", freshSnapshot.get("ARTIST_NAME"));
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((Object)"version2", (Object)altArtist.getArtistName());
            }
        };
        helper.runTest(3000L);
    }

    @Test
    public void testSnapshotChangePropagationToModifiedObjects() throws Exception {
        String originalName = this.artist.getArtistName();
        Date originalDate = this.artist.getDateOfBirth();
        String newName = "version2";
        final Date newDate = new Date(originalDate.getTime() - 10000L);
        String newAltName = "version3";
        final Artist altArtist = this.context1.localObject(this.artist);
        Assert.assertNotNull((Object)altArtist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        Assert.assertEquals((Object)originalName, (Object)altArtist.getArtistName());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        this.artist.setArtistName(newName);
        this.artist.setDateOfBirth(newDate);
        altArtist.setArtistName("version3");
        this.context.commitChanges();
        DataRow freshSnapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId());
        Assert.assertEquals((Object)newName, freshSnapshot.get("ARTIST_NAME"));
        Assert.assertEquals((Object)newDate, freshSnapshot.get("DATE_OF_BIRTH"));
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((Object)"version3", (Object)altArtist.getArtistName());
                Assert.assertEquals((Object)newDate, (Object)altArtist.getDateOfBirth());
                Assert.assertEquals((long)4L, (long)altArtist.getPersistenceState());
            }
        };
        helper.runTest(3000L);
    }

    @Test
    public void testSnapshotDeletePropagationToCommitted() throws Exception {
        final Artist altArtist = this.context1.localObject(this.artist);
        Assert.assertNotNull((Object)altArtist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.artist.getArtistName(), (Object)altArtist.getArtistName());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        this.context.deleteObjects(this.artist);
        this.context.commitChanges();
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId()));
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)1L, (long)altArtist.getPersistenceState());
                Assert.assertNull((Object)altArtist.getObjectContext());
            }
        };
        helper.runTest(3000L);
    }

    @Test
    public void testSnapshotDeletePropagationToHollow() throws Exception {
        final Artist altArtist = this.context1.localObject(this.artist);
        Assert.assertNotNull((Object)altArtist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)altArtist.getPersistenceState());
        this.context.deleteObjects(this.artist);
        this.context.commitChanges();
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId()));
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)1L, (long)altArtist.getPersistenceState());
                Assert.assertNull((Object)altArtist.getObjectContext());
            }
        };
        helper.runTest(3000L);
    }

    @Test
    public void testSnapshotDeletePropagationToModified() throws Exception {
        final Artist altArtist = this.context1.localObject(this.artist);
        altArtist.getArtistName();
        Assert.assertNotNull((Object)altArtist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        altArtist.setArtistName("version2");
        Assert.assertEquals((long)4L, (long)altArtist.getPersistenceState());
        this.context.deleteObjects(this.artist);
        this.context.commitChanges();
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId()));
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)2L, (long)altArtist.getPersistenceState());
            }
        };
        helper.runTest(3000L);
        ObjectId id = altArtist.getObjectId();
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)id.getIdSnapshot().get("ARTIST_ID"));
        Assert.assertFalse((boolean)id.isTemporary());
        this.context1.commitChanges();
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
    }

    @Test
    public void testSnapshotDeletePropagationToDeleted() throws Exception {
        final Artist altArtist = this.context1.localObject(this.artist);
        altArtist.getArtistName();
        Assert.assertNotNull((Object)altArtist);
        Assert.assertFalse((altArtist == this.artist ? 1 : 0) != 0);
        this.context1.deleteObjects(altArtist);
        this.context.deleteObjects(this.artist);
        this.context.commitChanges();
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId()));
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)1L, (long)altArtist.getPersistenceState());
                Assert.assertNull((Object)altArtist.getObjectContext());
            }
        };
        helper.runTest(3000L);
        Assert.assertFalse((boolean)this.context1.hasChanges());
    }

    @Test
    public void testSnapshotDeletePropagationToManyRefresh() throws Exception {
        Painting painting1 = (Painting)this.context.newObject("Painting");
        painting1.setPaintingTitle("p1");
        painting1.setToArtist(this.artist);
        Painting painting2 = (Painting)this.context.newObject("Painting");
        painting2.setPaintingTitle("p2");
        painting2.setToArtist(this.artist);
        this.context.commitChanges();
        final Artist altArtist = this.context1.localObject(this.artist);
        final Painting altPainting1 = this.context1.localObject(painting1);
        Painting altPainting2 = this.context1.localObject(painting2);
        Assert.assertEquals((Object)this.artist.getArtistName(), (Object)altArtist.getArtistName());
        Assert.assertEquals((Object)painting1.getPaintingTitle(), (Object)altPainting1.getPaintingTitle());
        Assert.assertEquals((Object)painting2.getPaintingTitle(), (Object)altPainting2.getPaintingTitle());
        Assert.assertEquals((long)2L, (long)altArtist.getPaintingArray().size());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        Assert.assertEquals((long)3L, (long)altPainting1.getPersistenceState());
        Assert.assertEquals((long)3L, (long)altPainting2.getPersistenceState());
        altPainting1.getToArtist();
        altPainting2.getToArtist();
        Assert.assertSame((Object)altArtist, (Object)altPainting1.readPropertyDirectly("toArtist"));
        Assert.assertSame((Object)altArtist, (Object)altPainting2.readPropertyDirectly("toArtist"));
        this.context.deleteObjects(painting1);
        this.context.commitChanges();
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(painting1.getObjectId()));
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)1L, (long)altPainting1.getPersistenceState());
                Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
                List<Painting> list = altArtist.getPaintingArray();
                Assert.assertEquals((long)1L, (long)list.size());
                Assert.assertFalse((boolean)list.contains(altPainting1));
            }
        };
        helper.runTest(3000L);
    }

    @Test
    public void testSnapshotInsertPropagationToManyRefresh() throws Exception {
        Painting painting1 = (Painting)this.context.newObject("Painting");
        painting1.setPaintingTitle("p1");
        painting1.setToArtist(this.artist);
        this.context.commitChanges();
        final Artist altArtist = this.context1.localObject(this.artist);
        Painting altPainting1 = this.context1.localObject(painting1);
        Assert.assertEquals((Object)this.artist.getArtistName(), (Object)altArtist.getArtistName());
        Assert.assertEquals((Object)painting1.getPaintingTitle(), (Object)altPainting1.getPaintingTitle());
        Assert.assertEquals((long)1L, (long)altArtist.getPaintingArray().size());
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        Assert.assertEquals((long)3L, (long)altPainting1.getPersistenceState());
        Painting painting2 = (Painting)this.context.newObject("Painting");
        painting2.setPaintingTitle("p2");
        painting2.setToArtist(this.artist);
        this.context.commitChanges();
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Object value = altArtist.readPropertyDirectly("paintingArray");
                Assert.assertTrue((String)("Unexpected: " + value), (boolean)(value instanceof ToManyList));
                Assert.assertTrue((boolean)((ToManyList)value).isFault());
            }
        };
        helper.runTest(2000L);
        List<Painting> list = altArtist.getPaintingArray();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testCacheRefreshingOnSelect() throws Exception {
        String originalName = this.artist.getArtistName();
        String newName = "version2";
        DataContext context = (DataContext)this.artist.getObjectContext();
        DataRow oldSnapshot = context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId());
        Assert.assertNotNull((Object)oldSnapshot);
        Assert.assertEquals((Object)originalName, oldSnapshot.get("ARTIST_NAME"));
        SQLTemplate update = this.sqlTemplateCustomizer.createSQLTemplate(Artist.class, "UPDATE ARTIST SET ARTIST_NAME = #bind($newName) WHERE ARTIST_NAME = #bind($oldName)");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("newName", "version2");
        map.put("oldName", originalName);
        update.setParams(map);
        context.performNonSelectingQuery(update);
        List artists = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("version2")).select(context);
        Assert.assertEquals((long)1L, (long)artists.size());
        this.artist = (Artist)artists.get(0);
        DataRow freshSnapshot = context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId());
        Assert.assertNotSame((Object)oldSnapshot, (Object)freshSnapshot);
        Assert.assertEquals((Object)"version2", freshSnapshot.get("ARTIST_NAME"));
        Assert.assertEquals((Object)"version2", (Object)this.artist.getArtistName());
    }

    @Test
    public void testSnapshotEvictedForHollow() throws Exception {
        String originalName = this.artist.getArtistName();
        this.context.invalidateObjects(this.artist);
        Assert.assertEquals((long)5L, (long)this.artist.getPersistenceState());
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId()));
        Assert.assertEquals((Object)originalName, (Object)this.artist.getArtistName());
        DataRow freshSnapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId());
        Assert.assertNotNull((Object)freshSnapshot);
        Assert.assertEquals((Object)originalName, freshSnapshot.get("ARTIST_NAME"));
    }

    @Test
    public void testSnapshotEvictedAndObjectsHollowedForInvalidate() throws Exception {
        String originalName = this.artist.getArtistName();
        final Artist altArtist = this.context1.localObject(this.artist);
        this.context1.prepareForAccess(altArtist, null, false);
        Assert.assertEquals((long)3L, (long)altArtist.getPersistenceState());
        this.context.invalidateObjects(this.artist);
        Assert.assertEquals((long)5L, (long)this.artist.getPersistenceState());
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId()));
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)5L, (long)altArtist.getPersistenceState());
                Assert.assertNull((Object)DataContextSharedCacheIT.this.context1.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId()));
            }
        }.runTest(5000L);
        Assert.assertEquals((Object)originalName, (Object)altArtist.getArtistName());
        DataRow altFreshSnapshot = this.context1.getObjectStore().getDataRowCache().getCachedSnapshot(altArtist.getObjectId());
        Assert.assertNotNull((Object)altFreshSnapshot);
        Assert.assertEquals((Object)originalName, altFreshSnapshot.get("ARTIST_NAME"));
    }

    @Test
    public void testSnapshotEvictedForCommitted() throws Exception {
        String newName = "version2";
        Assert.assertEquals((long)3L, (long)this.artist.getPersistenceState());
        this.context.getObjectStore().getDataRowCache().forgetSnapshot(this.artist.getObjectId());
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId()));
        this.artist.setArtistName(newName);
        this.context.commitChanges();
        Assert.assertEquals((Object)newName, (Object)this.artist.getArtistName());
        DataRow freshSnapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId());
        Assert.assertNotNull((Object)freshSnapshot);
        Assert.assertEquals((Object)newName, freshSnapshot.get("ARTIST_NAME"));
    }

    @Test
    public void testSnapshotEvictedForModified() throws Exception {
        String newName = "version2";
        Assert.assertEquals((long)3L, (long)this.artist.getPersistenceState());
        this.artist.setArtistName(newName);
        this.context.getObjectStore().getDataRowCache().forgetSnapshot(this.artist.getObjectId());
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId()));
        this.context.commitChanges();
        Assert.assertEquals((Object)newName, (Object)this.artist.getArtistName());
        DataRow freshSnapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId());
        Assert.assertNotNull((Object)freshSnapshot);
        Assert.assertEquals((Object)newName, freshSnapshot.get("ARTIST_NAME"));
    }

    @Test
    public void testSnapshotEvictedAndChangedForModified() throws Exception {
        String originalName = this.artist.getArtistName();
        String newName = "version2";
        String backendName = "version3";
        Assert.assertEquals((long)3L, (long)this.artist.getPersistenceState());
        this.artist.setArtistName(newName);
        this.context.getObjectStore().getDataRowCache().forgetSnapshot(this.artist.getObjectId());
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId()));
        String template = "UPDATE ARTIST SET ARTIST_NAME = #bind($newName) WHERE ARTIST_NAME = #bind($oldName)";
        SQLTemplate update = new SQLTemplate(Artist.class, template);
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("newName", backendName);
        map.put("oldName", originalName);
        update.setParams(map);
        this.context.performNonSelectingQuery(update);
        this.context.commitChanges();
        Assert.assertEquals((Object)newName, (Object)this.artist.getArtistName());
        DataRow freshSnapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(this.artist.getObjectId());
        Assert.assertNotNull((Object)freshSnapshot);
        Assert.assertEquals((Object)newName, freshSnapshot.get("ARTIST_NAME"));
    }

    @Test
    public void testSnapshotEvictedForDeleted() throws Exception {
        ObjectId id = this.artist.getObjectId();
        Assert.assertEquals((long)3L, (long)this.artist.getPersistenceState());
        this.context.deleteObjects(this.artist);
        this.context.getObjectStore().getDataRowCache().forgetSnapshot(id);
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(id));
        this.context.commitChanges();
        Assert.assertEquals((long)1L, (long)this.artist.getPersistenceState());
        Assert.assertNull((Object)this.context.getObjectStore().getDataRowCache().getCachedSnapshot(id));
    }
}

