/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Date;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextRefreshingIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, 12, -5, 3});
    }

    protected void createSingleArtistDataSet() throws Exception {
        this.tArtist.insert(new Object[]{5, "artist2"});
    }

    protected void createSingleArtistAndPaintingDataSet() throws Exception {
        this.createSingleArtistDataSet();
        this.tPainting.insert(new Object[]{4, "p", 5, 1000});
    }

    protected void createSingleArtistAndUnrelatedPaintingDataSet() throws Exception {
        this.createSingleArtistDataSet();
        this.tPainting.insert(new Object[]{4, "p", null, 1000});
    }

    protected void createTwoArtistsAndPaintingDataSet() throws Exception {
        this.tArtist.insert(new Object[]{5, "artist2"});
        this.tArtist.insert(new Object[]{6, "artist3"});
        this.tPainting.insert(new Object[]{4, "p", 5, 1000});
    }

    @Test
    public void testRefetchRootWithUpdatedAttributes() throws Exception {
        this.createSingleArtistDataSet();
        String nameBefore = "artist2";
        String nameAfter = "not an artist";
        ObjectSelect<Artist> queryBefore = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq(nameBefore));
        Artist artist = (Artist)this.context.performQuery(queryBefore).get(0);
        Assert.assertEquals((Object)nameBefore, (Object)artist.getArtistName());
        Assert.assertEquals((long)1L, (long)this.tArtist.update().set("ARTIST_NAME", (Object)nameAfter).execute());
        List artists = queryBefore.select(this.context);
        Assert.assertEquals((long)0L, (long)artists.size());
        ObjectSelect<Artist> queryAfter = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq(nameAfter));
        artist = (Artist)this.context.performQuery(queryAfter).get(0);
        Assert.assertNotNull((Object)artist);
        Assert.assertEquals((Object)nameAfter, (Object)artist.getArtistName());
    }

    @Test
    public void testRefetchRootWithNullifiedToOne() throws Exception {
        this.createSingleArtistAndPaintingDataSet();
        Painting painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Assert.assertNotNull((Object)painting.getToArtist());
        Assert.assertEquals((Object)"artist2", (Object)painting.getToArtist().getArtistName());
        Assert.assertEquals((long)1L, (long)this.tPainting.update().set("ARTIST_ID", null, -5).execute());
        painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Assert.assertNotNull((Object)painting);
        Assert.assertNull((Object)painting.getToArtist());
    }

    @Test
    public void testRefetchRootWithChangedToOneTarget() throws Exception {
        this.createTwoArtistsAndPaintingDataSet();
        Painting painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Artist artistBefore = painting.getToArtist();
        Assert.assertNotNull((Object)artistBefore);
        Assert.assertEquals((Object)"artist2", (Object)artistBefore.getArtistName());
        Assert.assertEquals((long)1L, (long)this.tPainting.update().set("ARTIST_ID", (Object)6).execute());
        painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Assert.assertNotNull((Object)painting);
        Assert.assertEquals((Object)"artist3", (Object)painting.getToArtist().getArtistName());
    }

    @Test
    public void testRefetchRootWithNullToOneTargetChangedToNotNull() throws Exception {
        this.createSingleArtistAndUnrelatedPaintingDataSet();
        Painting painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Assert.assertNull((Object)painting.getToArtist());
        Assert.assertEquals((long)1L, (long)this.tPainting.update().set("ARTIST_ID", (Object)5).execute());
        painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Assert.assertNotNull((Object)painting);
        Assert.assertEquals((Object)"artist2", (Object)painting.getToArtist().getArtistName());
    }

    @Test
    public void testRefetchRootWithDeletedToMany() throws Exception {
        this.createSingleArtistAndPaintingDataSet();
        Artist artist = (Artist)this.context.performQuery(ObjectSelect.query(Artist.class)).get(0);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)1L);
        Assert.assertEquals((long)1L, (long)this.tPainting.delete().where("PAINTING_ID", (Object)4).execute());
        artist = (Artist)this.context.performQuery(ObjectSelect.query(Artist.class)).get(0);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)1L);
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjoint());
        artist = (Artist)this.context.performQuery(query).get(0);
        Assert.assertEquals((long)0L, (long)artist.getPaintingArray().size());
    }

    @Test
    public void testRefetchRootWithAddedToMany() throws Exception {
        this.createSingleArtistDataSet();
        Artist artist = (Artist)this.context.performQuery(ObjectSelect.query(Artist.class)).get(0);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)0L);
        this.tPainting.insert(new Object[]{5, "p", 5, 1000});
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class);
        artist = (Artist)this.context.performQuery(query).get(0);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)0L);
        query.prefetch(Artist.PAINTING_ARRAY.disjoint());
        artist = (Artist)this.context.performQuery(query).get(0);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)1L);
    }

    @Test
    public void testInvalidateRootWithUpdatedAttributes() throws Exception {
        this.createSingleArtistDataSet();
        String nameBefore = "artist2";
        String nameAfter = "not an artist";
        Artist artist = (Artist)this.context.performQuery(ObjectSelect.query(Artist.class)).get(0);
        Assert.assertNotNull((Object)artist);
        Assert.assertEquals((Object)nameBefore, (Object)artist.getArtistName());
        Assert.assertEquals((long)1L, (long)this.tArtist.update().set("ARTIST_NAME", (Object)nameAfter).execute());
        this.context.invalidateObjects(artist);
        Assert.assertEquals((Object)nameAfter, (Object)artist.getArtistName());
    }

    @Test
    public void testInvalidateRootWithNullifiedToOne() throws Exception {
        this.createSingleArtistAndPaintingDataSet();
        Painting painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Assert.assertNotNull((Object)painting.getToArtist());
        Assert.assertEquals((Object)"artist2", (Object)painting.getToArtist().getArtistName());
        Assert.assertEquals((long)1L, (long)this.tPainting.update().set("ARTIST_ID", null, -5).execute());
        this.context.invalidateObjects(painting);
        Assert.assertNull((Object)painting.getToArtist());
    }

    @Test
    public void testInvalidateRootWithChangedToOneTarget() throws Exception {
        this.createTwoArtistsAndPaintingDataSet();
        Painting painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Artist artistBefore = painting.getToArtist();
        Assert.assertNotNull((Object)artistBefore);
        Assert.assertEquals((Object)"artist2", (Object)artistBefore.getArtistName());
        Assert.assertEquals((long)1L, (long)this.tPainting.update().set("ARTIST_ID", (Object)6).execute());
        this.context.invalidateObjects(painting);
        Assert.assertNotSame((Object)artistBefore, (Object)painting.getToArtist());
        Assert.assertEquals((Object)"artist3", (Object)painting.getToArtist().getArtistName());
    }

    @Test
    public void testInvalidateRootWithNullToOneTargetChangedToNotNull() throws Exception {
        this.createSingleArtistAndUnrelatedPaintingDataSet();
        Painting painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Assert.assertNull((Object)painting.getToArtist());
        Assert.assertEquals((long)1L, (long)this.tPainting.update().set("ARTIST_ID", (Object)5).execute());
        this.context.invalidateObjects(painting);
        Assert.assertNotNull((Object)painting.getToArtist());
        Assert.assertEquals((Object)"artist2", (Object)painting.getToArtist().getArtistName());
    }

    @Test
    public void testInvalidateRootWithDeletedToMany() throws Exception {
        this.createSingleArtistAndPaintingDataSet();
        Artist artist = (Artist)this.context.performQuery(ObjectSelect.query(Artist.class)).get(0);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)1L);
        Assert.assertEquals((long)1L, (long)this.tPainting.delete().execute());
        this.context.invalidateObjects(artist);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)0L);
    }

    @Test
    public void testInvaliateRootWithAddedToMany() throws Exception {
        this.createSingleArtistDataSet();
        Artist artist = (Artist)this.context.performQuery(ObjectSelect.query(Artist.class)).get(0);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)0L);
        this.tPainting.insert(new Object[]{4, "p", 5, 1000});
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)0L);
        this.context.invalidateObjects(artist);
        Assert.assertEquals((long)artist.getPaintingArray().size(), (long)1L);
    }

    @Test
    public void testInvalidateThenModify() throws Exception {
        this.createSingleArtistDataSet();
        Artist artist = (Artist)this.context.performQuery(ObjectSelect.query(Artist.class)).get(0);
        Assert.assertNotNull((Object)artist);
        this.context.invalidateObjects(artist);
        Assert.assertEquals((long)5L, (long)artist.getPersistenceState());
        int queries = this.queryInterceptor.runWithQueryCounter(() -> artist.setArtistName("new name"));
        Assert.assertEquals((long)1L, (long)queries);
        Assert.assertEquals((long)4L, (long)artist.getPersistenceState());
    }

    @Test
    public void testModifyHollow() throws Exception {
        this.createSingleArtistAndPaintingDataSet();
        Painting painting = (Painting)this.context.performQuery(ObjectSelect.query(Painting.class)).get(0);
        Artist artist = painting.getToArtist();
        Assert.assertEquals((long)5L, (long)artist.getPersistenceState());
        Assert.assertNull((Object)artist.readPropertyDirectly("artistName"));
        int queries = this.queryInterceptor.runWithQueryCounter(() -> artist.setDateOfBirth(new Date()));
        Assert.assertEquals((long)1L, (long)queries);
        Assert.assertEquals((long)4L, (long)artist.getPersistenceState());
        Assert.assertNotNull((Object)artist.readPropertyDirectly("artistName"));
    }
}

