/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextPrefetchMultistepIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tExhibit;
    protected TableHelper tGallery;
    protected TableHelper tArtistExhibit;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tExhibit = new TableHelper(this.dbHelper, "EXHIBIT");
        this.tExhibit.setColumns(new String[]{"EXHIBIT_ID", "GALLERY_ID", "OPENING_DATE", "CLOSING_DATE"});
        this.tArtistExhibit = new TableHelper(this.dbHelper, "ARTIST_EXHIBIT");
        this.tArtistExhibit.setColumns(new String[]{"ARTIST_ID", "EXHIBIT_ID"});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
    }

    protected void createTwoArtistsWithExhibitsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tGallery.insert(new Object[]{25, "gallery1"});
        this.tGallery.insert(new Object[]{31, "gallery2"});
        this.tGallery.insert(new Object[]{45, "gallery3"});
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.tExhibit.insert(new Object[]{1, 25, now, now});
        this.tExhibit.insert(new Object[]{2, 31, now, now});
        this.tExhibit.insert(new Object[]{3, 45, now, now});
        this.tExhibit.insert(new Object[]{4, 25, now, now});
        this.tArtistExhibit.insert(new Object[]{11, 2});
        this.tArtistExhibit.insert(new Object[]{11, 4});
        this.tArtistExhibit.insert(new Object[]{101, 1});
        this.tArtistExhibit.insert(new Object[]{101, 2});
        this.tArtistExhibit.insert(new Object[]{101, 4});
    }

    protected void createGalleriesAndArtists() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tGallery.insert(new Object[]{25, "gallery1"});
        this.tGallery.insert(new Object[]{31, "gallery2"});
        this.tGallery.insert(new Object[]{45, "gallery3"});
    }

    @Test
    public void testToManyToManyFirstStepUnresolved() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        this.context.getObjectStore().objectMap = new HashMap<Object, Persistent>();
        HashMap<String, Integer> id1 = new HashMap<String, Integer>();
        id1.put("ARTIST_ID", 11);
        id1.put("EXHIBIT_ID", 2);
        ObjectId oid1 = ObjectId.of("ArtistExhibit", id1);
        HashMap<String, Integer> id2 = new HashMap<String, Integer>();
        id2.put("ARTIST_ID", 101);
        id2.put("EXHIBIT_ID", 2);
        ObjectId oid2 = ObjectId.of("ArtistExhibit", id2);
        Assert.assertNull((Object)this.context.getGraphManager().getNode(oid1));
        Assert.assertNull((Object)this.context.getGraphManager().getNode(oid2));
        List galleries = ObjectSelect.query(Gallery.class).where(Gallery.GALLERY_NAME.eq("gallery2")).prefetch(Gallery.EXHIBIT_ARRAY.dot(Exhibit.ARTIST_EXHIBIT_ARRAY).disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)galleries.size());
        Gallery g2 = (Gallery)galleries.get(0);
        Object list = g2.readPropertyDirectly("exhibitArray");
        Assert.assertTrue((boolean)(list instanceof Fault));
        ArtistExhibit ae1 = (ArtistExhibit)this.context.getGraphManager().getNode(oid1);
        ArtistExhibit ae2 = (ArtistExhibit)this.context.getGraphManager().getNode(oid2);
        Assert.assertNotNull((Object)ae1);
        Assert.assertNotNull((Object)ae2);
        Assert.assertEquals((long)3L, (long)ae1.getPersistenceState());
        Assert.assertEquals((long)3L, (long)ae2.getPersistenceState());
    }

    @Test
    public void testToManyToManyFirstStepResolved() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        List galleries = ObjectSelect.query(Gallery.class).where(Gallery.GALLERY_NAME.eq("gallery2")).prefetch(Gallery.EXHIBIT_ARRAY.disjoint()).prefetch(Gallery.EXHIBIT_ARRAY.dot(Exhibit.ARTIST_EXHIBIT_ARRAY).disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)galleries.size());
        Gallery g2 = (Gallery)galleries.get(0);
        Assert.assertTrue((boolean)(g2.readPropertyDirectly("exhibitArray") instanceof ValueHolder));
        List exhibits = (List)g2.readPropertyDirectly("exhibitArray");
        Assert.assertFalse((boolean)((ValueHolder)((Object)exhibits)).isFault());
        Assert.assertEquals((long)1L, (long)exhibits.size());
        Exhibit e1 = (Exhibit)exhibits.get(0);
        Assert.assertEquals((long)3L, (long)e1.getPersistenceState());
        Assert.assertTrue((boolean)(e1.readPropertyDirectly("artistExhibitArray") instanceof ValueHolder));
        List aexhibits = (List)e1.readPropertyDirectly("artistExhibitArray");
        Assert.assertFalse((boolean)((ValueHolder)((Object)aexhibits)).isFault());
        Assert.assertEquals((long)1L, (long)exhibits.size());
        ArtistExhibit ae1 = (ArtistExhibit)aexhibits.get(0);
        Assert.assertEquals((long)3L, (long)ae1.getPersistenceState());
    }

    @Test
    public void testMixedPrefetch1() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        List galleries = ObjectSelect.query(Gallery.class).where(Gallery.GALLERY_NAME.eq("gallery2")).prefetch(Gallery.EXHIBIT_ARRAY.joint()).prefetch(Gallery.EXHIBIT_ARRAY.dot(Exhibit.ARTIST_EXHIBIT_ARRAY).disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)galleries.size());
        Gallery g2 = (Gallery)galleries.get(0);
        Assert.assertTrue((boolean)(g2.readPropertyDirectly("exhibitArray") instanceof ValueHolder));
        List exhibits = (List)g2.readPropertyDirectly("exhibitArray");
        Assert.assertFalse((boolean)((ValueHolder)((Object)exhibits)).isFault());
        Assert.assertEquals((long)1L, (long)exhibits.size());
        Exhibit e1 = (Exhibit)exhibits.get(0);
        Assert.assertEquals((long)3L, (long)e1.getPersistenceState());
        Assert.assertTrue((boolean)(e1.readPropertyDirectly("artistExhibitArray") instanceof ValueHolder));
        List aexhibits = (List)e1.readPropertyDirectly("artistExhibitArray");
        Assert.assertFalse((boolean)((ValueHolder)((Object)aexhibits)).isFault());
        Assert.assertEquals((long)2L, (long)aexhibits.size());
        ArtistExhibit ae1 = (ArtistExhibit)aexhibits.get(0);
        Assert.assertEquals((long)3L, (long)ae1.getPersistenceState());
    }

    @Test
    public void testMixedPrefetch2() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        ObjectSelect<Gallery> gallerySelect = ObjectSelect.query(Gallery.class).where(Gallery.GALLERY_NAME.eq("gallery2")).prefetch(Gallery.EXHIBIT_ARRAY.disjoint()).prefetch(Gallery.EXHIBIT_ARRAY.dot(Exhibit.ARTIST_EXHIBIT_ARRAY).joint());
        List galleries = gallerySelect.select(this.context);
        Assert.assertEquals((long)1L, (long)galleries.size());
        Gallery g2 = (Gallery)galleries.get(0);
        Assert.assertTrue((boolean)(g2.readPropertyDirectly("exhibitArray") instanceof ValueHolder));
        List exhibits = (List)g2.readPropertyDirectly("exhibitArray");
        Assert.assertFalse((boolean)((ValueHolder)((Object)exhibits)).isFault());
        Assert.assertEquals((long)1L, (long)exhibits.size());
        Exhibit e1 = (Exhibit)exhibits.get(0);
        Assert.assertEquals((long)3L, (long)e1.getPersistenceState());
        Assert.assertTrue((boolean)(e1.readPropertyDirectly("artistExhibitArray") instanceof ValueHolder));
        List aexhibits = (List)e1.readPropertyDirectly("artistExhibitArray");
        Assert.assertFalse((boolean)((ValueHolder)((Object)aexhibits)).isFault());
        Assert.assertEquals((long)2L, (long)aexhibits.size());
        ArtistExhibit ae1 = (ArtistExhibit)aexhibits.get(0);
        Assert.assertEquals((long)3L, (long)ae1.getPersistenceState());
    }

    @Test
    public void testToManyToOne_EmptyToMany() throws Exception {
        this.createGalleriesAndArtists();
        List galleries = ObjectSelect.query(Gallery.class).where(Gallery.GALLERY_NAME.eq("gallery2")).prefetch(Gallery.PAINTING_ARRAY.disjoint()).prefetch(Gallery.PAINTING_ARRAY.dot(Painting.TO_ARTIST).disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)galleries.size());
        Gallery g2 = (Gallery)galleries.get(0);
        Assert.assertTrue((boolean)(g2.readPropertyDirectly(Gallery.PAINTING_ARRAY.getName()) instanceof ValueHolder));
        List exhibits = (List)g2.readPropertyDirectly(Gallery.PAINTING_ARRAY.getName());
        Assert.assertFalse((boolean)((ValueHolder)((Object)exhibits)).isFault());
        Assert.assertEquals((long)0L, (long)exhibits.size());
    }

    @Test
    public void testToManyToOne_EmptyToMany_NoRootQualifier() throws Exception {
        this.createGalleriesAndArtists();
        List galleries = ObjectSelect.query(Gallery.class).prefetch(Gallery.PAINTING_ARRAY.disjoint()).prefetch(Gallery.PAINTING_ARRAY.dot(Painting.TO_ARTIST).disjoint()).select(this.context);
        Assert.assertEquals((long)3L, (long)galleries.size());
        Gallery g = (Gallery)galleries.get(0);
        Assert.assertTrue((boolean)(g.readPropertyDirectly(Gallery.PAINTING_ARRAY.getName()) instanceof ValueHolder));
        List exhibits = (List)g.readPropertyDirectly(Gallery.PAINTING_ARRAY.getName());
        Assert.assertFalse((boolean)((ValueHolder)((Object)exhibits)).isFault());
        Assert.assertEquals((long)0L, (long)exhibits.size());
    }
}

