/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextOuterJoinsIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper artistHelper;
    protected TableHelper paintingHelper;
    protected TableHelper artgroupHelper;
    protected TableHelper artistGroupHelper;

    @Override
    public void cleanUpDB() throws Exception {
        this.dbHelper.update("ARTGROUP").set("PARENT_GROUP_ID", null, 4).execute();
        super.cleanUpDB();
    }

    @Before
    public void setUp() throws Exception {
        this.artistHelper = new TableHelper(this.dbHelper, "ARTIST", new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.paintingHelper = new TableHelper(this.dbHelper, "PAINTING", new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"}).setColumnTypes(new int[]{4, -5, 12});
        this.artgroupHelper = new TableHelper(this.dbHelper, "ARTGROUP", new String[]{"GROUP_ID", "NAME"});
        this.artistGroupHelper = new TableHelper(this.dbHelper, "ARTIST_GROUP", new String[]{"GROUP_ID", "ARTIST_ID"});
    }

    @Test
    public void testSelectWithOuterJoinFlattened() throws Exception {
        this.artistHelper.insert(new Object[]{33001, "AA1"});
        this.artistHelper.insert(new Object[]{33002, "AA2"});
        this.artistHelper.insert(new Object[]{33003, "BB1"});
        this.artistHelper.insert(new Object[]{33004, "BB2"});
        this.artgroupHelper.insert(new Object[]{1, "G1"});
        this.artistGroupHelper.insert(new Object[]{1, 33001});
        this.artistGroupHelper.insert(new Object[]{1, 33002});
        this.artistGroupHelper.insert(new Object[]{1, 33004});
        List artists = ObjectSelect.query(Artist.class).where(Artist.GROUP_ARRAY.outer().isNull()).orderBy(Artist.ARTIST_NAME.asc()).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"BB1", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testSelectWithOuterJoin() throws Exception {
        this.artistHelper.insert(new Object[]{33001, "AA1"});
        this.artistHelper.insert(new Object[]{33002, "AA2"});
        this.artistHelper.insert(new Object[]{33003, "BB1"});
        this.artistHelper.insert(new Object[]{33004, "BB2"});
        this.paintingHelper.insert(new Object[]{33001, 33001, "P1"});
        this.paintingHelper.insert(new Object[]{33002, 33002, "P2"});
        List artists = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.outer().isNull()).orderBy(Artist.ARTIST_NAME.asc()).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertEquals((Object)"BB1", (Object)((Artist)artists.get(0)).getArtistName());
        artists = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.outer().isNull()).or(Artist.ARTIST_NAME.eq("AA1")).orderBy(Artist.ARTIST_NAME.asc()).select(this.context);
        Assert.assertEquals((long)3L, (long)artists.size());
        Assert.assertEquals((Object)"AA1", (Object)((Artist)artists.get(0)).getArtistName());
        Assert.assertEquals((Object)"BB1", (Object)((Artist)artists.get(1)).getArtistName());
        Assert.assertEquals((Object)"BB2", (Object)((Artist)artists.get(2)).getArtistName());
    }

    @Test
    public void testSelectWithOuterJoinFromString() throws Exception {
        this.artistHelper.insert(new Object[]{33001, "AA1"});
        this.artistHelper.insert(new Object[]{33002, "AA2"});
        this.artistHelper.insert(new Object[]{33003, "BB1"});
        this.artistHelper.insert(new Object[]{33004, "BB2"});
        this.paintingHelper.insert(new Object[]{33001, 33001, "P1"});
        this.paintingHelper.insert(new Object[]{33002, 33002, "P2"});
        List artists = ObjectSelect.query(Artist.class).where(ExpressionFactory.exp("paintingArray+ = null", new Object[0])).orderBy(Artist.ARTIST_NAME.asc()).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertEquals((Object)"BB1", (Object)((Artist)artists.get(0)).getArtistName());
        artists = ObjectSelect.query(Artist.class).where(ExpressionFactory.exp("paintingArray+ = null", new Object[0])).or(Artist.ARTIST_NAME.eq("AA1")).orderBy(Artist.ARTIST_NAME.asc()).select(this.context);
        Assert.assertEquals((long)3L, (long)artists.size());
        Assert.assertEquals((Object)"AA1", (Object)((Artist)artists.get(0)).getArtistName());
        Assert.assertEquals((Object)"BB1", (Object)((Artist)artists.get(1)).getArtistName());
        Assert.assertEquals((Object)"BB2", (Object)((Artist)artists.get(2)).getArtistName());
    }

    @Test
    public void testSelectWithOuterOrdering() throws Exception {
        this.artistHelper.insert(new Object[]{33001, "AA1"});
        this.artistHelper.insert(new Object[]{33002, "AA2"});
        this.paintingHelper.insert(new Object[]{33001, 33001, "P1"});
        this.paintingHelper.insert(new Object[]{33002, 33002, "P2"});
        this.paintingHelper.insert(new Object[]{33003, null, "P3"});
        List paintings = ObjectSelect.query(Painting.class).orderBy(Painting.TO_ARTIST.outer().dot(Artist.ARTIST_NAME).desc()).select(this.context);
        Assert.assertEquals((long)3L, (long)paintings.size());
    }
}

