/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextOrderingIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testMultipleOrdering() {
        Calendar c = Calendar.getInstance();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("2");
        a1.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("3");
        a2.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("3");
        a3.setDateOfBirth(c.getTime());
        this.context.commitChanges();
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).orderBy(Artist.ARTIST_NAME.desc(), Artist.DATE_OF_BIRTH.desc());
        List list = query.select(this.context);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertSame((Object)a2, list.get(0));
        Assert.assertSame((Object)a3, list.get(1));
        Assert.assertSame((Object)a1, list.get(2));
    }

    @Test
    public void testMultipleOrderingInSelectClauseCAY_1074() throws Exception {
        Calendar c = Calendar.getInstance();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("2");
        a1.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("3");
        a2.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("3");
        a3.setDateOfBirth(c.getTime());
        Painting p1 = this.context.newObject(Painting.class);
        p1.setEstimatedPrice(new BigDecimal(1));
        p1.setPaintingTitle("Y");
        a1.addToPaintingArray(p1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setEstimatedPrice(new BigDecimal(2));
        p2.setPaintingTitle("X");
        a2.addToPaintingArray(p2);
        this.context.commitChanges();
        ObjectSelect<Artist> query1 = ObjectSelect.query(Artist.class).and(Artist.PAINTING_ARRAY.ne((List)null)).orderBy(Artist.ARTIST_NAME.desc(), Artist.DATE_OF_BIRTH.desc());
        List list1 = query1.select(this.context);
        Assert.assertEquals((long)2L, (long)list1.size());
    }

    @Test
    public void testCustomPropertySort() throws Exception {
        Calendar c = Calendar.getInstance();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("31");
        a1.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("22");
        a2.setDateOfBirth(c.getTime());
        c.add(5, -1);
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("13");
        a3.setDateOfBirth(c.getTime());
        this.context.commitChanges();
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).orderBy(Artist.ARTIST_NAME.substring(2, 1).desc());
        List list = query.select(this.context);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertSame((Object)a3, list.get(0));
        Assert.assertSame((Object)a2, list.get(1));
        Assert.assertSame((Object)a1, list.get(2));
    }
}

