/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Arrays;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.extended_type.ExtendedTypeEntity;
import org.apache.cayenne.testdo.extended_type.StringET1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-extended-type.xml")
public class DataContextExtendedTypeOperationsIT
extends ServerCase {
    @Inject
    protected ObjectContext context;

    @Test
    public void testStoreExtendedType() {
        ExtendedTypeEntity e1 = this.context.newObject(ExtendedTypeEntity.class);
        e1.setName(new StringET1("X"));
        e1.getObjectContext().commitChanges();
        SQLTemplate checkQ = new SQLTemplate(ExtendedTypeEntity.class, "SELECT * FROM EXTENDED_TYPE_TEST WHERE NAME = 'X'");
        checkQ.setFetchingDataRows(true);
        checkQ.setColumnNamesCapitalization(CapsStrategy.UPPER);
        Assert.assertEquals((long)1L, (long)e1.getObjectContext().performQuery(checkQ).size());
    }

    @Test
    public void testInExpressionExtendedTypeArray() {
        ExtendedTypeEntity e1 = this.context.newObject(ExtendedTypeEntity.class);
        e1.setName(new StringET1("X"));
        ExtendedTypeEntity e2 = e1.getObjectContext().newObject(ExtendedTypeEntity.class);
        e2.setName(new StringET1("Y"));
        ExtendedTypeEntity e3 = e1.getObjectContext().newObject(ExtendedTypeEntity.class);
        e3.setName(new StringET1("Z"));
        e1.getObjectContext().commitChanges();
        ObjectSelect<ExtendedTypeEntity> query = ObjectSelect.query(ExtendedTypeEntity.class).where(ExtendedTypeEntity.NAME.in(new StringET1("X"), new StringET1("Y")));
        Assert.assertEquals((long)2L, (long)e1.getObjectContext().performQuery(query).size());
    }

    @Test
    public void testInExpressionExtendedTypeList() {
        ExtendedTypeEntity e1 = this.context.newObject(ExtendedTypeEntity.class);
        e1.setName(new StringET1("X"));
        ExtendedTypeEntity e2 = e1.getObjectContext().newObject(ExtendedTypeEntity.class);
        e2.setName(new StringET1("Y"));
        ExtendedTypeEntity e3 = e1.getObjectContext().newObject(ExtendedTypeEntity.class);
        e3.setName(new StringET1("Z"));
        e1.getObjectContext().commitChanges();
        ObjectSelect<ExtendedTypeEntity> query = ObjectSelect.query(ExtendedTypeEntity.class).where(ExtendedTypeEntity.NAME.in(Arrays.asList(new StringET1("X"), new StringET1("Y"))));
        Assert.assertEquals((long)2L, (long)e1.getObjectContext().performQuery(query).size());
    }
}

