/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLSubqueryIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    private void createTwoArtistsFourPaintings() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tPainting.insert(new Object[]{33001, 33001, "P1", 3000});
        this.tPainting.insert(new Object[]{33002, 33001, "P2", 4000});
        this.tPainting.insert(new Object[]{33003, null, "P1", 5000});
        this.tPainting.insert(new Object[]{33004, null, "P4", 6000});
    }

    @Test
    public void testSubqueryNoQualifier() throws Exception {
        if (!this.accessStackAdapter.supportsAllAnySome()) {
            return;
        }
        this.createTwoArtistsFourPaintings();
        String ejbql = "SELECT DISTINCT p FROM Painting p WHERE p.estimatedPrice = ALL ( SELECT MAX(p1.estimatedPrice) FROM Painting p1)";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33004)));
    }

    @Test
    public void testDifferentEntity() throws Exception {
        this.createTwoArtistsFourPaintings();
        String ejbql = "SELECT a FROM Artist a WHERE EXISTS ( SELECT DISTINCT p1.paintingTitle FROM Painting p1 WHERE p1.toArtist = a)";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(33001L));
        Assert.assertTrue((String)("" + objects.get(0)), (boolean)(objects.get(0) instanceof Artist));
    }

    @Test
    public void testExists() throws Exception {
        this.createTwoArtistsFourPaintings();
        String ejbql = "SELECT p FROM Painting p WHERE EXISTS ( SELECT DISTINCT p1.paintingTitle FROM Painting p1 WHERE p1.paintingTitle = p.paintingTitle AND p.estimatedPrice <> p1.estimatedPrice)";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33001)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33003)));
    }

    @Test
    public void testAll() throws Exception {
        if (!this.accessStackAdapter.supportsAllAnySome()) {
            return;
        }
        this.createTwoArtistsFourPaintings();
        String ejbql = "SELECT p FROM Painting p WHERE p.estimatedPrice > ALL ( SELECT p1.estimatedPrice FROM Painting p1 WHERE p1.paintingTitle = 'P2')";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33003)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33004)));
    }

    @Test
    public void testAny() throws Exception {
        if (!this.accessStackAdapter.supportsAllAnySome()) {
            return;
        }
        this.createTwoArtistsFourPaintings();
        String ejbql = "SELECT p FROM Painting p WHERE p.estimatedPrice > ANY ( SELECT p1.estimatedPrice FROM Painting p1 WHERE p1.paintingTitle = 'P1')";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33002)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33003)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33004)));
    }

    @Test
    public void testSome() throws Exception {
        if (!this.accessStackAdapter.supportsAllAnySome()) {
            return;
        }
        this.createTwoArtistsFourPaintings();
        String ejbql = "SELECT p FROM Painting p WHERE p.estimatedPrice > SOME ( SELECT p1.estimatedPrice FROM Painting p1 WHERE p1.paintingTitle = 'P1')";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)objects.size());
        HashSet<Object> ids = new HashSet<Object>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object id = Cayenne.pkForObject((Persistent)it.next());
            ids.add(id);
        }
        Assert.assertTrue((boolean)ids.contains(new Integer(33002)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33003)));
        Assert.assertTrue((boolean)ids.contains(new Integer(33004)));
    }
}

